package net.invictusslayer.slayersbeasts.registries;

import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.invictusslayer.slayersbeasts.world.entity.*;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_7264;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9168;
import net.minecraft.class_9169;
import net.minecraft.world.entity.*;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SBEntities {
	public static final Supplier<class_1299<Mantis>> MANTIS = register("mantis", class_1299.class_1300.method_5903(Mantis::new, class_1311.field_6302).method_17687(1.6F,1.4F));

	public static final Supplier<class_1299<AntWorker>> ANT_WORKER = register("ant_worker", class_1299.class_1300.method_5903(AntWorker::new, class_1311.field_6303).method_17687(0.7F,0.4F));
	public static final Supplier<class_1299<AntSoldier>> ANT_SOLDIER = register("ant_soldier", class_1299.class_1300.method_5903(AntSoldier::new, class_1311.field_6294).method_17687(1.8F,0.9F));
	public static final Supplier<class_1299<AntQueen>> ANT_QUEEN = register("ant_queen", class_1299.class_1300.method_5903(AntQueen::new, class_1311.field_6294).method_17687(2.2F,1.2F));

	public static final Supplier<class_1299<WitherSpider>> WITHER_SPIDER = register("wither_spider", class_1299.class_1300.method_5903(WitherSpider::new, class_1311.field_6302).method_17687(1.8F,0.7F));
	public static final Supplier<class_1299<Tyrachnid>> TYRACHNID = register("tyrachnid", class_1299.class_1300.method_5903(Tyrachnid::new, class_1311.field_6302).method_17687(3.5F,2F));

	public static final Supplier<class_1299<Damselfly>> DAMSELFLY = register("damselfly", class_1299.class_1300.method_5903(Damselfly::new, class_1311.field_6303).method_17687(0.8F,0.2F));

	public static final Supplier<class_1299<EntMedium>> ENT_MEDIUM = register("ent_medium", class_1299.class_1300.method_5903(EntMedium::new, class_1311.field_6302).method_17687(1.3F,5.4F));
	public static final Supplier<class_1299<Wudu>> WUDU = register("wudu", class_1299.class_1300.method_5903(Wudu::new, class_1311.field_6302).method_17687(1.0F,1.0F));

	public static final Supplier<class_1299<Sporetrap>> SPORETRAP = register("sporetrap", class_1299.class_1300.method_5903(Sporetrap::new, class_1311.field_6302).method_17687(0.8F,1.8F));

	public static final Supplier<class_1299<Irk>> IRK = register("irk", class_1299.class_1300.method_5903(Irk::new, class_1311.field_6302).method_17687(0.7F,0.8F));

	public static final Supplier<class_1299<class_1690>> ASPEN_BOAT = registerBoat("aspen_boat", SBItems.ASPEN_BOAT);
	public static final Supplier<class_1299<class_7264>> ASPEN_CHEST_BOAT = registerChestBoat("aspen_chest_boat", SBItems.ASPEN_CHEST_BOAT);
	public static final Supplier<class_1299<class_1690>> BLOODWOOD_BOAT = registerBoat("bloodwood_boat", SBItems.BLOODWOOD_BOAT);
	public static final Supplier<class_1299<class_7264>> BLOODWOOD_CHEST_BOAT = registerChestBoat("bloodwood_chest_boat", SBItems.BLOODWOOD_CHEST_BOAT);
	public static final Supplier<class_1299<class_1690>> CYPRESS_BOAT = registerBoat("cypress_boat", SBItems.CYPRESS_BOAT);
	public static final Supplier<class_1299<class_7264>> CYPRESS_CHEST_BOAT = registerChestBoat("cypress_chest_boat", SBItems.CYPRESS_CHEST_BOAT);
	public static final Supplier<class_1299<class_1690>> DESERT_OAK_BOAT = registerBoat("desert_oak_boat", SBItems.DESERT_OAK_BOAT);
	public static final Supplier<class_1299<class_7264>> DESERT_OAK_CHEST_BOAT = registerChestBoat("desert_oak_chest_boat", SBItems.DESERT_OAK_CHEST_BOAT);
	public static final Supplier<class_1299<class_1690>> EUCALYPTUS_BOAT = registerBoat("eucalyptus_boat", SBItems.EUCALYPTUS_BOAT);
	public static final Supplier<class_1299<class_7264>> EUCALYPTUS_CHEST_BOAT = registerChestBoat("eucalyptus_chest_boat", SBItems.EUCALYPTUS_CHEST_BOAT);
	public static final Supplier<class_1299<class_1690>> KAPOK_BOAT = registerBoat("kapok_boat", SBItems.KAPOK_BOAT);
	public static final Supplier<class_1299<class_7264>> KAPOK_CHEST_BOAT = registerChestBoat("kapok_chest_boat", SBItems.KAPOK_CHEST_BOAT);
	public static final Supplier<class_1299<class_1690>> REDWOOD_BOAT = registerBoat("redwood_boat", SBItems.REDWOOD_BOAT);
	public static final Supplier<class_1299<class_7264>> REDWOOD_CHEST_BOAT = registerChestBoat("redwood_chest_boat", SBItems.REDWOOD_CHEST_BOAT);
	public static final Supplier<class_1299<class_1690>> WILLOW_BOAT = registerBoat("willow_boat", SBItems.WILLOW_BOAT);
	public static final Supplier<class_1299<class_7264>> WILLOW_CHEST_BOAT = registerChestBoat("willow_chest_boat", SBItems.WILLOW_CHEST_BOAT);
	
	public static <T extends class_1308> void registerSpawns(Consumer<SpawnPlacement<T>> consumer) {
		consumer.accept((SpawnPlacement<T>) new SpawnPlacement<>(MANTIS.get(), class_9169.field_48745, class_2902.class_2903.field_13202, Mantis::canSpawn));
		consumer.accept((SpawnPlacement<T>) new SpawnPlacement<>(ANT_WORKER.get(), class_9169.field_48745, class_2902.class_2903.field_13202, AntWorker::canSpawn));
		consumer.accept((SpawnPlacement<T>) new SpawnPlacement<>(ANT_SOLDIER.get(), class_9169.field_48745, class_2902.class_2903.field_13202, AntSoldier::canSpawn));
		consumer.accept((SpawnPlacement<T>) new SpawnPlacement<>(ANT_QUEEN.get(), class_9169.field_48745, class_2902.class_2903.field_13202, AntQueen::canSpawn));
		consumer.accept((SpawnPlacement<T>) new SpawnPlacement<>(WITHER_SPIDER.get(), class_9169.field_48745, class_2902.class_2903.field_13202, WitherSpider::canSpawn));
		consumer.accept((SpawnPlacement<T>) new SpawnPlacement<>(DAMSELFLY.get(), class_9169.field_48745, class_2902.class_2903.field_13202, Damselfly::canSpawn));
		consumer.accept((SpawnPlacement<T>) new SpawnPlacement<>(ENT_MEDIUM.get(), class_9169.field_48745, class_2902.class_2903.field_13202, EntMedium::canSpawn));
		consumer.accept((SpawnPlacement<T>) new SpawnPlacement<>(SPORETRAP.get(), class_9169.field_48745, class_2902.class_2903.field_13202, Sporetrap::canSpawn));
	}

	public record SpawnPlacement<T extends class_1308>(class_1299<T> entity, class_9168 placement, class_2902.class_2903 heightmap, class_1317.class_4306<T> predicate) {}

	public static void registerAttributes(BiConsumer<class_1299<? extends class_1309>, class_5132> consumer) {
		consumer.accept(MANTIS.get(), Mantis.createAttributes().method_26866());
		consumer.accept(ANT_WORKER.get(), AntWorker.createAttributes().method_26866());
		consumer.accept(ANT_SOLDIER.get(), AntSoldier.createAttributes().method_26866());
		consumer.accept(ANT_QUEEN.get(), AntQueen.createAttributes().method_26866());
		consumer.accept(WITHER_SPIDER.get(), WitherSpider.method_26923().method_26866());
		consumer.accept(TYRACHNID.get(), Tyrachnid.createAttributes().method_26866());
		consumer.accept(DAMSELFLY.get(), Damselfly.createAttributes().method_26866());
		consumer.accept(ENT_MEDIUM.get(), EntMedium.createAttributes().method_26866());
		consumer.accept(WUDU.get(), Wudu.createAttributes().method_26866());
		consumer.accept(SPORETRAP.get(), Sporetrap.createAttributes().method_26866());
		consumer.accept(IRK.get(), Irk.createAttributes().method_26866());
	}

	public static Supplier<class_1299<class_1690>> registerBoat(String name, Supplier<class_1792> item) {
		return register(name, class_1299.class_1300.method_5903((class_1299.class_4049<class_1690>) (type, level) -> new class_1690(type, level, item), class_1311.field_17715).method_63006().method_17687(1.375F, 0.5625F).method_55687(0.5625F).method_27299(10));
	}

	public static Supplier<class_1299<class_7264>> registerChestBoat(String name, Supplier<class_1792> item) {
		return register(name, class_1299.class_1300.method_5903((class_1299.class_4049<class_7264>) (type, level) -> new class_7264(type, level, item), class_1311.field_17715).method_63006().method_17687(1.375F, 0.5625F).method_55687(0.5625F).method_27299(10));
	}

	public static <T extends class_1297> Supplier<class_1299<T>> register(String name, class_1299.class_1300<T> builder) {
		return SlayersBeasts.PLATFORM.register(class_7923.field_41177, SlayersBeasts.MOD_ID, name, () -> builder.method_5905(class_5321.method_29179(class_7924.field_41266, class_2960.method_60655(SlayersBeasts.MOD_ID, name))));
	}

	public static void register() {
		SlayersBeasts.LOGGER.info("Registering SBEntities...");
	}
}
