package net.invictusslayer.slayersbeasts.registries;

import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.invictusslayer.slayersbeasts.world.level.gen.feature.tree.foliage.*;
import net.minecraft.class_4648;
import net.minecraft.class_7923;
import java.util.function.Supplier;

public class SBFoliagePlacers {
    public static final Supplier<class_4648<?>> POINTED_FOLIAGE_PLACER = register("pointed_foliage_placer", () -> new class_4648<>(PointedFoliagePlacer.CODEC));
    public static final Supplier<class_4648<?>> STACKED_FOLIAGE_PLACER = register("stacked_foliage_placer", () -> new class_4648<>(StackedFoliagePlacer.CODEC));
    public static final Supplier<class_4648<?>> CAJOLE_FOLIAGE_PLACER = register("cajole_foliage_placer", () -> new class_4648<>(CajoleFoliagePlacer.CODEC));
    public static final Supplier<class_4648<?>> EUCALYPTUS_FOLIAGE_PLACER = register("eucalyptus_foliage_placer", () -> new class_4648<>(EucalyptusFoliagePlacer.CODEC));
    public static final Supplier<class_4648<?>> REDWOOD_FOLIAGE_PLACER = register("redwood_foliage_placer", () -> new class_4648<>(RedwoodFoliagePlacer.CODEC));
    public static final Supplier<class_4648<?>> WILLOW_FOLIAGE_PLACER = register("willow_foliage_placer", () -> new class_4648<>(WillowFoliagePlacer.CODEC));

    private static <T extends class_4648<?>> Supplier<T> register(String name, Supplier<T> supplier) {
        return SlayersBeasts.PLATFORM.register(class_7923.field_41150, SlayersBeasts.MOD_ID, name, supplier);
    }

    public static void register() {
        SlayersBeasts.LOGGER.info("Registering SBFoliagePlacers...");
    }
}