package net.invictusslayer.slayersbeasts.registries;

import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.invictusslayer.slayersbeasts.world.level.biome.SBBiomes;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_3854;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import java.util.List;
import java.util.function.Supplier;

public class SBVillagerType {
	public static final Supplier<class_3854> CAVE = register("cave", () -> new class_3854("cave"));
//	public static final Supplier<VillagerType> MUSHROOM = register("mushroom", () -> new VillagerType("mushroom"));
//	public static final Supplier<VillagerType> REDWOOD = register("redwood", () -> new VillagerType("redwood"));

	public static void setupBiomes() {
		addBiomes(class_3854.field_17071, SBBiomes.BLACK_DUNES, SBBiomes.DEAD_SANDS, SBBiomes.OUTBACK);
		addBiomes(class_3854.field_17072, SBBiomes.ANCIENT_GROVE, SBBiomes.EUCALYPT_WOODLAND, SBBiomes.RAINFOREST);
		addBiomes(class_3854.field_17074, SBBiomes.BRUSHLAND, SBBiomes.ROCKY_BRUSHLAND, SBBiomes.WOODED_BRUSHLAND);
		addBiomes(class_3854.field_17075, SBBiomes.FROZEN_THICKET, SBBiomes.GLACIATE_SWAMP, SBBiomes.PETRIFIED_WOODS);
		addBiomes(class_3854.field_17076, SBBiomes.BAYOU, SBBiomes.INKY_MOOR);
		addBiomes(class_3854.field_17077, SBBiomes.ASPEN_FOREST);
		addBiomes(CAVE.get(), class_1972.field_29218, class_1972.field_37543, class_1972.field_28107, SBBiomes.SLIME_CAVERNS, SBBiomes.DUSTY_CAVERNS, SBBiomes.ICE_CAVES, SBBiomes.FUNGAL_DEPTHS);
//		addBiomes(MUSHROOM.get(), Biomes.MUSHROOM_FIELDS, SBBiomes.MUSHROOM_FOREST);
//		addBiomes(REDWOOD.get(), SBBiomes.REDWOOD_GROVE, SBBiomes.OLD_GROWTH_REDWOOD_GROVE);
	}

	@SafeVarargs
	private static void addBiomes(class_3854 type, class_5321<class_1959>... biomes) {
		List.of(biomes).forEach(biome -> class_3854.field_17078.put(biome, type));
	}

	private static <T extends class_3854> Supplier<T> register(String name, Supplier<T> supplier) {
		return SlayersBeasts.PLATFORM.register(class_7923.field_41194, SlayersBeasts.MOD_ID, name, supplier);
	}

	public static void register() {
		SlayersBeasts.LOGGER.info("Registering SBVillagerTypes...");
	}
}
