package net.invictusslayer.slayersbeasts.world.entity;

import com.google.common.collect.Lists;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.invictusslayer.slayersbeasts.world.level.block.entity.AnthillBlockEntity;
import net.minecraft.class_11;
import net.minecraft.class_1266;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_7995;
import net.minecraft.world.entity.*;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractAnt extends class_1314 {
	private static final class_2940<Integer> DATA_VARIANT = class_2945.method_12791(AbstractAnt.class, class_2943.field_13327);
	private static final class_2940<Integer> DATA_CARGO_TYPE = class_2945.method_12791(AbstractAnt.class, class_2943.field_13327);
	private int cooldownToEnterNest;
	private int cooldownToLocateNest;
	private int failedForagingTime;
	class_2338 nestPos;
	AntGoToNestGoal antGoToNestGoal;

	public AbstractAnt(class_1299<? extends AbstractAnt> entityType, class_1937 level) {
		super(entityType, level);
	}

	protected void method_5959() {
		super.method_5959();
		field_6201.method_6277(0, new class_1347(this));
		field_6201.method_6277(1, new AntEnterNestGoal(this));
		field_6201.method_6277(2, new AntLocateNestGoal(this));
		antGoToNestGoal = new AntGoToNestGoal(this);
		field_6201.method_6277(3, antGoToNestGoal);
		field_6201.method_6277(4, new class_1394(this, 0.8D));
		field_6201.method_6277(5, new class_1376(this));
		field_6185.method_6277(1, new AntAttackedGoal(this).method_6318());
	}

	public void method_5652(class_2487 tag) {
		super.method_5652(tag);
		if (nestPos != null) tag.method_10566("NestPos", class_2512.method_10692(nestPos));
		tag.method_10569("CooldownToEnterNest", cooldownToEnterNest);
		tag.method_10569("FailedForagingTime", failedForagingTime);
		tag.method_10569("Variant", getVariant().getId());
		tag.method_10569("CargoType", getCargoType());
	}

	public void method_5749(class_2487 tag) {
		super.method_5749(tag);
		nestPos = class_2512.method_10691(tag, "NestPos").orElse(null);
		setCooldownToEnterNest(tag.method_10550("CooldownToEnterNest"));
		failedForagingTime = tag.method_10550("FailedForagingTime");
		setVariant(Variant.byId(tag.method_10550("Variant")));
		setCargoType(tag.method_10550("CargoType"));
	}

	protected void method_5693(class_2945.class_9222 builder) {
		super.method_5693(builder);
		builder.method_56912(DATA_VARIANT, 0);
		builder.method_56912(DATA_CARGO_TYPE, 0);
	}

	public void setCooldownToEnterNest(int cooldown) {
		cooldownToEnterNest = cooldown;
	}

	public int getCargoType() {
		return field_6011.method_12789(DATA_CARGO_TYPE);
	}

	public void setCargoType(int type) {
		if (type != 99) failedForagingTime = 0;
		field_6011.method_12778(DATA_CARGO_TYPE, type);
	}

	public void method_6007() {
		super.method_6007();
		if (cooldownToEnterNest > 0) --cooldownToEnterNest;
		if (cooldownToLocateNest > 0) --cooldownToLocateNest;

		if (getCargoType() == 99) ++failedForagingTime;

		if (field_6012 % 20 == 0 && !hasValidNest()) nestPos = null;
	}

	public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, class_1315 spawnData) {
		Variant variant = getRandomAntType(level);
		if (spawnData instanceof AntGroupData antData) variant = antData.variant;
		else spawnData = new AntGroupData(variant);

		setVariant(variant);
		return spawnData;
	}

	private Variant getRandomAntType(class_1936 level) {
		class_6880<class_1959> holder = level.method_23753(method_24515());
		if (holder.method_40220(SBTags.Biomes.SPAWNS_WOOD_ANTS)) return Variant.WOOD;
		if (holder.method_40220(SBTags.Biomes.SPAWNS_LEAFCUTTER_ANTS)) return Variant.LEAFCUTTER;
		if (holder.method_40220(SBTags.Biomes.SPAWNS_MEADOW_ANTS)) return Variant.MEADOW;
		return Variant.byId(level.method_8409().method_43048(Variant.values().length));
	}

	public static class AntGroupData implements class_1315 {
		private final Variant variant;
		private AntGroupData(Variant variant) {
			this.variant = variant;
		}
	}

	public Variant getVariant() {
		return Variant.byId(field_6011.method_12789(DATA_VARIANT));
	}

	public void setVariant(Variant variant) {
		field_6011.method_12778(DATA_VARIANT, variant.ordinal());
	}

	public enum Variant implements class_3542 {
		WOOD(0, "wood"),
		LEAFCUTTER(1, "leafcutter"),
		MEADOW(2, "meadow");

		private static final IntFunction<Variant> BY_ID = class_7995.method_47914(Variant::getId, values(), class_7995.class_7996.field_41666);
		final int id;
		final String name;

		Variant(int id, String name) {
			this.id = id;
			this.name = name;
		}

		public static Variant byId(int id) {
			return BY_ID.apply(id);
		}

		public int getId() {
			return id;
		}

		public String method_15434() {
			return name;
		}
	}

	public void setNestPos(class_2338 pos) {
		nestPos = pos;
	}
	public class_2338 getNestPos() {
		return nestPos;
	}

	boolean hasValidNest() {
		if (nestPos == null) return false;

		class_2586 blockEntity = method_37908().method_8321(nestPos);
		return blockEntity instanceof AnthillBlockEntity;
	}

	private boolean nestHasSpace(class_2338 nestPos) {
		class_2586 blockEntity = method_37908().method_8321(nestPos);
		if (blockEntity instanceof AnthillBlockEntity anthill) {
			return !anthill.isFull() && (anthill.getInhabitantVariant() == null || anthill.getInhabitantVariant() == getVariant());
		}
		return false;
	}

	protected boolean wantsToEnterNest(AbstractAnt ant) {
		if (cooldownToEnterNest > 0) return false;
		return failedForagingTime > 3600 || getCargoType() != 99 || method_37908().method_8419() || ant instanceof AntQueen;
	}

	boolean closerThan(class_2338 pos, double distance) {
		return pos.method_19771(method_24515(), distance);
	}

	static class AntAttackedGoal extends class_1399 {
		AntAttackedGoal(AbstractAnt ant) {
			super(ant);
		}

		public boolean method_6266() {
			return field_6660 instanceof AntSoldier ant && ant.method_29511() && super.method_6266();
		}

		protected void method_6319(class_1308 mob, class_1309 target) {
			if (mob instanceof AntSoldier soldier && this.field_6660.method_6057(target) && ((AbstractAnt) this.field_6660).getVariant() == soldier.getVariant()) {
				mob.method_5980(target);
			}
		}
	}

	static class AntGoToNestGoal extends class_1352 {
		int travellingTicks;
		final List<class_2338> blacklistedTargets = Lists.newArrayList();
		private class_11 lastPath;
		private int timeStuck;
		private final AbstractAnt ant;

		AntGoToNestGoal(AbstractAnt ant) {
			this.method_6265(EnumSet.of(class_4134.field_18405, class_4134.field_18407));
			this.ant = ant;
			this.travellingTicks = ant.method_37908().field_9229.method_43048(10);
		}

		public boolean method_6264() {
			return ant.nestPos != null && !ant.method_18410() && ant.wantsToEnterNest(ant) && ant.nestHasSpace(ant.nestPos)
					&& !this.hasReachedTarget(ant.nestPos) && ant.method_37908().method_8320(ant.nestPos).method_26164(SBTags.Blocks.ANTHILLS);
		}

		public boolean method_6266() {
			return this.method_6264();
		}

		public void method_6269() {
			travellingTicks = 0;
			timeStuck = 0;
		}

		public void method_6270() {
			travellingTicks = 0;
			timeStuck = 0;
			ant.field_6189.method_6340();
		}

		public void method_6268() {
			if (ant.nestPos != null) {
				++travellingTicks;
				if (travellingTicks > method_38847(600)) {
					blacklistNest();
				} else if (!ant.field_6189.method_23966()) {
					if (!ant.closerThan(ant.nestPos, 16)) {
						if (!ant.closerThan(ant.nestPos, 32)) dropNest();
						else moveToNest(ant.nestPos);
					} else {
						if (!moveToNest(ant.nestPos)) blacklistNest();
						else if (lastPath != null && lastPath.method_41(ant.field_6189.method_6345())) {
							++timeStuck;
							if (timeStuck > 60) {
								dropNest();
								timeStuck = 0;
							}
						} else lastPath = ant.field_6189.method_6345();
					}
				}
			}
		}

		private boolean moveToNest(class_2338 pPos) {
			ant.field_6189.method_6334(ant.field_6189.method_6348(new class_2338(pPos), 0), 1D);
			return ant.field_6189.method_6345() != null && ant.field_6189.method_6345().method_21655();
		}

		private boolean hasReachedTarget(class_2338 target) {
			return ant.method_19538().method_1028(target.method_10263() + 0.5D, target.method_10264() + 1D, target.method_10260() + 0.5D) <= 0.4D;
		}

		private void dropNest() {
			ant.nestPos = null;
			ant.cooldownToLocateNest = 200;
		}

		private void blacklistNest() {
			if (ant.nestPos != null) {
				blacklistedTargets.add(ant.nestPos);
			}
			while (blacklistedTargets.size() > 3) {
				blacklistedTargets.remove(0);
			}
			dropNest();
		}

		boolean isTargetBlacklisted(class_2338 pPos) {
			return blacklistedTargets.contains(pPos);
		}

		void clearBlacklist() {
			blacklistedTargets.clear();
		}
	}

	static class AntEnterNestGoal extends class_1352 {
		private final AbstractAnt ant;

		public AntEnterNestGoal(AbstractAnt ant) {
			method_6265(EnumSet.of(class_4134.field_18405));
			this.ant = ant;
		}

		public boolean method_6264() {
			return ant.nestPos != null && ant.wantsToEnterNest(ant) && ant.nestHasSpace(ant.nestPos) && ant.method_19538()
					.method_1028(ant.nestPos.method_10263() + 0.5D, ant.nestPos.method_10264() + 1D, ant.nestPos.method_10260() + 0.5D) <= 0.4D;
		}

		public boolean method_6266() {
			return false;
		}

		public void method_6269() {
			class_2586 blockEntity = ant.method_37908().method_8321(ant.nestPos);
			if (blockEntity instanceof AnthillBlockEntity anthill) {
				anthill.addOccupant(ant, ant.getVariant());
			}
		}
	}

	static class AntLocateNestGoal extends class_1352 {
		private final AbstractAnt ant;

		public AntLocateNestGoal(AbstractAnt ant) {
			this.ant = ant;
		}

		public boolean method_6264() {
			return ant.cooldownToLocateNest == 0 && ant.nestPos == null && ant.wantsToEnterNest(ant);
		}

		public boolean method_6266() {
			return false;
		}

		public void method_6269() {
			ant.cooldownToLocateNest = 200;
			List<class_2338> list = findNestWithSpace();
			if (list.isEmpty()) return;

			for (class_2338 pos : list) {
				if (!ant.antGoToNestGoal.isTargetBlacklisted(pos)) {
					ant.nestPos = pos;
					return;
				}
			}
			ant.antGoToNestGoal.clearBlacklist();
			ant.nestPos = list.get(0);
		}

		private List<class_2338> findNestWithSpace() {
			class_2338 pos = ant.method_24515();
			class_4153 poiManager = ((class_3218) ant.method_37908()).method_19494();
			Stream<class_4156> stream = poiManager.method_19125(poiType -> poiType.method_40220(SBTags.PoiTypes.ANT_HOME), pos, 20, class_4153.class_4155.field_18489);
			return stream.map(class_4156::method_19141).filter(ant::nestHasSpace).sorted(Comparator.comparingDouble(key -> key.method_10262(pos))).collect(Collectors.toList());
		}
	}
}
