package net.invictusslayer.slayersbeasts.world.entity;

import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_7995;
import net.minecraft.world.entity.ai.goal.*;
import java.util.function.IntFunction;

public abstract class AbstractEnt extends class_1314 {
	private static final class_2940<Integer> DATA_VARIANT = class_2945.method_12791(AbstractEnt.class, class_2943.field_13327);

	public AbstractEnt(class_1299<? extends AbstractEnt> type, class_1937 level) {
		super(type, level);
	}

	public void method_5959() {
		super.method_5959();
		this.field_6201.method_6277(0, new class_1347(this));
		this.field_6201.method_6277(1, new class_1366(this, 1.0D, false));
		this.field_6201.method_6277(2, new class_1394(this, 0.8D));
		this.field_6201.method_6277(3, new class_1361(this, class_1657.class, 8.0F));
		this.field_6201.method_6277(4, new class_1376(this));
		this.field_6185.method_6277(1, new class_1399(this));
	}

	protected class_3414 method_5994() {
		return class_3417.field_14720;
	}
	protected class_3414 method_6002() {
		return class_3417.field_14607;
	}
	protected class_3414 method_6011(class_1282 source) {
		return class_3417.field_15215;
	}

	protected void method_5693(class_2945.class_9222 builder) {
		super.method_5693(builder);
		builder.method_56912(DATA_VARIANT, 0);
	}

	public void method_5652(class_2487 tag) {
		super.method_5652(tag);
		tag.method_10569("Variant", getVariant().getId());
	}

	public void method_5749(class_2487 tag) {
		super.method_5749(tag);
		setVariant(Variant.byId(tag.method_10550("Variant")));
	}

	public void method_5773() {
		super.method_5773();
		if (method_37908().method_8608()) {
			setupAnimationStates();
		}
	}

	protected abstract void setupAnimationStates();

	public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, class_1315 spawnData) {
		Variant variant = getRandomEntType(level);
		if (spawnData instanceof EntGroupData antData) variant = antData.variant;
		else spawnData = new EntGroupData(variant);

		setVariant(variant);
		return spawnData;
	}

	private Variant getRandomEntType(class_1936 level) {
		class_6880<class_1959> holder = level.method_23753(method_24515());
		if (holder.method_40220(SBTags.Biomes.SPAWNS_OAK_ENTS)) return Variant.OAK;
		if (holder.method_40220(SBTags.Biomes.SPAWNS_BIRCH_ENTS)) return Variant.BIRCH;
		return Variant.byId(level.method_8409().method_43048(Variant.values().length));
	}

	public static class EntGroupData implements class_1315 {
		private final Variant variant;
		private EntGroupData(Variant variant) {
			this.variant = variant;
		}
	}

	public Variant getVariant() {
		return Variant.byId(field_6011.method_12789(DATA_VARIANT));
	}

	public void setVariant(Variant variant) {
		field_6011.method_12778(DATA_VARIANT, variant.ordinal());
	}

	public enum Variant implements class_3542 {
		OAK(0, "oak"),
		BIRCH(1, "birch"),
		JUNGLE(2, "jungle");

		private static final IntFunction<Variant> BY_ID = class_7995.method_47914(Variant::getId, values(), class_7995.class_7996.field_41666);
		final int id;
		final String name;

		Variant(int id, String name) {
			this.id = id;
			this.name = name;
		}

		public static Variant byId(int id) {
			return BY_ID.apply(id);
		}

		public int getId() {
			return id;
		}

		public String method_15434() {
			return name;
		}
	}
}
