package net.invictusslayer.slayersbeasts.world.entity;

import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5530;
import net.minecraft.class_5533;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import net.minecraft.class_7995;
import net.minecraft.world.entity.*;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Predicate;

public class Damselfly extends class_1314 {
	private static final class_2940<Integer> DATA_VARIANT = class_2945.method_12791(Damselfly.class, class_2943.field_13327);
	private static final class_2940<Boolean> DATA_IS_FLYING = class_2945.method_12791(Damselfly.class, class_2943.field_13323);
	private static final class_2940<Boolean> DATA_IS_PERCHED = class_2945.method_12791(Damselfly.class, class_2943.field_13323);
	public final class_7094 flyAnimationState = new class_7094();
	public final class_7094 perchAnimationState = new class_7094();
	class_2338 savedPerchPos;
	private int ticksUntilPerch;

	public Damselfly(class_1299<Damselfly> type, class_1937 level) {
		super(type, level);
		field_6207 = new class_1331(this, 20, true);
		field_6189 = method_5965(level);
		resetTicksUntilPerch();
	}

	protected void method_5959() {
		super.method_5959();
		field_6201.method_6277(0, new DamselflyPerchGoal(this));
		field_6201.method_6277(1, new DamselflyWanderGoal(this));
		field_6201.method_6277(2, new class_1347(this));
		field_6201.method_6277(3, new DamselflyHoverGoal(this));
	}

	public static class_5132.class_5133 createAttributes() {
		return class_1308.method_26828()
				.method_26868(class_5134.field_23716, 8.0D)
				.method_26868(class_5134.field_23719, 0.25D)
				.method_26868(class_5134.field_23720, 0.4D);
	}

	public static boolean canSpawn(class_1299<Damselfly> type, class_1936 level, class_3730 reason, class_2338 pos, class_5819 random) {
		return class_1314.method_20636(type, level, reason, pos, random);
	}

	public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, class_1315 spawnData) {
		setVariant(Variant.byId(level.method_8409().method_43048(Variant.values().length)));
		return new DamselflyGroupData();
	}

	protected class_1408 method_5965(class_1937 level) {
		class_1407 navigation = new class_1407(this, level);
		navigation.method_6332(false);
		navigation.method_6354(false);
		navigation.method_6332(true);
		return navigation;
	}

	public void method_6091(class_243 vec3) {
		if (method_6034() || method_5787()) {
			method_5724(method_6029(), vec3);
			method_5784(class_1313.field_6308, method_18798());
			method_18799(method_18798().method_1021(0.5D));
		}
	}

	public void method_5652(class_2487 tag) {
		super.method_5652(tag);
		if (savedPerchPos != null) tag.method_10566("PerchPos", class_2512.method_10692(savedPerchPos));
		tag.method_10569("TicksSincePerch", ticksUntilPerch);
		tag.method_10569("Variant", getVariant().getId());
	}

	public void method_5749(class_2487 tag) {
		super.method_5749(tag);
		savedPerchPos = class_2512.method_10691(tag, "PerchPos").orElse(null);
		ticksUntilPerch = tag.method_10550("TicksSincePerch");
		setVariant(Variant.byId(tag.method_10550("Variant")));
	}

	protected void method_5693(class_2945.class_9222 builder) {
		super.method_5693(builder);
		builder.method_56912(DATA_VARIANT, 0);
		builder.method_56912(DATA_IS_FLYING, false);
		builder.method_56912(DATA_IS_PERCHED, false);
	}

	public Variant getVariant() {
		return Variant.byId(field_6011.method_12789(DATA_VARIANT));
	}

	public void setVariant(Variant variant) {
		field_6011.method_12778(DATA_VARIANT, variant.ordinal());
	}

	public boolean isFlying() {
		return field_6011.method_12789(DATA_IS_FLYING);
	}

	public void setFlying(boolean flying) {
		field_6011.method_12778(DATA_IS_FLYING, flying);
	}

	public boolean isPerched() {
		return field_6011.method_12789(DATA_IS_PERCHED);
	}

	public void setPerched(boolean perched) {
		field_6011.method_12778(DATA_IS_PERCHED, perched);
	}

	public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
		return false;
	}

	protected void method_5623(double y, boolean onGround, class_2680 state, class_2338 pos) {}

	public void resetTicksUntilPerch() {
		ticksUntilPerch = 100 + method_59922().method_43048(100);
	}

	boolean isTooFarAway(class_243 pos) {
		return !pos.method_24802(method_19538(), 32);
	}

	public void method_5773() {
		super.method_5773();
		if (!isPerched()) --ticksUntilPerch;

		if (method_37908().method_8608()) setupAnimationStates();
	}

	private void setupAnimationStates() {
		flyAnimationState.method_45317(isFlying(), field_6012);
		perchAnimationState.method_45317(isPerched(), field_6012);
	}

	static class DamselflyPerchGoal extends class_1352 {
		private final Damselfly mob;
		private int perchTicks;
		private class_243 perchPos;
		private final Predicate<class_2680> VALID_PERCH_BLOCKS = state -> {
			if (state.method_28498(class_2741.field_12508) && state.method_11654(class_2741.field_12508)) {
				return false;
			} else if (state.method_27852(class_2246.field_10214)) {
				return state.method_11654(class_2320.field_10929) == class_2756.field_12609;
			} else {
				return false;
			}
		};

		DamselflyPerchGoal(Damselfly mob) {
			method_6265(EnumSet.of(class_4134.field_18405));
			this.mob = mob;
		}

		public boolean method_6264() {
			if (mob.ticksUntilPerch > 0) {
				return false;
			} else {
				Optional<class_2338> optional = findNearbyPerch();
				if (optional.isPresent()) {
					mob.savedPerchPos = optional.get();
					perchPos = class_243.method_24955(mob.savedPerchPos).method_1031(0.0D, 1.0D, 0.0D);
					perchTicks = 120 + mob.method_59922().method_43048(80);
					return true;
				} else {
					mob.resetTicksUntilPerch();
					return false;
				}
			}
		}

		public boolean method_6266() {
			return perchTicks > 0;
		}

		public boolean method_38846() {
			return true;
		}

		public void method_6270() {
			mob.setPerched(false);
			mob.setFlying(true);
			mob.resetTicksUntilPerch();
		}

		public void method_6268() {
			if (mob.savedPerchPos == null) {
				perchTicks = 0;
			}
			if (mob.method_19538().method_1022(perchPos) <= 0.1D) {
				mob.setFlying(false);
				mob.setPerched(true);
				--perchTicks;
			} else {
				if (mob.field_6189.method_6357()) {
					if (mob.isTooFarAway(perchPos)) {
						mob.savedPerchPos = null;
					} else {
						mob.setFlying(true);
						mob.setPerched(false);
						mob.field_6189.method_6334(mob.field_6189.method_6348(new class_2338((int) perchPos.field_1352, (int) perchPos.field_1351, (int) perchPos.field_1350), 1), 1.0D);
						setWantedPos();
					}
				}
			}
		}

		private void setWantedPos() {
			mob.method_5962().method_6239(perchPos.field_1352, perchPos.field_1351, perchPos.field_1350, 0.4D);
		}

		private Optional<class_2338> findNearbyPerch() {
			return findNearestBlock(VALID_PERCH_BLOCKS);
		}

		private Optional<class_2338> findNearestBlock(Predicate<class_2680> predicate) {
			class_2338 blockPos = mob.method_24515();
			class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();

			for (int y = 0; y <= 5; y = y > 0 ? -y : 1 - y) {
				for (int i = 0; i < 5; ++i) {
					for (int x = 0; x <= i; x = x > 0 ? -x : 1 - x) {
						for (int z = x < i && x > -i ? i : 0; z <= i; z = z > 0 ? -z : 1 - z) {
							mutableBlockPos.method_25504(blockPos, x, y - 1, z);
							if (blockPos.method_19771(mutableBlockPos, 5.0) &&
									predicate.test(mob.method_37908().method_8320(mutableBlockPos))) {
								return Optional.of(mutableBlockPos);
							}
						}
					}
				}
			}

			return Optional.empty();
		}
	}

	static class DamselflyHoverGoal extends class_1352 {
		private final Damselfly mob;
		private int hoverTime;

		DamselflyHoverGoal(Damselfly mob) {
			method_6265(EnumSet.of(class_4134.field_18405));
			this.mob = mob;
		}

		public boolean method_6264() {
			return mob.field_6189.method_6357();
		}

		public boolean method_6266() {
			return mob.field_6189.method_6357() && hoverTime >= 0;
		}

		public void method_6269() {
			mob.setFlying(true);
			hoverTime = 40 + mob.method_59922().method_43048(40);
		}

		public void method_6268() {
			--hoverTime;
		}
	}

	class DamselflyWanderGoal extends class_1352 {
		private final Damselfly mob;

		DamselflyWanderGoal(Damselfly mob) {
			method_6265(EnumSet.of(class_4134.field_18405));
			this.mob = mob;
		}

		public boolean method_6264() {
			return mob.field_6189.method_6357() && mob.field_5974.method_43048(20) == 0;
		}

		public boolean method_6266() {
			return mob.field_6189.method_23966();
		}

		public void method_6269() {
			mob.setFlying(true);
			class_243 vec3 = findPos();
			if (vec3 != null) {
				mob.field_6189.method_6334(mob.field_6189.method_6348(new class_2338((int) vec3.field_1352, (int) vec3.field_1351, (int) vec3.field_1350), 1), 1.0D);
			}
		}

		private class_243 findPos() {
			class_243 vec3 = method_5828(0.0F);
			class_243 pos = class_5533.method_31524(mob, 8, 7, vec3.field_1352, vec3.field_1350, class_3532.field_29844 / 2F, 3, 1);
			return pos != null ? pos : class_5530.method_31504(mob, 8, 4, -2, vec3.field_1352, vec3.field_1350, class_3532.field_29844 / 2F);
		}
	}

	public static class DamselflyGroupData implements class_1315 {
		private DamselflyGroupData() {}
	}

	public enum Variant implements class_3542 {
		BLUE(0, "blue"),
		GREEN(1, "green"),
		YELLOW(2, "yellow");

		private static final IntFunction<Variant> BY_ID = class_7995.method_47914(Variant::getId, values(), class_7995.class_7996.field_41666);
		final int id;
		final String name;

		Variant(int id, String name) {
			this.id = id;
			this.name = name;
		}

		public static Variant byId(int id) {
			return BY_ID.apply(id);
		}

		public int getId() {
			return id;
		}

		public String method_15434() {
			return name;
		}
	}
}
