package net.invictusslayer.slayersbeasts.world.level.biome;

import net.invictusslayer.scabbard.world.biome.BiomeModifierHandler;
import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.invictusslayer.slayersbeasts.registries.SBEntities;
import net.invictusslayer.slayersbeasts.world.level.gen.feature.SBPlacedFeatures;
import net.minecraft.class_1299;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6908;
import java.util.List;

public class SBBiomeModifications {
	public static final BiomeModifierHandler HANDLER = new BiomeModifierHandler(SlayersBeasts.MOD_ID);

	public static void register() {
		addFeature("algae_common", SBTags.Biomes.PLACES_ALGAE_COMMON, class_2893.class_2895.field_13178, SBPlacedFeatures.PATCH_ALGAE_COMMON);
		addFeature("algae_normal", SBTags.Biomes.PLACES_ALGAE_NORMAL, class_2893.class_2895.field_13178, SBPlacedFeatures.PATCH_ALGAE_NORMAL);
		addFeature("default_mushrooms", class_6908.field_37393, class_2893.class_2895.field_13178, SBPlacedFeatures.BLACK_MUSHROOM_RARE, SBPlacedFeatures.WHITE_MUSHROOM_RARE);
		addFeature("mud_pits", class_6908.field_36513, class_2893.class_2895.field_13171, SBPlacedFeatures.MUD_PIT_SHALLOW, SBPlacedFeatures.MUD_PIT_NORMAL, SBPlacedFeatures.MUD_PIT_DEEP);
		addFeature("ore_exoskeleton", class_6908.field_37393, class_2893.class_2895.field_13176, SBPlacedFeatures.ORE_EXOSKELETON);
		addFeature("ore_exoskeleton_lush", SBTags.Biomes.PLACES_EXOSKELETON_LUSH, class_2893.class_2895.field_13176, SBPlacedFeatures.ORE_EXOSKELETON_LUSH);
		addFeature("ore_pegmatite", class_6908.field_37393, class_2893.class_2895.field_13176, SBPlacedFeatures.ORE_PEGMATITE_UPPER, SBPlacedFeatures.ORE_PEGMATITE_LOWER);
		addFeature("trees_river", class_6908.field_36511, class_2893.class_2895.field_13178, SBPlacedFeatures.TREES_RIVER);

		addSpawn("add_mantis", SBTags.Biomes.SPAWNS_MANTIS, SBEntities.MANTIS.get(), 6, 1, 2);
		addSpawn("add_wither_spider", SBTags.Biomes.SPAWNS_WITHER_SPIDER, SBEntities.WITHER_SPIDER.get(), 4, 1, 1);
		addSpawn("add_damselfly", SBTags.Biomes.SPAWNS_DAMSELFLY, SBEntities.DAMSELFLY.get(), 3, 1, 3);
		addSpawn("add_oak_ents", SBTags.Biomes.SPAWNS_OAK_ENTS, SBEntities.ENT_MEDIUM.get(), 4, 1, 1);
	}

	@SafeVarargs
	public static void addFeature(String name, class_6862<class_1959> biomes, class_2893.class_2895 step, class_5321<class_6796>... features) {
		SlayersBeasts.PLATFORM.addFeatureBiomeModifier(HANDLER, name, biomes, step, List.of(features));
	}

	public static void addSpawn(String name, class_6862<class_1959> biomes, class_1299<?> entity, int weight, int min, int max) {
		SlayersBeasts.PLATFORM.addSpawnBiomeModifier(HANDLER, name, biomes, List.of(new class_5483.class_1964(entity, weight, min, max)));
	}
}
