package net.invictusslayer.slayersbeasts.world.level.block;

import com.mojang.serialization.MapCodec;
import net.invictusslayer.slayersbeasts.world.level.block.entity.AnthillBlockEntity;
import net.invictusslayer.slayersbeasts.world.level.block.entity.AnthillHatcheryBlockEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_5558;
import net.invictusslayer.slayersbeasts.world.entity.AntSoldier;
import net.invictusslayer.slayersbeasts.registries.SBBlockEntities;
import java.util.List;

public class AnthillHatcheryBlock extends class_2237 {
	public static final MapCodec<AnthillHatcheryBlock> CODEC = method_54094(AnthillHatcheryBlock::new);
	public static final class_2758 LARVAL_STAGE = class_2758.method_11867("larval_stage", 0, 5);
	public static final class_2758 LARVA = class_2758.method_11867("larva", 0, 3);

	public AnthillHatcheryBlock(class_2251 properties) {
		super(properties);
		this.method_9590(this.field_10647.method_11664().method_11657(LARVAL_STAGE, 0).method_11657(LARVA, 0));
	}

	protected MapCodec<? extends class_2237> method_53969() {
		return field_46280;
	}

	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(LARVAL_STAGE, LARVA);
	}

	public class_2586 method_10123(class_2338 pos, class_2680 state) {
		return new AnthillHatcheryBlockEntity(pos, state);
	}

	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		return method_31618(type, SBBlockEntities.ANTHILL_HATCHERY.get(), AnthillHatcheryBlockEntity::serverTick);
	}

	public class_2464 method_9604(class_2680 pState) {
		return class_2464.field_11458;
	}

	public void angerNearbyAnts(class_1937 level, class_2338 pos) {
		List<AntSoldier> list = level.method_18467(AntSoldier.class, (new class_238(pos)).method_1009(8, 6, 8));
		if (!list.isEmpty()) {
			List<class_1657> players = level.method_18467(class_1657.class, (new class_238(pos)).method_1009(8, 6, 8));
			if (players.isEmpty()) return;
			int i = players.size();

			for (AntSoldier ant : list) {
				if (ant.method_5968() == null) {
					ant.method_5980(players.get(level.field_9229.method_43048(i)));
				}
			}
		}
	}

	public void method_9556(class_1937 level, class_1657 player, class_2338 pos, class_2680 state, class_2586 entity, class_1799 item) {
		super.method_9556(level, player, pos, state, entity, item);
		if (!level.field_9236 && entity instanceof AnthillHatcheryBlockEntity blockEntity) {
			class_2586 base = level.method_8321(blockEntity.getParentNestPos());
			if (base instanceof AnthillBlockEntity anthill) {
				anthill.emptyAntsFromNest(player, anthill.method_11010(), AnthillBlockEntity.AntReleaseStatus.EMERGENCY);
			}

			this.angerNearbyAnts(level, blockEntity.getParentNestPos());
		}
	}
}
