package net.invictusslayer.slayersbeasts.world.level.block;

import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.registries.SBFeatures;
import net.invictusslayer.slayersbeasts.world.level.dimension.SBDimensions;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.SBStructures;
import net.minecraft.class_10225;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2709;
import net.minecraft.class_2794;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3449;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9797;
import net.minecraft.world.level.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CryptPortalBlock extends class_2248 implements class_9797 {
	private static final class_265 SHAPE = class_2248.method_9541(0.0D, 6.0D, 0.0D, 16.0D, 12.0D, 16.0D);
	private static final class_2338 CRYPT_SPAWN_POINT = new class_2338(3, 61, 3);

	public CryptPortalBlock(class_2251 properties) {
		super(properties);
	}

	public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
		return SHAPE;
	}

	public class_2680 method_9559(class_2680 state, class_4538 level, class_10225 access, class_2338 currentPos, class_2350 facing, class_2338 facingPos, class_2680 facingState, class_5819 random) {
		List<class_2338> posList = List.of(currentPos.method_10095(), currentPos.method_10078(), currentPos.method_10072(), currentPos.method_10067());
		for (class_2338 pos : posList) {
			class_2248 block = level.method_8320(pos).method_26204();
			if (block != this && block != SBBlocks.INFUSED_CRYPTALITH.get() && block != SBBlocks.DEPLETED_CRYPTALITH.get()) {
				return class_2246.field_10124.method_9564();
			}
		}

		return super.method_9559(state, level, access, currentPos, facing, facingPos, facingState, random);
	}

	protected class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state, boolean flag) {
		return class_1799.field_8037;
	}

	public boolean method_22358(class_2680 state, class_3611 fluid) {
		return false;
	}

	public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
		if (entity instanceof class_3222 player && player.method_5822(false)) player.method_60697(this, pos);
	}

	private void resetCrypt(class_3218 level) {
		class_2794 chunkGen = level.method_14178().method_12129();
		if (!SBFeatures.CRYPT_FOUNDATION.get().method_40163(new class_3111(), level, chunkGen, level.method_8409(), class_2338.field_10980)) return;

		class_6880<class_3195> crypt = level.method_30349().method_30530(class_7924.field_41246).method_46746(SBStructures.CRYPT).orElseThrow();
		class_3449 start = crypt.comp_349().method_41614(crypt, SBDimensions.CRYPT, level.method_30349(), chunkGen, chunkGen.method_12098(), level.method_14178().method_41248(), level.method_14183(), level.method_8409().method_43048(1000000000), new class_1923(0, 0), 0, level, biome -> true);
		if (!start.method_16657()) return;

		class_3341 boundingBox = start.method_14969();
		class_1923 chunkMin = new class_1923(class_4076.method_18675(boundingBox.method_35415()), class_4076.method_18675(boundingBox.method_35417()));
		class_1923 chunkMax = new class_1923(class_4076.method_18675(boundingBox.method_35418()), class_4076.method_18675(boundingBox.method_35420()));

		class_1923.method_19281(chunkMin, chunkMax).forEach(chunk -> start.method_14974(level, level.method_27056(), chunkGen, level.method_8409(), new class_3341(chunk.method_8326(), level.method_31607(), chunk.method_8328(), chunk.method_8327(), level.method_31600(), chunk.method_8329()), chunkMin));

		Collection<class_1297> entities = new ArrayList<>();
		level.method_27909().forEach(entity -> {
			if (entity instanceof class_1542) {
				entities.add(entity);
			}
		});
		for (class_1297 entity : entities) {
			entity.method_5768(level);
		}
	}

	public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
		double d0 = pos.method_10263() + random.method_43058();
		double d1 = pos.method_10264() + 0.8D;
		double d2 = pos.method_10260() + random.method_43058();
		level.method_8406(class_2398.field_23956, d0, d1, d2, 0.0D, 0.0D, 0.0D);
	}

	public class_5454 method_60770(class_3218 level, class_1297 entity, class_2338 blockPos) {
		class_5321<class_1937> destination = entity.method_37908().method_27983() == SBDimensions.CRYPT ? class_1937.field_25179 : SBDimensions.CRYPT;
		class_3218 serverLevel = level.method_8503().method_3847(destination);
		if (serverLevel == null) return null;

		boolean flag = destination == SBDimensions.CRYPT;
		class_2338 pos = flag ? CRYPT_SPAWN_POINT : serverLevel.method_43126();
		class_243 vec3 = pos.method_61082();
		if (flag) {
			if (serverLevel.method_18456().isEmpty()) resetCrypt(serverLevel);
			return new class_5454(serverLevel, vec3, class_243.field_1353, class_2350.field_11039.method_10144(), 0.0F, class_2709.method_63641(class_2709.field_54094, Set.of(class_2709.field_12397)), class_5454.field_52246.then(class_5454.field_52247));
		}

		if (entity instanceof class_3222 serverPlayer) return serverPlayer.method_60590(false, class_5454.field_52245);
		return new class_5454(serverLevel, vec3, class_243.field_1353, 0.0F, 0.0F, class_2709.method_63641(class_2709.field_54094, class_2709.field_40711), class_5454.field_52246.then(class_5454.field_52247));
	}
}
