package net.invictusslayer.slayersbeasts.world.level.block;

import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1676;
import net.minecraft.class_1685;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5688;
import net.minecraft.class_5691;
import net.minecraft.class_5819;
import net.minecraft.world.level.*;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class IcicleBlock extends class_2248 implements class_5688, class_3737 {
	public static final class_2754<class_2350> TIP_DIRECTION = class_2741.field_28062;
	public static final class_2754<class_5691> THICKNESS = class_2741.field_28063;
	public static final class_2746 WATERLOGGED = class_2741.field_12508;
	private static final class_265 TIP_MERGE_SHAPE = class_2248.method_9541(5.0D, 0.0D, 5.0D, 11.0D, 16.0D, 11.0D);
	private static final class_265 TIP_SHAPE_UP = class_2248.method_9541(5.0D, 0.0D, 5.0D, 11.0D, 11.0D, 11.0D);
	private static final class_265 TIP_SHAPE_DOWN = class_2248.method_9541(5.0D, 5.0D, 5.0D, 11.0D, 16.0D, 11.0D);
	private static final class_265 FRUSTUM_SHAPE = class_2248.method_9541(4.0D, 0.0D, 4.0D, 12.0D, 16.0D, 12.0D);
	private static final class_265 MIDDLE_SHAPE = class_2248.method_9541(3.0D, 0.0D, 3.0D, 13.0D, 16.0D, 13.0D);
	private static final class_265 BASE_SHAPE = class_2248.method_9541(2.0D, 0.0D, 2.0D, 14.0D, 16.0D, 14.0D);
	private static final class_265 DRIP_THROUGH_SPACE = class_2248.method_9541(6.0D, 0.0D, 6.0D, 10.0D, 16.0D, 10.0D);

	public IcicleBlock(class_2251 properties) {
		super(properties);
	}

	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(TIP_DIRECTION, THICKNESS, WATERLOGGED);
	}

	public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
		return isValidPlacement(level, pos, state.method_11654(TIP_DIRECTION));
	}

	public class_2680 method_9559(class_2680 state, class_4538 level, class_10225 access, class_2338 currentPos, class_2350 facing, class_2338 facingPos, class_2680 facingState, class_5819 random) {
		if (state.method_11654(WATERLOGGED)) {
			access.method_64312(currentPos, class_3612.field_15910, class_3612.field_15910.method_15789(level));
		}

		if (facing != class_2350.field_11036 && facing != class_2350.field_11033) return state;

		class_2350 tipDirection = state.method_11654(TIP_DIRECTION);
		if (tipDirection == class_2350.field_11033 && access.method_8397().method_8674(currentPos, this)) {
			return state;
		} else if (facing == tipDirection.method_10153() && !method_9558(state, level, currentPos)) {
			if (tipDirection == class_2350.field_11033) {
				access.method_64310(currentPos, this, 2);
			} else {
				access.method_64310(currentPos, this, 1);
			}
			return state;
		}

		class_5691 thickness = calculateThickness(level, currentPos, tipDirection, state.method_11654(THICKNESS) == class_5691.field_28064);
		return state.method_11657(THICKNESS, thickness);
	}

	public void method_19286(class_1937 level, class_2680 state, class_3965 hit, class_1676 projectile) {
		if (!(level instanceof class_3218 serverLevel)) return;

		class_2338 pos = hit.method_17777();
		if (!level.field_9236 && projectile.method_36971(serverLevel, pos) && projectile instanceof class_1685 && projectile.method_18798().method_1033() > 0.6D) {
			level.method_22352(pos, true);
		}
	}

	public void method_9554(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
		if (state.method_11654(TIP_DIRECTION) == class_2350.field_11036 && state.method_11654(THICKNESS) == class_5691.field_28065) {
			entity.method_5747(fallDistance + 2.0F, 2.0F, level.method_48963().method_48837());
		} else {
			super.method_9554(level, state, pos, entity, fallDistance);
		}
	}

	public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
		if (isIcicleWithDirection(state, class_2350.field_11036) && !method_9558(state, level, pos)) {
			level.method_22352(pos, true);
		} else {
			spawnFallingStalactite(state, level, pos);
		}
	}

	public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
		if (random.method_43057() < 0.0114F && isStalactiteStartPos(state, level, pos)) {
			growStalactiteOrStalagmiteIfPossible(state, level, pos, random);
		}
	}

	public class_2680 method_9605(class_1750 context) {
		class_1936 level = context.method_8045();
		class_2338 clickedPos = context.method_8037();
		class_2350 opposite = context.method_32760().method_10153();
		class_2350 direction = calculateTipDirection(level, clickedPos, opposite);
		if (direction == null) return null;

		boolean flag = !context.method_8046();
		class_5691 thickness = calculateThickness(level, clickedPos, direction, flag);
		return thickness == null ? null : this.method_9564().method_11657(TIP_DIRECTION, direction).method_11657(THICKNESS, thickness).method_11657(WATERLOGGED, level.method_8316(clickedPos).method_15772() == class_3612.field_15910);
	}

	public class_3610 method_9545(class_2680 state) {
		return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
	}

	protected class_265 method_9571(class_2680 state) {
		return class_259.method_1073();
	}

	public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
		class_5691 thickness = state.method_11654(THICKNESS);
		class_265 shape;
		if (thickness == class_5691.field_28064) {
			shape = TIP_MERGE_SHAPE;
		} else if (thickness == class_5691.field_28065) {
			if (state.method_11654(TIP_DIRECTION) == class_2350.field_11033) {
				shape = TIP_SHAPE_DOWN;
			} else {
				shape = TIP_SHAPE_UP;
			}
		} else if (thickness == class_5691.field_28066) {
			shape = FRUSTUM_SHAPE;
		} else if (thickness == class_5691.field_28067) {
			shape = MIDDLE_SHAPE;
		} else {
			shape = BASE_SHAPE;
		}

		class_243 vec3 = state.method_26226(pos);
		return shape.method_1096(vec3.field_1352, 0.0D, vec3.field_1350);
	}

	public boolean method_37403(class_2680 state, class_1922 level, class_2338 pos) {
		return false;
	}

	public float method_32913() {
		return 0.125F;
	}

	public void method_10129(class_1937 level, class_2338 pPos, class_1540 fallingBlock) {
		if (!fallingBlock.method_5701()) {
			level.method_20290(1045, pPos, 0);
		}
	}

	public class_1282 method_32898(class_1297 entity) {
		return entity.method_48923().method_48814(entity);
	}

	private static void spawnFallingStalactite(class_2680 state, class_3218 level, class_2338 pos) {
		class_2338.class_2339 mutableBlockPos = pos.method_25503();

		for (class_2680 blockState = state; isIcicleWithDirection(blockState, class_2350.field_11033); blockState = level.method_8320(mutableBlockPos)) {
			class_1540 fallingBlock = class_1540.method_40005(level, mutableBlockPos, blockState);
			fallingBlock.method_49181();
			if (isTip(blockState, true)) {
				fallingBlock.method_6965(Math.max(1 + pos.method_10264() - mutableBlockPos.method_10264(), 6), 40);
				break;
			}

			mutableBlockPos.method_10098(class_2350.field_11033);
		}
	}

	public static void growStalactiteOrStalagmiteIfPossible(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
		class_2680 aboveState = level.method_8320(pos.method_10086(1));
		class_2680 fluidState = level.method_8320(pos.method_10086(2));
		if (canGrow(aboveState, fluidState)) {
			class_2338 blockPos = findTip(state, level, pos);
			if (blockPos != null) {
				class_2680 tipState = level.method_8320(blockPos);
				if (canDrip(tipState) && canTipGrow(tipState, level, blockPos)) {
					if (random.method_43056()) {
						grow(level, blockPos, class_2350.field_11033);
					} else {
						growStalagmiteBelow(level, blockPos);
					}
				}
			}
		}
	}

	private static void growStalagmiteBelow(class_3218 level, class_2338 pos) {
		class_2338.class_2339 mutableBlockPos = pos.method_25503();

		for (int i = 0; i < 10; ++i) {
			mutableBlockPos.method_10098(class_2350.field_11033);
			class_2680 state = level.method_8320(mutableBlockPos);
			if (!state.method_26227().method_15769()) break;

			if (isUnmergedTipWithDirection(state, class_2350.field_11036) && canTipGrow(state, level, mutableBlockPos)) {
				grow(level, mutableBlockPos, class_2350.field_11036);
				break;
			}
			if (isValidPlacement(level, mutableBlockPos, class_2350.field_11036) && !level.method_22351(mutableBlockPos.method_10074())) {
				grow(level, mutableBlockPos.method_10074(), class_2350.field_11036);
				break;
			}
			if (!canDripThrough(level, mutableBlockPos, state)) {
				break;
			}
		}
	}

	private static void grow(class_3218 level, class_2338 pos, class_2350 direction) {
		class_2338 blockPos = pos.method_10093(direction);
		class_2680 state = level.method_8320(blockPos);
		if (isUnmergedTipWithDirection(state, direction.method_10153())) {
			createMergedTips(state, level, blockPos);
		} else if (state.method_26215() || state.method_27852(class_2246.field_10382)) {
			createIcicle(level, blockPos, direction, class_5691.field_28065);
		}
	}

	private static void createIcicle(class_1936 level, class_2338 pos, class_2350 direction, class_5691 thickness) {
		class_2680 state = SBBlocks.ICICLE.get().method_9564().method_11657(TIP_DIRECTION, direction).method_11657(THICKNESS, thickness).method_11657(WATERLOGGED, level.method_8316(pos).method_15772() == class_3612.field_15910);
		level.method_8652(pos, state, 3);
	}

	private static void createMergedTips(class_2680 state, class_1936 level, class_2338 pos) {
		class_2338 top;
		class_2338 bottom;
		if (state.method_11654(TIP_DIRECTION) == class_2350.field_11036) {
			bottom = pos;
			top = pos.method_10084();
		} else {
			top = pos;
			bottom = pos.method_10074();
		}

		createIcicle(level, top, class_2350.field_11033, class_5691.field_28064);
		createIcicle(level, bottom, class_2350.field_11036, class_5691.field_28064);
	}

	private static class_2338 findTip(class_2680 state, class_1936 level, class_2338 pos) {
		if (isTip(state, false)) return pos;
		class_2350 direction = state.method_11654(TIP_DIRECTION);
		BiPredicate<class_2338, class_2680> biPredicate = (blockPos, blockState) -> blockState.method_27852(SBBlocks.ICICLE.get()) && blockState.method_11654(TIP_DIRECTION) == direction;
		return findBlockVertical(level, pos, direction.method_10171(), biPredicate, blockState -> isTip(blockState, false), 7).orElse(null);
	}

	private static class_2350 calculateTipDirection(class_4538 level, class_2338 pos, class_2350 direction) {
		if (isValidPlacement(level, pos, direction)) return direction;
		if (!isValidPlacement(level, pos, direction.method_10153())) return null;
		return direction.method_10153();
	}

	private static class_5691 calculateThickness(class_4538 level, class_2338 pos, class_2350 direction, boolean isMerged) {
		class_2350 opposite = direction.method_10153();
		class_2680 blockState = level.method_8320(pos.method_10093(direction));
		if (isIcicleWithDirection(blockState, opposite)) {
			return !isMerged && blockState.method_11654(THICKNESS) != class_5691.field_28064 ? class_5691.field_28065 : class_5691.field_28064;
		} else if (!isIcicleWithDirection(blockState, direction)) {
			return class_5691.field_28065;
		} else {
			class_5691 thickness = blockState.method_11654(THICKNESS);
			if (thickness != class_5691.field_28065 && thickness != class_5691.field_28064) {
				class_2680 state = level.method_8320(pos.method_10093(opposite));
				return !isIcicleWithDirection(state, direction) ? class_5691.field_28068 : class_5691.field_28067;
			}
			return class_5691.field_28066;
		}
	}

	public static boolean canDrip(class_2680 state) {
		return isIcicleWithDirection(state, class_2350.field_11033) && state.method_11654(THICKNESS) == class_5691.field_28065 && !state.method_11654(WATERLOGGED);
	}

	private static boolean canTipGrow(class_2680 state, class_3218 level, class_2338 pos) {
		class_2350 direction = state.method_11654(TIP_DIRECTION);
		class_2338 blockPos = pos.method_10093(direction);
		class_2680 blockState = level.method_8320(blockPos);
		if (!blockState.method_26227().method_15769()) return false;

		return blockState.method_26215() || isUnmergedTipWithDirection(blockState, direction.method_10153());
	}

	private static Optional<class_2338> findRootBlock(class_1937 level, class_2338 pos, class_2680 state) {
		class_2350 direction = state.method_11654(TIP_DIRECTION);
		BiPredicate<class_2338, class_2680> biPredicate = (blockPos, blockState) -> blockState.method_27852(SBBlocks.ICICLE.get()) && blockState.method_11654(TIP_DIRECTION) == direction;
		return findBlockVertical(level, pos, direction.method_10153().method_10171(), biPredicate, blockState -> !blockState.method_27852(SBBlocks.ICICLE.get()), 11);
	}

	private static boolean isValidPlacement(class_4538 level, class_2338 pos, class_2350 direction) {
		class_2338 blockPos = pos.method_10093(direction.method_10153());
		class_2680 state = level.method_8320(blockPos);
		return state.method_26206(level, blockPos, direction) || isIcicleWithDirection(state, direction);
	}

	private static boolean isTip(class_2680 state, boolean isMerged) {
		if (!state.method_27852(SBBlocks.ICICLE.get())) return false;
		class_5691 thickness = state.method_11654(THICKNESS);
		return thickness == class_5691.field_28065 || isMerged && thickness == class_5691.field_28064;
	}

	private static boolean isUnmergedTipWithDirection(class_2680 state, class_2350 direction) {
		return isTip(state, false) && state.method_11654(TIP_DIRECTION) == direction;
	}

	private static boolean isStalactiteStartPos(class_2680 state, class_4538 level, class_2338 pos) {
		return isIcicleWithDirection(state, class_2350.field_11033) && !level.method_8320(pos.method_10084()).method_27852(SBBlocks.ICICLE.get());
	}

	public boolean method_9516(class_2680 state, class_10 type) {
		return false;
	}

	private static boolean isIcicleWithDirection(class_2680 state, class_2350 direction) {
		return state.method_27852(SBBlocks.ICICLE.get()) && state.method_11654(TIP_DIRECTION) == direction;
	}

	private static Optional<IcicleBlock.FluidInfo> getFluidAboveStalactite(class_1937 level, class_2338 pos, class_2680 state) {
		return !isIcicleWithDirection(state, class_2350.field_11033) ? Optional.empty() : findRootBlock(level, pos, state).map(blockPos -> {
			class_2338 above = blockPos.method_10084();
			class_2680 blockState = level.method_8320(above);
			class_3611 fluid = level.method_8316(above).method_15772();

			return new IcicleBlock.FluidInfo(above, fluid, blockState);
		});
	}

	private static boolean canGrow(class_2680 icicleState, class_2680 state) {
		return icicleState.method_27852(SBBlocks.ICICLE.get()) && state.method_27852(class_2246.field_10382) && state.method_26227().method_15771();
	}

	private static Optional<class_2338> findBlockVertical(class_1936 level, class_2338 pos, class_2350.class_2352 axis, BiPredicate<class_2338, class_2680> biPredicate, Predicate<class_2680> predicate, int maxIterations) {
		class_2350 direction = class_2350.method_10156(axis, class_2350.class_2351.field_11052);
		class_2338.class_2339 mutableBlockPos = pos.method_25503();

		for(int i = 1; i < maxIterations; ++i) {
			mutableBlockPos.method_10098(direction);
			class_2680 blockstate = level.method_8320(mutableBlockPos);
			if (predicate.test(blockstate)) {
				return Optional.of(mutableBlockPos.method_10062());
			}

			if (level.method_31601(mutableBlockPos.method_10264()) || !biPredicate.test(mutableBlockPos, blockstate)) {
				return Optional.empty();
			}
		}
		return Optional.empty();
	}

	private static boolean canDripThrough(class_1922 level, class_2338 pos, class_2680 state) {
		if (state.method_26215()) {
			return true;
		} else if (state.method_26216() || !state.method_26227().method_15769()) {
			return false;
		}
		return !class_259.method_1074(DRIP_THROUGH_SPACE, state.method_26220(level, pos), class_247.field_16896);
	}

	public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
		if (canDrip(state)) {
			float f = random.method_43057();
			if (f < 0.12F) {
				getFluidAboveStalactite(level, pos, state).filter(info -> f < 0.02F || info.fluid == class_3612.field_15910).ifPresent(info -> spawnDripParticle(level, pos, state));
			}
		}
	}

	private static void spawnDripParticle(class_1937 level, class_2338 pos, class_2680 state) {
		class_243 vec3 = state.method_26226(pos);
		double d1 = (double) pos.method_10263() + 0.5D + vec3.field_1352;
		double d2 = (double) ((float) (pos.method_10264() + 1) - 0.6875F) - 0.0625D;
		double d3 = (double) pos.method_10260() + 0.5D + vec3.field_1350;
		level.method_8406(class_2398.field_28078, d1, d2, d3, 0.0D, 0.0D, 0.0D);
	}

	record FluidInfo(class_2338 pos, class_3611 fluid, class_2680 sourceState) {}
}
