package net.invictusslayer.slayersbeasts.world.level.block;

import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5688;
import net.minecraft.class_5691;
import net.minecraft.class_5819;
import net.minecraft.world.level.*;

public class ObsidianSpikeBlock extends class_2248 implements class_5688, class_3737 {
	public static final class_2754<class_2350> TIP_DIRECTION = class_2741.field_28062;
	public static final class_2754<class_5691> THICKNESS = class_2741.field_28063;
	public static final class_2746 WATERLOGGED = class_2741.field_12508;
	private static final class_265 TIP_MERGE_SHAPE = class_2248.method_9541(6.0D, 0.0D, 6.0D, 10.0D, 16.0D, 10.0D);
	private static final class_265 TIP_SHAPE_UP = class_2248.method_9541(6.0D, 0.0D, 6.0D, 10.0D, 8.0D, 10.0D);
	private static final class_265 TIP_SHAPE_DOWN = class_2248.method_9541(6.0D, 8.0D, 6.0D, 10.0D, 16.0D, 10.0D);
	private static final class_265 FRUSTUM_SHAPE = class_2248.method_9541(4.0D, 0.0D, 4.0D, 12.0D, 16.0D, 12.0D);
	private static final class_265 MIDDLE_SHAPE = class_2248.method_9541(4.0D, 0.0D, 4.0D, 12.0D, 16.0D, 12.0D);
	private static final class_265 BASE_SHAPE = class_2248.method_9541(2.0D, 0.0D, 2.0D, 14.0D, 16.0D, 14.0D);

	public ObsidianSpikeBlock(class_2251 properties) {
		super(properties);
	}

	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(TIP_DIRECTION, THICKNESS, WATERLOGGED);
	}

	public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
		return isValidPlacement(level, pos, state.method_11654(TIP_DIRECTION));
	}

	public class_2680 method_9559(class_2680 state, class_4538 level, class_10225 access, class_2338 currentPos, class_2350 facing, class_2338 facingPos, class_2680 facingState, class_5819 random) {
		if (state.method_11654(WATERLOGGED)) {
			access.method_64312(currentPos, class_3612.field_15910, class_3612.field_15910.method_15789(level));
		}

		if (facing != class_2350.field_11036 && facing != class_2350.field_11033) return state;

		class_2350 tipDirection = state.method_11654(TIP_DIRECTION);
		if (tipDirection == class_2350.field_11033 && access.method_8397().method_8674(currentPos, this)) {
			return state;
		} else if (facing == tipDirection.method_10153() && !method_9558(state, level, currentPos)) {
			if (tipDirection == class_2350.field_11033) {
				access.method_64310(currentPos, this, 2);
			} else {
				access.method_64310(currentPos, this, 1);
			}
			return state;
		}

		class_5691 thickness = calculateThickness(level, currentPos, tipDirection, state.method_11654(THICKNESS) == class_5691.field_28064);
		return state.method_11657(THICKNESS, thickness);
	}

	public void method_9554(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
		if (state.method_11654(TIP_DIRECTION) == class_2350.field_11036 && state.method_11654(THICKNESS) == class_5691.field_28065) {
			entity.method_5747(fallDistance + 2.0F, 2.0F, level.method_48963().method_48837());
		} else {
			super.method_9554(level, state, pos, entity, fallDistance);
		}
	}

	public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
		if (isSpikeWithDirection(state, class_2350.field_11036) && !method_9558(state, level, pos)) {
			level.method_22352(pos, true);
		} else {
			spawnFallingStalactite(state, level, pos);
		}
	}

	public class_2680 method_9605(class_1750 context) {
		class_1936 level = context.method_8045();
		class_2338 pos = context.method_8037();
		class_2350 direction = context.method_32760().method_10153();
		class_2350 tipDirection = calculateTipDirection(level, pos, direction);
		if (tipDirection == null) return null;

		class_5691 thickness = calculateThickness(level, pos, tipDirection, !context.method_8046());
		return thickness == null ? null : method_9564().method_11657(TIP_DIRECTION, tipDirection).method_11657(THICKNESS, thickness).method_11657(WATERLOGGED, level.method_8316(pos).method_15772() == class_3612.field_15910);
	}

	public class_3610 method_9545(class_2680 state) {
		return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
	}

	protected class_265 method_9571(class_2680 state) {
		return class_259.method_1073();
	}

	public class_265 method_9530(class_2680 state, class_1922 getter, class_2338 pos, class_3726 context) {
		class_5691 thickness = state.method_11654(THICKNESS);
		class_265 shape;
		if (thickness == class_5691.field_28064) {
			shape = TIP_MERGE_SHAPE;
		} else if (thickness == class_5691.field_28065) {
			if (state.method_11654(TIP_DIRECTION) == class_2350.field_11033) {
				shape = TIP_SHAPE_DOWN;
			} else {
				shape = TIP_SHAPE_UP;
			}
		} else if (thickness == class_5691.field_28066) {
			shape = FRUSTUM_SHAPE;
		} else if (thickness == class_5691.field_28067) {
			shape = MIDDLE_SHAPE;
		} else {
			shape = BASE_SHAPE;
		}

		class_243 vec3 = state.method_26226(pos);
		return shape.method_1096(vec3.field_1352, 0.0D, vec3.field_1350);
	}

	public boolean method_37403(class_2680 state, class_1922 level, class_2338 pos) {
		return false;
	}

	public float method_32913() {
		return 0.125F;
	}

	public void method_10129(class_1937 level, class_2338 pos, class_1540 fallingBlock) {
		if (!fallingBlock.method_5701()) {
			level.method_20290(1045, pos, 0);
		}
	}

	public class_1282 method_32898(class_1297 entity) {
		return entity.method_48923().method_48814(entity);
	}

	private static void spawnFallingStalactite(class_2680 state, class_3218 level, class_2338 pos) {
		class_2338.class_2339 mutableBlockPos = pos.method_25503();

		for (class_2680 blockState = state; isSpikeWithDirection(blockState, class_2350.field_11033); blockState = level.method_8320(mutableBlockPos)) {
			class_1540 fallingBlock = class_1540.method_40005(level, mutableBlockPos, blockState);
			fallingBlock.method_49181();
			if (isTip(blockState, true)) {
				fallingBlock.method_6965(Math.max(1 + pos.method_10264() - mutableBlockPos.method_10264(), 6), 40);
				break;
			}

			mutableBlockPos.method_10098(class_2350.field_11033);
		}
	}

	private static class_2350 calculateTipDirection(class_4538 level, class_2338 pos, class_2350 direction) {
		if (isValidPlacement(level, pos, direction)) return direction;
		if (!isValidPlacement(level, pos, direction.method_10153())) return null;
		return direction.method_10153();
	}

	private static class_5691 calculateThickness(class_4538 level, class_2338 pos, class_2350 direction, boolean isMerged) {
		class_2350 opposite = direction.method_10153();
		class_2680 state = level.method_8320(pos.method_10093(direction));
		if (isSpikeWithDirection(state, opposite)) {
			return !isMerged && state.method_11654(THICKNESS) != class_5691.field_28064 ? class_5691.field_28065 : class_5691.field_28064;
		} else if (!isSpikeWithDirection(state, direction)) {
			return class_5691.field_28065;
		} else {
			class_5691 thickness = state.method_11654(THICKNESS);
			if (thickness != class_5691.field_28065 && thickness != class_5691.field_28064) {
				class_2680 blockState = level.method_8320(pos.method_10093(opposite));
				return !isSpikeWithDirection(blockState, direction) ? class_5691.field_28068 : class_5691.field_28067;
			}
			return class_5691.field_28066;
		}
	}

	private static boolean isValidPlacement(class_4538 level, class_2338 pos, class_2350 direction) {
		class_2338 blockPos = pos.method_10093(direction.method_10153());
		class_2680 state = level.method_8320(blockPos);
		return state.method_26206(level, blockPos, direction) || isSpikeWithDirection(state, direction);
	}

	private static boolean isTip(class_2680 state, boolean isMerged) {
		if (!state.method_27852(SBBlocks.OBSIDIAN_SPIKE.get())) return false;

		class_5691 thickness = state.method_11654(THICKNESS);
		return thickness == class_5691.field_28065 || (isMerged && thickness == class_5691.field_28064);
	}

	public boolean method_9516(class_2680 state, class_10 type) {
		return false;
	}

	private static boolean isSpikeWithDirection(class_2680 state, class_2350 direction) {
		return state.method_27852(SBBlocks.OBSIDIAN_SPIKE.get()) && state.method_11654(TIP_DIRECTION) == direction;
	}
}
