package net.invictusslayer.slayersbeasts.world.level.block.entity;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.invictusslayer.slayersbeasts.registries.SBBlockEntities;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.registries.SBDataComponents;
import net.invictusslayer.slayersbeasts.registries.SBEntities;
import net.invictusslayer.slayersbeasts.world.entity.AbstractAnt;
import net.invictusslayer.slayersbeasts.world.entity.AntQueen;
import net.invictusslayer.slayersbeasts.world.entity.AntSoldier;
import net.invictusslayer.slayersbeasts.world.level.block.AnthillBlock;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3730;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import java.util.*;

public class AnthillBlockEntity extends class_2586 {
	private static final List<String> IGNORED_ANT_TAGS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain",
			"CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems",
			"HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "OnGround", "PortalCooldown", "Pos", "Rotation",
			"CooldownToEnterNest", "CooldownToLocateNest", "FailedForagingTime", "NestPos", "Passengers", "Leash", "UUID");
	private final List<AntData> storedAnts = new ArrayList<>();
	private final Map<class_2338, UpgradeData> nestUpgrades = new HashMap<>();
	private AbstractAnt.Variant inhabitantVariant;
	private boolean hasQueen;

	public AnthillBlockEntity(class_2338 pos, class_2680 state) {
		super(SBBlockEntities.ANTHILL.get(), pos, state);
		inhabitantVariant = null;
	}

	protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
		super.method_11007(tag, registries);
		tag.method_10566("Ants", Occupant.LIST_CODEC.encodeStart(class_2509.field_11560, getAnts()).getOrThrow());
		tag.method_10566("Upgrades", writeUpgrades());
		if (getInhabitantVariant() != null) tag.method_10569("InhabitantType", getInhabitantVariant().getId());
		tag.method_10556("HasQueen", hasQueen);
	}

	private List<Occupant> getAnts() {
		return storedAnts.stream().map(AntData::toOccupant).toList();
	}

	public class_2499 writeUpgrades() {
		class_2499 listTag = new class_2499();

		for (UpgradeData data : nestUpgrades.values()) {
			class_2487 tag = new class_2487();
			tag.method_10569("UpgradeType", data.upgradeType);
			tag.method_10566("BlockPos", class_2512.method_10692(data.pos));
			listTag.add(tag);
		}
		return listTag;
	}

	public void method_11014(class_2487 tag, class_7225.class_7874 registries) {
		super.method_11014(tag, registries);
		storedAnts.clear();
		nestUpgrades.clear();
		class_2499 upgradeList = tag.method_10554("Upgrades", 10);

		if (tag.method_10545("ants")) Occupant.LIST_CODEC.parse(class_2509.field_11560, tag.method_10580("ants")).resultOrPartial(s ->
				SlayersBeasts.LOGGER.error("Failed to parse Ants: {}", s)).ifPresent(list -> list.forEach(this::storeAnt));

		for (int j = 0; j < upgradeList.size(); ++j) {
			class_2487 tag1 = upgradeList.method_10602(j);
			class_2338 pos = class_2512.method_10691(tag1, "BlockPos").orElse(null);
			UpgradeData data = new UpgradeData(tag1.method_10550("UpgradeType"), pos);
			nestUpgrades.put(pos, data);
		}

		setInhabitantVariant(tag.method_10545("InhabitantType") ? AbstractAnt.Variant.byId(tag.method_10550("InhabitantType")) : null);
		hasQueen = tag.method_10577("HasQueen");
	}

	protected void method_57568(class_2586.class_9473 componentInput) {
		super.method_57568(componentInput);
		storedAnts.clear();
		List<Occupant> list = componentInput.method_58695(SBDataComponents.ANTS.get(), List.of());
		list.forEach(this::storeAnt);
	}

	protected void method_57567(class_9323.class_9324 components) {
		super.method_57567(components);
		components.method_57840(SBDataComponents.ANTS.get(), getAnts());
	}

	@SuppressWarnings("deprecation")
	public void method_57569(class_2487 tag) {
		super.method_57569(tag);
		tag.method_10551("ants");
	}

	public static int getFungusLevel(class_2680 state) {
		return state.method_11654(AnthillBlock.FUNGUS_LEVEL);
	}
	public static int getSupplyLevel(class_2680 state) {
		return state.method_11654(AnthillBlock.SUPPLY_LEVEL);
	}

	public boolean isEmpty() {
		return storedAnts.isEmpty();
	}
	public boolean isFull() {
		return storedAnts.size() == 10;
	}

	public AbstractAnt.Variant getInhabitantVariant() {
		return inhabitantVariant;
	}

	public void setInhabitantVariant(AbstractAnt.Variant variant) {
		inhabitantVariant = variant;
	}

	public static void serverTick(class_1937 level, class_2338 pos, class_2680 blockState, AnthillBlockEntity entity) {
		tickOccupants(level, pos, blockState, entity.storedAnts);
		tickExpansionsAndUpgrades(level, pos, blockState, entity);
	}

	private static void tickOccupants(class_1937 level, class_2338 pos, class_2680 blockState, List<AntData> dataList) {
		boolean flag = false;
		Iterator<AntData> iterator = dataList.iterator();
		while (iterator.hasNext()) {
			AntData data = iterator.next();
			if (data.isQueen()) continue;
			if (data.tick()) {
				AntReleaseStatus releaseStatus = data.hasCargo() ? AntReleaseStatus.CARGO_DELIVERED : AntReleaseStatus.ANT_RELEASED;
				if (releaseOccupant(level, pos, blockState, data.toOccupant(), null, releaseStatus)) {
					flag = true;
					iterator.remove();
				}
			}
		}

		if (flag) method_31663(level, pos, blockState);
	}

	private static void tickExpansionsAndUpgrades(class_1937 level, class_2338 pos, class_2680 blockState, AnthillBlockEntity blockEntity) {
		if (level.method_8510() % 200 == 0) {
			int blockType = 1;

			List<class_2338> list = blockEntity.scanNest(level, pos, null, SBTags.Blocks.ANTHILLS);
			Set<class_2338> set = blockEntity.nestUpgrades.keySet();

			for (class_2338 pos1 : list) set.remove(pos1);
			for (class_2338 pos1 : set) blockEntity.nestUpgrades.remove(pos1);
			if (!set.isEmpty()) blockEntity.emptyAntsFromNest(null, blockState, AntReleaseStatus.PATROLLING);

			for (UpgradeData data : blockEntity.nestUpgrades.values()) {
				class_2586 blockEntity1 = level.method_8321(data.pos);
				if (data.upgradeType == 1) {
					if (blockEntity1 instanceof AnthillHatcheryBlockEntity hatchery) {
						if (blockEntity.hasQueen) {
							hatchery.storeEgg(level, data.pos);
						}
					}
				}
			}

			int i = getSupplyLevel(blockState);
			if (i >= 5) {
				blockEntity.upgradeNest(level, pos, blockState, blockType);
			} else if (i >= 3) {
				blockEntity.expandNest(level, pos, blockState);
			}
		}
	}

	private void upgradeNest(class_1937 level, class_2338 nestPos, class_2680 blockState, int upgradeType) {
		List<class_2338> posList = scanNest(level, nestPos, SBBlocks.ARIDISOL.get(), null);
		if (posList.isEmpty() || nestUpgrades.size() > 5) return;

		class_2338 blockPos = posList.get(level.field_9229.method_43048(posList.size()));

		class_2248 block = upgradeType == 1 ? SBBlocks.ANTHILL_HATCHERY.get() : SBBlocks.ARIDISOL.get();

		nestUpgrades.put(blockPos, new UpgradeData(upgradeType, blockPos));
		level.method_8652(nestPos, blockState.method_11657(AnthillBlock.SUPPLY_LEVEL, getSupplyLevel(blockState) - 5), 3);
		level.method_8501(blockPos, block.method_9564());
		method_31663(level, nestPos, blockState);
		if (level.method_8321(blockPos) instanceof BaseAnthillBlockEntity blockEntity) {
			blockEntity.setParentNestPos(nestPos);
		}
	}

	private void expandNest(class_1937 level, class_2338 nestPos, class_2680 blockState) {
		List<class_2338> posList = scanNest(level, nestPos, null, SBTags.Blocks.ANTHILL_REPLACEABLE);
		if (posList.isEmpty()) return;

		class_2338 blockPos = posList.get(level.field_9229.method_43048(posList.size()));
		level.method_8501(blockPos, SBBlocks.ARIDISOL.get().method_9564());
		level.method_8652(nestPos, blockState.method_11657(AnthillBlock.SUPPLY_LEVEL, getSupplyLevel(blockState) - 3), 3);
		method_31663(level, nestPos, blockState);
	}

	private List<class_2338> scanNest(class_1937 level, class_2338 nestPos, class_2248 block, class_6862<class_2248> blocks) {
		List<class_2338> posList = new ArrayList<>();
		for (int y = 0; y > -4; y--) {
			int radius = y + 5;
			if (nestPos.method_10264() + y < level.method_31607()) break;

			for (int x = -radius; x <= radius; x++) {
				for (int z = -radius; z <= radius; z++) {
					class_2338 tempBlockPos = method_11016().method_10069(x, y, z);
					if ((x * x) + (z * z) <= (radius * radius) && !nestPos.equals(tempBlockPos)) {
						if (level.method_8320(tempBlockPos).method_27852(block) || level.method_8320(tempBlockPos).method_26164(blocks)) {
							posList.add(tempBlockPos);
						}
					}
				}
			}
		}
		return posList;
	}

	public void emptyAntsFromNest(class_1657 player, class_2680 blockState, AntReleaseStatus releaseStatus) {
		List<class_1297> entities = releaseAllOccupants(blockState, releaseStatus);
		if (player != null) {
			for (class_1297 entity : entities) if (entity instanceof AbstractAnt ant) ant.setCooldownToEnterNest(400);
		}
		if (isEmpty()) setInhabitantVariant(null);
	}

	private List<class_1297> releaseAllOccupants(class_2680 state, AntReleaseStatus releaseStatus) {
		List<class_1297> list = new ArrayList<>();
		if (field_11863 != null) {
			storedAnts.removeIf(data -> releaseOccupant(field_11863, field_11867, state, data.toOccupant(), list, releaseStatus));
		}
		if (!list.isEmpty()) {
			super.method_5431();
		}

		return list;
	}

	private static boolean releaseOccupant(class_1937 level, class_2338 pos, class_2680 state, Occupant occupant, List<class_1297> storedInNest, AntReleaseStatus releaseStatus) {
		if (level.method_8419() && releaseStatus != AntReleaseStatus.EMERGENCY) return false;

		class_2338 above = pos.method_10084();
		boolean flag = level.method_8320(above).method_26220(level, above).method_1110();
		if (!flag && releaseStatus != AntReleaseStatus.EMERGENCY) return false;

//		CompoundTag compoundTag = occupant.entityData.copyTag();
//		removeIgnoredAntTags(compoundTag);
//		compoundTag.put("NestPos", NbtUtils.writeBlockPos(pos));

		class_1297 entity = occupant.createEntity(level, pos);
		if (entity == null) return false;
		if (!entity.method_5864().method_20210(SBTags.EntityTypes.ANTHILL_INHABITANTS)) return false;
		if (releaseStatus == AntReleaseStatus.PATROLLING && !(entity instanceof AntSoldier)) return false;

		if (entity instanceof AbstractAnt ant) {

			if (releaseStatus == AntReleaseStatus.CARGO_DELIVERED) {
				int cargo = ant.getCargoType();
				ant.setCargoType(99);
				if (cargo == 1) {
					if (state.method_27851(SBTags.Blocks.ANTHILLS, stateBase -> stateBase.method_28498(AnthillBlock.FUNGUS_LEVEL))) {
						int i = getFungusLevel(state);
						if (i < 8) {
							level.method_8501(pos, state.method_11657(AnthillBlock.FUNGUS_LEVEL, i + 1));
						}
					}
				} else if (cargo == 2) {
					if (state.method_27851(SBTags.Blocks.ANTHILLS, stateBase -> stateBase.method_28498(AnthillBlock.SUPPLY_LEVEL))) {
						int i = getSupplyLevel(state);
						if (i < 15) {
							level.method_8501(pos, state.method_11657(AnthillBlock.SUPPLY_LEVEL, i + 1));
						}
					}
				}
			}

			if (storedInNest != null) {
				storedInNest.add(ant);
			}

			double width = flag ? 0 : 0.55D + ant.method_17681() * 0.5D;
			ant.method_5808(pos.method_10263() + 0.5D + width, pos.method_10264() + 1D, pos.method_10260() + 0.5D + width, ant.method_36454(), ant.method_36455());
		}

		level.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286(entity, level.method_8320(pos)));
		return level.method_8649(entity);
	}

	public void addOccupant(class_1297 entity, AbstractAnt.Variant variant) {
		setInhabitantVariant(variant);
		if (storedAnts.size() >= 10) return;
		entity.method_5848();
		entity.method_5772();
		class_2487 tag = new class_2487();
		entity.method_5662(tag);
		storeAnt(Occupant.of(entity));
		if (field_11863 != null) field_11863.method_43276(class_5712.field_28733, method_11016(), class_5712.class_7397.method_43286(entity, method_11010()));

		entity.method_31472();
		super.method_5431();
	}

	public void storeAnt(Occupant occupant) {
		storedAnts.add(new AntData(occupant));
	}

	public record Occupant(class_9279 entityData, int ticksInNest, int minTicksInNest, boolean isQueen) {
		public static final Codec<Occupant> CODEC = RecordCodecBuilder.create(instance -> instance.group(
				class_9279.field_49303.optionalFieldOf("entity_data", class_9279.field_49302).forGetter(Occupant::entityData),
				Codec.INT.fieldOf("ticks_in_nest").forGetter(Occupant::ticksInNest),
				Codec.INT.fieldOf("min_ticks_in_nest").forGetter(Occupant::minTicksInNest),
				Codec.BOOL.fieldOf("is_queen").forGetter(Occupant::isQueen)
		).apply(instance, Occupant::new));
		public static final Codec<List<Occupant>> LIST_CODEC = CODEC.listOf();
		@SuppressWarnings("deprecation")
		public static final class_9139<ByteBuf, Occupant> STREAM_CODEC = class_9139.method_56905(class_9279.field_49305, Occupant::entityData,
				class_9135.field_48550, Occupant::ticksInNest, class_9135.field_48550, Occupant::minTicksInNest, class_9135.field_48547, Occupant::isQueen, Occupant::new);

		public static Occupant of(class_1297 entity) {
			class_2487 tag = new class_2487();
			entity.method_5662(tag);
			Objects.requireNonNull(tag);
			IGNORED_ANT_TAGS.forEach(tag::method_10551);
			boolean bl = tag.method_10577("HasNectar");
			return new Occupant(class_9279.method_57456(tag), 0, bl ? 2400 : 600, entity instanceof AntQueen);
		}

		public static Occupant create(int ticksInNest) {
			class_2487 tag = new class_2487();
			tag.method_10582("id", class_7923.field_41177.method_10221(SBEntities.ANT_WORKER.get()).toString());
			return new Occupant(class_9279.method_57456(tag), ticksInNest, 600, false);
		}

		public class_1297 createEntity(class_1937 level, class_2338 pos) {
			class_2487 tag = entityData.method_57461();
			Objects.requireNonNull(tag);
			IGNORED_ANT_TAGS.forEach(tag::method_10551);
			class_1297 entity = class_1299.method_17842(tag, level, class_3730.field_52444, entity1 -> entity1);
			if (entity != null && entity.method_5864().method_20210(SBTags.EntityTypes.ANTHILL_INHABITANTS)) {
//				entity.setNoGravity(true);
				if (entity instanceof AbstractAnt ant) {
					ant.setNestPos(pos);
				}

				return entity;
			}
			return null;
		}

		public class_9279 entityData() {
			return entityData;
		}

		public int ticksInNest() {
			return ticksInNest;
		}

		public int minTicksInNest() {
			return minTicksInNest;
		}
	}

	private static class AntData {
		private final Occupant occupant;
		private int ticksInNest;

		AntData(Occupant occupant) {
			this.occupant = occupant;
			this.ticksInNest = occupant.ticksInNest();
		}

		public boolean tick() {
			return ticksInNest++ > occupant.minTicksInNest();
		}

		public Occupant toOccupant() {
			return new Occupant(occupant.entityData(), ticksInNest, occupant.ticksInNest(), occupant.isQueen());
		}

		public boolean isQueen() {
			return occupant.isQueen();
		}

		@SuppressWarnings("deprecation")
		public boolean hasCargo() {
			return occupant.entityData().method_57463().method_10577("HasCargo");
		}
	}

	record UpgradeData(int upgradeType, class_2338 pos) { }

	public enum AntReleaseStatus {
		CARGO_DELIVERED,
		ANT_RELEASED,
		PATROLLING,
		EMERGENCY
	}
}
