package net.invictusslayer.slayersbeasts.world.level.gen.feature.icicle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5721;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5861;
import net.minecraft.class_5863;
import net.minecraft.class_6017;
import java.util.Optional;
import java.util.OptionalInt;

public class IcicleClusterFeature extends class_3031<IcicleClusterFeature.Configuration> {
	public IcicleClusterFeature(Codec<Configuration> codec) {
		super(codec);
	}

	public boolean method_13151(class_5821<Configuration> context) {
		class_5281 level = context.method_33652();
		class_2338 origin = context.method_33655();
		Configuration config = context.method_33656();
		class_5819 random = context.method_33654();

		if (!IcicleUtils.isEmptyOrWater(level, origin)) return false;

		int height = config.height.method_35008(random);
		float lightChance = config.lightChance.method_33920(random);
		float density = config.density.method_33920(random);
		int xRadius = config.radius.method_35008(random);
		int zRadius = config.radius.method_35008(random);

		for (int x = -xRadius; x <= xRadius; ++x) {
			for (int z = -zRadius; z <= zRadius; ++z) {
				class_2338 blockPos = origin.method_10069(x, 0, z);
				double chance = getChanceOfIcicle(xRadius, zRadius, x, z, config);
				placeColumn(level, random, blockPos, x, z, lightChance, chance, height, density, config);
			}
		}
		return true;
	}

	private void placeColumn(class_5281 level, class_5819 random, class_2338 pos, int x, int z, float lightChance, double chance, int height, float density, Configuration config) {
		Optional<class_5721> optional = class_5721.method_32982(level, pos, config.caveHeightSearchRange, IcicleUtils::isEmptyOrWater, IcicleUtils::isNeitherEmptyNorWater);
		if (optional.isPresent()) {
			OptionalInt ceiling = optional.get().method_32985();
			OptionalInt floor = optional.get().method_32987();
			if (ceiling.isPresent() || floor.isPresent()) {
				class_5721 column = optional.get();

				if (random.method_43057() < lightChance && floor.isPresent() && canPlaceLight(level, pos.method_33096(floor.getAsInt()))) {
					level.method_8652(pos.method_33096(floor.getAsInt()), SBBlocks.GLEAMING_ICE.get().method_9564(), 2);
				}

				OptionalInt columnFloor = column.method_32987();
				int j = 0;
				if (ceiling.isPresent() && random.method_43058() < chance && notLava(level, pos.method_33096(ceiling.getAsInt()))) {
					int k = config.layerThickness.method_35008(random);
					replaceBlocksWithIce(level, pos.method_33096(ceiling.getAsInt()), k, class_2350.field_11036);
					int l;
					if (columnFloor.isPresent()) {
						l = Math.min(height, ceiling.getAsInt() - columnFloor.getAsInt());
					} else {
						l = height;
					}

					j = getIcicleHeight(random, x, z, density, l, config);
				}

				int i3;
				if (columnFloor.isPresent() && random.method_43058() < chance && notLava(level, pos.method_33096(columnFloor.getAsInt()))) {
					int i1 = config.layerThickness.method_35008(random);
					this.replaceBlocksWithIce(level, pos.method_33096(columnFloor.getAsInt()), i1, class_2350.field_11033);
					if (ceiling.isPresent()) {
						i3 = Math.max(0, j + class_3532.method_32751(random, -config.maxHeightDifference, config.maxHeightDifference));
					} else {
						i3 = getIcicleHeight(random, x, z, density, height, config);
					}
				} else {
					i3 = 0;
				}

				int j1;
				int j3;
				if (ceiling.isPresent() && columnFloor.isPresent() && ceiling.getAsInt() - j <= columnFloor.getAsInt() + i3) {
					int k1 = columnFloor.getAsInt();
					int l1 = ceiling.getAsInt();
					int i2 = Math.max(l1 - j, k1 + 1);
					int j2 = Math.min(k1 + i3, l1 - 1);
					int k2 = class_3532.method_32751(random, i2, j2 + 1);
					int l2 = k2 - 1;
					j3 = l1 - k2;
					j1 = l2 - k1;
				} else {
					j3 = j;
					j1 = i3;
				}

				boolean flag3 = random.method_43056() && j3 > 0 && j1 > 0 && column.method_33385().isPresent() && j3 + j1 == column.method_33385().getAsInt();
				if (ceiling.isPresent()) {
					IcicleUtils.growIcicle(level, pos.method_33096(ceiling.getAsInt() - 1), class_2350.field_11033, j3, flag3);
				}

				if (columnFloor.isPresent()) {
					IcicleUtils.growIcicle(level, pos.method_33096(columnFloor.getAsInt() + 1), class_2350.field_11036, j1, flag3);
				}

			}
		}
	}

	private boolean notLava(class_4538 level, class_2338 pos) {
		return !level.method_8320(pos).method_27852(class_2246.field_10164);
	}

	private int getIcicleHeight(class_5819 random, int x, int z, float chance, int height, Configuration config) {
		if (random.method_43057() > chance) return 0;

		int i = Math.abs(x) + Math.abs(z);
		float mean = (float) class_3532.method_32854(i, 0.0D, config.maxRadiusAffectingHeightBias, height / 2.0D, 0.0D);
		return (int) class_5861.method_33903(random, mean, config.heightDeviation, 0, (float) height);
	}

	private boolean canPlaceLight(class_5281 level, class_2338 pos) {
		class_2680 state = level.method_8320(pos);
		if (state.method_27852(class_2246.field_10382) || state.method_27852(class_2246.field_10225) || state.method_27852(SBBlocks.ICICLE.get())) return false;
		if (level.method_8320(pos.method_10084()).method_26227().method_15767(class_3486.field_15517)) return false;

		for (class_2350 direction : class_2350.class_2353.field_11062) {
			if (!canBeAdjacentToWater(level, pos.method_10093(direction))) {
				return false;
			}
		}

		return canBeAdjacentToWater(level, pos.method_10074());
	}

	private boolean canBeAdjacentToWater(class_1936 level, class_2338 pos) {
		class_2680 state = level.method_8320(pos);
		return state.method_26164(SBTags.Blocks.ICICLE_REPLACEABLE) || state.method_26227().method_15767(class_3486.field_15517);
	}

	private void replaceBlocksWithIce(class_5281 level, class_2338 pos, int thickness, class_2350 direction) {
		class_2338.class_2339 mutableBlockPos = pos.method_25503();

		for(int i = 0; i < thickness; ++i) {
			if (!IcicleUtils.placeIceIfPossible(level, mutableBlockPos)) {
				return;
			}

			mutableBlockPos.method_10098(direction);
		}
	}

	private double getChanceOfIcicle(int xRadius, int zRadius, int x, int z, Configuration config) {
		float i = Math.min(xRadius - Math.abs(x), zRadius - Math.abs(z));
		return class_3532.method_37958(i, 0.0F, (float) config.maxRadiusAffectingColumnChance, config.columnChanceAtMaxRadius, 1.0F);
	}

	public record Configuration(int caveHeightSearchRange, class_6017 height, class_6017 radius, int maxHeightDifference, int heightDeviation, class_6017 layerThickness, class_5863 density, class_5863 lightChance, float columnChanceAtMaxRadius, int maxRadiusAffectingColumnChance, int maxRadiusAffectingHeightBias) implements class_3037 {
		public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group(
				Codec.intRange(1, 512).fieldOf("cave_height_search_range").forGetter(Configuration::caveHeightSearchRange),
				class_6017.method_35004(1, 128).fieldOf("height").forGetter(Configuration::height),
				class_6017.method_35004(1, 128).fieldOf("radius").forGetter(Configuration::radius),
				Codec.intRange(0, 64).fieldOf("max_height_difference").forGetter(Configuration::maxHeightDifference),
				Codec.intRange(1, 64).fieldOf("height_deviation").forGetter(Configuration::heightDeviation),
				class_6017.method_35004(0, 128).fieldOf("layer_thickness").forGetter(Configuration::layerThickness),
				class_5863.method_33916(0.0F, 2.0F).fieldOf("density").forGetter(Configuration::density),
				class_5863.method_33916(0.0F, 2.0F).fieldOf("light_chance").forGetter(Configuration::lightChance),
				Codec.floatRange(0.0F, 1.0F).fieldOf("column_chance_at_max_radius").forGetter(Configuration::columnChanceAtMaxRadius),
				Codec.intRange(1, 64).fieldOf("max_radius_affecting_column_chance").forGetter(Configuration::maxRadiusAffectingColumnChance),
				Codec.intRange(1, 64).fieldOf("max_radius_affecting_height_bias").forGetter(Configuration::maxRadiusAffectingHeightBias)
		).apply(instance, Configuration::new));
	}
}
