package net.invictusslayer.slayersbeasts.world.level.gen.feature.icicle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5721;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5863;
import net.minecraft.class_6017;
import java.util.Optional;

public class IcicleLargeFeature extends class_3031<IcicleLargeFeature.Configuration> {
	public IcicleLargeFeature(Codec<Configuration> codec) {
		super(codec);
	}

	public boolean method_13151(class_5821<Configuration> context) {
		class_5281 level = context.method_33652();
		class_2338 origin = context.method_33655();
		Configuration config = context.method_33656();
		class_5819 random = context.method_33654();

		if (!IcicleUtils.isEmptyOrWater(level, origin)) return false;

		Optional<class_5721> optional = class_5721.method_32982(level, origin, config.caveHeightSearchRange, IcicleUtils::isEmptyOrWater, IcicleUtils::isIcicleBaseOrLava);
		if (optional.isPresent() && optional.get() instanceof class_5721.class_5723 range) {
			if (range.method_32992() < 4) return false;

			int max = class_3532.method_15340((int) ((float) range.method_32992() * config.maxRadiusHeightRatio), config.columnRadius.method_35009(), config.columnRadius.method_35011());
			int radius = class_3532.method_32751(random, config.columnRadius.method_35009(), max);
			LargeIcicle topIcicle = makeIcicle(origin.method_33096(range.method_32990() - 1), false, random, radius, config.topBluntness, config.heightScale);
			LargeIcicle bottomIcicle = makeIcicle(origin.method_33096(range.method_32991() + 1), true, random, radius, config.bottomBluntness, config.heightScale);
			WindOffsetter offsetter;
			if (topIcicle.isSuitableForWind(config) && bottomIcicle.isSuitableForWind(config)) {
				offsetter = new WindOffsetter(origin.method_10264(), random, config.windSpeed);
			} else {
				offsetter = new WindOffsetter();
			}

			boolean flag = topIcicle.alignBaseAndShrinkRadius(level, offsetter);
			boolean flag1 = bottomIcicle.alignBaseAndShrinkRadius(level, offsetter);
			if (flag) {
				topIcicle.placeBlocks(level, random, offsetter);
			}

			if (flag1) {
				bottomIcicle.placeBlocks(level, random, offsetter);
			}

			return true;

		} else {
			return false;
		}
	}

	private static LargeIcicle makeIcicle(class_2338 origin, boolean pointingUp, class_5819 random, int radius, class_5863 baseBluntness, class_5863 baseScale) {
		return new LargeIcicle(origin, pointingUp, radius, baseBluntness.method_33920(random), baseScale.method_33920(random));
	}
	
	private static final class LargeIcicle {
		private class_2338 origin;
		private final boolean pointingUp;
		private int radius;
		private final double bluntness;
		private final double scale;

		LargeIcicle(class_2338 origin, boolean pointingUp, int radius, double bluntness, double scale) {
			this.origin = origin;
			this.pointingUp = pointingUp;
			this.radius = radius;
			this.bluntness = bluntness;
			this.scale = scale;
		}

		private boolean alignBaseAndShrinkRadius(class_5281 level, WindOffsetter offsetter) {
			while (radius > 1) {
				class_2338.class_2339 mutableBlockPos = origin.method_25503();
				int i = Math.min(10, getHeightAtRadius(0.0F));

				for (int j = 0; j < i; ++j) {
					if (level.method_8320(mutableBlockPos).method_27852(class_2246.field_10164)) {
						return false;
					}
					if (IcicleUtils.isBaseEmbeddedInStone(level, offsetter.offset(mutableBlockPos), radius)) {
						origin = mutableBlockPos;
						return true;
					}
					mutableBlockPos.method_10098(pointingUp ? class_2350.field_11033 : class_2350.field_11036);
				}

				radius /= 2;
			}
			return false;
		}

		private int getHeightAtRadius(float radius) {
			return (int) IcicleUtils.getIcicleHeight(radius, this.radius, scale, bluntness);
		}

		private void placeBlocks(class_5281 level, class_5819 random, WindOffsetter offsetter) {
			for (int x = -radius; x <= radius; ++x) {
				for (int z = -radius; z <= radius; ++z) {
					float f = class_3532.method_15355(x * x + z * z);
					if (f <= radius) {
						int k = getHeightAtRadius(f);
						if (k > 0) {
							if (random.method_43058() < 0.2D) {
								k = (int) (k * class_3532.method_32750(random, 0.8F, 1.0F));
							}

							class_2338.class_2339 mutableBlockPos = origin.method_10069(x, 0, z).method_25503();
							boolean flag = false;
							int l = pointingUp ? level.method_8624(class_2902.class_2903.field_13194, mutableBlockPos.method_10263(), mutableBlockPos.method_10260()) : Integer.MAX_VALUE;

							for (int i1 = 0; i1 < k && mutableBlockPos.method_10264() < l; ++i1) {
								class_2338 blockPos = offsetter.offset(mutableBlockPos);
								if (IcicleUtils.isEmptyOrWaterOrLava(level, blockPos)) {
									flag = true;
									level.method_8652(blockPos, class_2246.field_10225.method_9564(), 2);
								} else if (flag && level.method_8320(blockPos).method_26164(SBTags.Blocks.ICICLE_REPLACEABLE)) {
									break;
								}

								mutableBlockPos.method_10098(pointingUp ? class_2350.field_11036 : class_2350.field_11033);
							}
						}
					}
				}
			}
		}

		boolean isSuitableForWind(Configuration config) {
			return radius >= config.minWindRadius && bluntness >= (double) config.minWindBluntness;
		}
	}

	private static final class WindOffsetter {
		private final int originY;
		private final class_243 windSpeed;

		private WindOffsetter(int originY, class_5819 random, class_5863 magnitude) {
			this.originY = originY;
			float f = magnitude.method_33920(random);
			float f1 = class_3532.method_32750(random, 0.0F, class_3532.field_29844);
			windSpeed = new class_243(class_3532.method_15362(f1) * f, 0.0D, class_3532.method_15374(f1) * f);
		}

		private WindOffsetter() {
			originY = 0;
			windSpeed = null;
		}

		class_2338 offset(class_2338 pos) {
			if (windSpeed == null) {
				return pos;
			} else {
				int i = originY - pos.method_10264();
				class_243 vec3 = windSpeed.method_1021(i);
				return pos.method_10069(class_3532.method_15357(vec3.field_1352), 0, class_3532.method_15357(vec3.field_1350));
			}
		}
	}

	public record Configuration(int caveHeightSearchRange, class_6017 columnRadius, class_5863 heightScale, float maxRadiusHeightRatio, class_5863 topBluntness, class_5863 bottomBluntness, class_5863 windSpeed, int minWindRadius, float minWindBluntness) implements class_3037 {
		public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group(
				Codec.intRange(1, 512).fieldOf("cave_height_search_range").forGetter(Configuration::caveHeightSearchRange),
				class_6017.method_35004(1, 60).fieldOf("column_radius").forGetter(Configuration::columnRadius),
				class_5863.method_33916(0.0F, 20.0F).fieldOf("height_scale").forGetter(Configuration::heightScale),
				Codec.floatRange(0.1F, 1.0F).fieldOf("max_radius_height_ratio").forGetter(Configuration::maxRadiusHeightRatio),
				class_5863.method_33916(0.1F, 10.0F).fieldOf("top_bluntness").forGetter(Configuration::topBluntness),
				class_5863.method_33916(0.1F, 10.0F).fieldOf("bottom_bluntness").forGetter(Configuration::bottomBluntness),
				class_5863.method_33916(0.0F, 2.0F).fieldOf("wind_speed").forGetter(Configuration::windSpeed),
				Codec.intRange(0, 100).fieldOf("min_wind_radius").forGetter(Configuration::minWindRadius),
				Codec.floatRange(0.0F, 5.0F).fieldOf("min_wind_bluntness").forGetter(Configuration::minWindBluntness)
		).apply(instance, Configuration::new));
	}
}
