package net.invictusslayer.slayersbeasts.world.level.gen.feature.icicle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class IcicleSmallFeature extends class_3031<IcicleSmallFeature.Configuration> {
	public IcicleSmallFeature(Codec<Configuration> codec) {
		super(codec);
	}

	public boolean method_13151(class_5821<Configuration> context) {
		class_1936 level = context.method_33652();
		class_2338 origin = context.method_33655();
		class_5819 random = context.method_33654();
		Configuration config = context.method_33656();
		Optional<class_2350> optional = getTipDirection(level, origin, random);
		if (optional.isEmpty()) {
			return false;
		} else {
			class_2338 blockPos = origin.method_10093(optional.get().method_10153());
			createPatchOfIcicleBlocks(level, random, blockPos, config);
			int i = random.method_43057() < config.tallerIcicleChance && IcicleUtils.isEmptyOrWater(level.method_8320(origin.method_10093(optional.get()))) ? 2 : 1;
			IcicleUtils.growIcicle(level, origin, optional.get(), i, false);
			return true;
		}
	}

	private static Optional<class_2350> getTipDirection(class_1936 level, class_2338 pos, class_5819 random) {
		boolean isDown = IcicleUtils.isIcicleBase(level.method_8320(pos.method_10084()));
		boolean isUp = IcicleUtils.isIcicleBase(level.method_8320(pos.method_10074()));
		if (isDown && isUp) {
			return Optional.of(random.method_43056() ? class_2350.field_11033 : class_2350.field_11036);
		} else if (isDown) {
			return Optional.of(class_2350.field_11033);
		} else if (isUp) {
			return Optional.of(class_2350.field_11036);
		} else {
			return Optional.empty();
		}
	}

	private static void createPatchOfIcicleBlocks(class_1936 level, class_5819 random, class_2338 pos, Configuration config) {
		IcicleUtils.placeIceIfPossible(level, pos);

		for (class_2350 direction : class_2350.class_2353.field_11062) {
			if (random.method_43057() < config.radialSpreadChance) {
				class_2338 blockPos = pos.method_10093(direction);
				IcicleUtils.placeIceIfPossible(level, blockPos);
				if (random.method_43057() < config.radialSpreadChance2) {
					class_2338 blockPos1 = blockPos.method_10093(class_2350.method_10162(random));
					IcicleUtils.placeIceIfPossible(level, blockPos1);
					if (random.method_43057() < config.radialSpreadChance3) {
						class_2338 blockPos2 = blockPos1.method_10093(class_2350.method_10162(random));
						IcicleUtils.placeIceIfPossible(level, blockPos2);
					}
				}
			}
		}

	}

	public record Configuration(float tallerIcicleChance, float radialSpreadChance, float radialSpreadChance2, float radialSpreadChance3) implements class_3037 {
		public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group(
				Codec.floatRange(0.0F, 1.0F).fieldOf("taller_icicle_chance").forGetter(Configuration::tallerIcicleChance),
				Codec.floatRange(0.0F, 1.0F).fieldOf("radial_spread_chance").forGetter(Configuration::radialSpreadChance),
				Codec.floatRange(0.0F, 1.0F).fieldOf("radial_spread_chance2").forGetter(Configuration::radialSpreadChance2),
				Codec.floatRange(0.0F, 1.0F).fieldOf("radial_spread_chance3").forGetter(Configuration::radialSpreadChance3)
		).apply(instance, Configuration::new));
	}
}
