package net.invictusslayer.slayersbeasts.world.level.gen.feature.icicle;

import net.invictusslayer.slayersbeasts.world.level.block.IcicleBlock;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5691;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import java.util.function.Consumer;

public class IcicleUtils {
	protected static double getIcicleHeight(double radius, double maxRadius, double scale, double minRadius) {
		if (radius < minRadius) {
			radius = minRadius;
		}

		double d1 = radius / maxRadius * 0.384D;
		double d2 = scale * (0.75D * Math.pow(d1, 4D / 3D) - Math.pow(d1, 2D / 3D) - Math.log(d1) / 3D);
		return Math.max(d2, 0.0D) / 0.384D * maxRadius;
	}

	protected static boolean isBaseEmbeddedInStone(class_5281 level, class_2338 pos, int radius) {
		if (isEmptyOrWaterOrLava(level, pos)) return false;

		float i = 6.0F / radius;

		for (float v = 0.0F; v < class_3532.field_29844 * 2F; v += i) {
			int x = (int) (class_3532.method_15362(v) * radius);
			int z = (int) (class_3532.method_15374(v) * radius);
			if (isEmptyOrWaterOrLava(level, pos.method_10069(x, 0, z))) {
				return false;
			}
		}

		return true;

	}

	protected static boolean isEmptyOrWater(class_1936 level, class_2338 pos) {
		return level.method_16358(pos, IcicleUtils::isEmptyOrWater);
	}

	protected static boolean isEmptyOrWaterOrLava(class_1936 level, class_2338 pos) {
		return level.method_16358(pos, IcicleUtils::isEmptyOrWaterOrLava);
	}

	protected static void buildBaseToTipColumn(class_2350 direction, int height, boolean mergeTip, Consumer<class_2680> consumer) {
		if (height >= 3) {
			consumer.accept(createIcicle(direction, class_5691.field_28068));

			for (int i = 0; i < height - 3; ++i) {
				consumer.accept(createIcicle(direction, class_5691.field_28067));
			}
		}

		if (height >= 2) {
			consumer.accept(createIcicle(direction, class_5691.field_28066));
		}

		if (height >= 1) {
			consumer.accept(createIcicle(direction, mergeTip ? class_5691.field_28064 : class_5691.field_28065));
		}

	}

	protected static void growIcicle(class_1936 level, class_2338 pos, class_2350 direction, int height, boolean mergeTip) {
		if (isIcicleBase(level.method_8320(pos.method_10093(direction.method_10153())))) {
			class_2338.class_2339 mutableBlockPos = pos.method_25503();
			buildBaseToTipColumn(direction, height, mergeTip, state -> {
				if (state.method_27852(SBBlocks.ICICLE.get())) {
					state = state.method_11657(IcicleBlock.WATERLOGGED, level.method_22351(mutableBlockPos));
				}

				level.method_8652(mutableBlockPos, state, 2);
				mutableBlockPos.method_10098(direction);
			});
		}
	}

	protected static boolean placeIceIfPossible(class_1936 level, class_2338 pos) {
		class_2680 blockstate = level.method_8320(pos);
		if (blockstate.method_26164(SBTags.Blocks.ICICLE_REPLACEABLE)) {
			level.method_8652(pos, class_2246.field_10225.method_9564(), 2);
			return true;
		} else {
			return false;
		}
	}

	private static class_2680 createIcicle(class_2350 direction, class_5691 thickness) {
		return SBBlocks.ICICLE.get().method_9564().method_11657(IcicleBlock.TIP_DIRECTION, direction).method_11657(IcicleBlock.THICKNESS, thickness);
	}

	public static boolean isIcicleBaseOrLava(class_2680 state) {
		return isIcicleBase(state) || state.method_27852(class_2246.field_10164);
	}

	public static boolean isIcicleBase(class_2680 state) {
		return state.method_27852(class_2246.field_10225) || state.method_26164(SBTags.Blocks.ICICLE_REPLACEABLE);
	}

	public static boolean isEmptyOrWater(class_2680 state) {
		return state.method_26215() || state.method_27852(class_2246.field_10382);
	}

	public static boolean isNeitherEmptyNorWater(class_2680 state) {
		return !isEmptyOrWater(state);
	}

	public static boolean isEmptyOrWaterOrLava(class_2680 state) {
		return state.method_26215() || state.method_27852(class_2246.field_10382) || state.method_27852(class_2246.field_10164);
	}
}
