package net.invictusslayer.slayersbeasts.world.level.gen.feature.misc;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3481;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class PitFeature extends class_3031<PitFeature.Configuration> {
	public PitFeature(Codec<Configuration> pCodec) {
		super(pCodec);
	}

	@SuppressWarnings("deprecation")
	public boolean method_13151(class_5821<Configuration> context) {
		class_2338 origin = context.method_33655();
		class_5281 level = context.method_33652();
		class_5819 random = context.method_33654();
		Configuration config = context.method_33656();

		int x = config.x();
		int y = config.y();
		int z = config.z();
		int xMax = x < 7 ? 8 : 16;
		int yMax = y < 7 ? 8 : y < 15 ? 16 : 32;
		int zMax = z < 7 ? 8 : 16;

		if (origin.method_10264() <= level.method_31607() + y) return false;
		origin = origin.method_10087(y);
		if (!level.method_8311(origin.method_10069(xMax / 2, y, zMax / 2))) return false;

		boolean[] booleans = new boolean[xMax * yMax * zMax];

		for (int i = 0; i < y * 2; ++i) {
			double d0 = random.method_43058() * 4D + 3D;
			double d1 = random.method_43058() * 6D + 2D;
			double d2 = random.method_43058() * 4D + 3D;
			double d3 = random.method_43058() * (x - d0) + 1.0D + d0 / 2.0D;
			double d4 = random.method_43058() * (y - d1) + 1.0D + d1 / 2.0D;
			double d5 = random.method_43058() * (z - d2) + 1.0D + d2 / 2.0D;

			for (int x1 = 1; x1 < xMax - 1; ++x1) {
				for (int z1 = 1; z1 < zMax - 1; ++z1) {
					for (int y1 = 1; y1 < y - 1; ++y1) {
						double d6 = (x1 - d3) / (d0 / 2D);
						double d7 = (y1 - d4) / (d1 / 2D);
						double d8 = (z1 - d5) / (d2 / 2D);
						double d9 = d6 * d6 + d7 * d7 + d8 * d8;
						if (d9 < 1.0D) {
							booleans[(x1 * zMax + z1) * yMax + y1] = true;
						}
					}
				}
			}
		}

		for (int x1 = 0; x1 < xMax; ++x1) {
			for (int z1 = 0; z1 < zMax; ++z1) {
				for (int y1 = 0; y1 < yMax; ++y1) {
					int boolId = (x1 * zMax + z1) * yMax + y1;
					boolean flag = !booleans[boolId]
							&& (x1 < xMax - 1 && booleans[boolId + zMax * yMax] || x1 > 0 && booleans[boolId - zMax * yMax]
							|| z1 < zMax - 1 && booleans[boolId + yMax] || z1 > 0 && booleans[boolId - yMax]
							|| y1 < yMax - 1 && booleans[boolId + 1] || y1 > 0 && booleans[boolId - 1]);
					if (flag) {
						class_2680 state = level.method_8320(origin.method_10069(x1, y1, z1));
						if (state.method_51176()) return false;
						if (y1 < y && !state.method_51367() && level.method_8320(origin.method_10069(x1, y1, z1)) != class_2246.field_10543.method_9564()) {
							return false;
						}
					}
				}
			}
		}

		for (int x1 = 0; x1 < xMax; ++x1) {
			for (int z1 = 0; z1 < zMax; ++z1) {
				for (int y1 = 0; y1 < yMax; ++y1) {
					if (booleans[(x1 * zMax + z1) * yMax + y1]) {
						class_2338 pos = origin.method_10069(x1, y1, z1);
						if (!level.method_8320(pos).method_26164(class_3481.field_33757)) {
							level.method_8652(pos, class_2246.field_10543.method_9564(), 2);
							method_37256(level, pos);
						}
					}
				}
			}
		}

		class_2680 wall = config.wall().method_23455(random, origin);
		class_2680 ceiling = config.ceiling().method_23455(random, origin);
		if (wall.method_26215()) return true;
		for (int x1 = 0; x1 < xMax; ++x1) {
			for (int z1 = 0; z1 < zMax; ++z1) {
				for (int y1 = 0; y1 < yMax; ++y1) {
					int boolId = (x1 * zMax + z1) * yMax + y1;
					boolean flag = !booleans[boolId]
							&& (x1 < xMax - 1 && booleans[boolId + zMax * yMax] || x1 > 0 && booleans[boolId - zMax * yMax]
							|| z1 < zMax - 1 && booleans[boolId + yMax] || z1 > 0 && booleans[boolId - yMax]
							|| y1 < yMax - 1 && booleans[boolId + 1] || y1 > 0 && booleans[boolId - 1]);
					if (flag) {
						class_2338 pos = origin.method_10069(x1, y1, z1);
						class_2680 state = level.method_8320(pos);
						if (!state.method_26164(class_3481.field_33757)) {
							if (y1 < y * 0.3 || random.method_43048(3) == 0) {
								level.method_8652(pos, wall, 2);
							} else if (y1 > y * 0.7) {
								level.method_8652(pos, ceiling, 2);
							} else if (random.method_43048(3) == 0) {
								level.method_8652(pos, wall, 2);
							}
						}
					}
				}
			}
		}

		return true;
	}

	public record Configuration(class_4651 ceiling, class_4651 wall, int x, int y, int z) implements class_3037 {
		public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance ->
				instance.group(class_4651.field_24937.fieldOf("ceiling_provider").forGetter(Configuration::ceiling),
								class_4651.field_24937.fieldOf("wall_provider").forGetter(Configuration::wall),
								Codec.intRange(1, 16).fieldOf("x").forGetter(Configuration::x),
								Codec.intRange(1, 32).fieldOf("y").forGetter(Configuration::y),
								Codec.intRange(1, 16).fieldOf("z").forGetter(Configuration::z))
						.apply(instance, Configuration::new));
	}
}
