package net.invictusslayer.slayersbeasts.world.level.gen.feature.mushroom;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_4635;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public abstract class AbstractMightyMushroomFeature extends class_3031<class_4635> {
	public AbstractMightyMushroomFeature(Codec<class_4635> codec) {
		super(codec);
	}

	public boolean method_13151(class_5821<class_4635> context) {
		class_5281 level = context.method_33652();
		class_2338 origin = context.method_33655();
		class_5819 random = context.method_33654();
		class_4635 config = context.method_33656();

		int height = getTreeHeight(random);
		class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
		if (!isValidPosition(level, origin, height, mutableBlockPos, config)) return false;

		placeCap(level, random, origin, config, height, mutableBlockPos);
		placeStem(level, random, origin, config, height, mutableBlockPos);
		return true;
	}

	protected abstract void placeCap(class_1936 level, class_5819 random, class_2338 pos, class_4635 config, int height, class_2338.class_2339 mutableBlockPos);

	protected void placeStem(class_1936 level, class_5819 random, class_2338 pos, class_4635 config, int maxHeight, class_2338.class_2339 mutableBlockPos) {
		for (int i = 0; i < maxHeight - 1; ++i) {
			mutableBlockPos.method_10101(pos).method_10104(class_2350.field_11036, i);
			if (!level.method_8320(mutableBlockPos).method_26216()) {
				method_13153(level, mutableBlockPos, config.field_21231.method_23455(random, pos));
				method_13153(level, mutableBlockPos.method_10072(), config.field_21231.method_23455(random, pos));
				method_13153(level, mutableBlockPos.method_10078(), config.field_21231.method_23455(random, pos));
				method_13153(level, mutableBlockPos.method_10072().method_10078(), config.field_21231.method_23455(random, pos));
			}
		}
	}

	protected int getTreeHeight(class_5819 random) {
		int i = random.method_43048(8) + 8;
		if (random.method_43048(12) == 0) i *= 2;

		return i;
	}

	protected boolean isValidPosition(class_1936 level, class_2338 pos, int maxHeight, class_2338.class_2339 mutableBlockPos, class_4635 config) {
		if (pos.method_10264() <= level.method_31607() || pos.method_10264() + maxHeight > level.method_31600()) return false;

		List<class_2338> posList = List.of(pos.method_10074(), pos.method_10074().method_10072(), pos.method_10074().method_10078(), pos.method_10074().method_10072().method_10078());
		for (class_2338 blockPos : posList) {
			class_2680 state = level.method_8320(blockPos);
			if (!method_23396(state) && !state.method_26164(class_3481.field_25739)) return false;
		}

		for (int y = 0; y <= maxHeight; ++y) {
			int radius = getTreeRadiusForHeight(config.field_21232, maxHeight - y);

			for (int x = -radius; x <= radius + 1; ++x) {
				for (int z = -radius; z <= radius + 1; ++z) {
					class_2680 state = level.method_8320(mutableBlockPos.method_25504(pos, x, y, z));
					if (!state.method_26215() && !state.method_26164(class_3481.field_15503)) return false;
				}
			}
		}
		return true;
	}

	protected abstract int getTreeRadiusForHeight(int radius, int height);
}
