package net.invictusslayer.slayersbeasts.world.level.gen.feature.mushroom;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2381;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3481;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6017;

public class BigMushroomFeature extends class_3031<BigMushroomFeature.Configuration> {
	public BigMushroomFeature(Codec<Configuration> codec) {
		super(codec);
	}

	public boolean method_13151(class_5821<Configuration> context) {
		class_5281 level = context.method_33652();
		class_2338 origin = context.method_33655();
		class_5819 random = context.method_33654();
		Configuration config = context.method_33656();

		int height = config.height.method_35008(random);
		class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();

		if (!isValidPosition(level, origin, mutableBlockPos, height)) return false;

		class_2680 cap = config.capProvider.method_23455(random, origin);
		if (cap.method_28498(class_2381.field_11169)) cap = cap.method_11657(class_2381.field_11169, false);
		class_2680 stem = config.stemProvider.method_23455(random, origin);
		if (stem.method_28498(class_2381.field_11169)) stem = stem.method_11657(class_2381.field_11169, false).method_11657(class_2381.field_11166, false);

		mutableBlockPos.method_10101(origin);
		for (int y = 0; y <= height - 1; ++y) {
			checkAndSetBlock(level, mutableBlockPos, stem);
			mutableBlockPos.method_10098(class_2350.field_11036);
		}

		for (int x = -1; x <= 1; ++x) {
			for (int z = -1; z <= 1; ++z) {
				if (x * z == 0) checkAndSetBlock(level, mutableBlockPos.method_25504(origin, x, height, z), cap);
				checkAndSetBlock(level, mutableBlockPos.method_25504(origin, x, height - 1, z), cap);
			}
		}

		return true;
	}

	private void checkAndSetBlock(class_5281 level, class_2338 pos, class_2680 state) {
		if (!level.method_8320(pos).method_26216()) {
			method_13153(level, pos, state);
		}
	}

	private boolean isValidPosition(class_1936 level, class_2338 pos, class_2338.class_2339 mutableBlockPos, int height) {
		int i = pos.method_10264();
		if (i >= level.method_31607() + 1 && i + height + 1 < level.method_31600()) {
			class_2680 below = level.method_8320(pos.method_10074());
			if (!method_23396(below) && !below.method_26164(class_3481.field_25739)) return false;

			for (int y = 0; y <= height; ++y) {
				for (int x = -1; x <= 1; ++x) {
					for (int z = -1; z <= 1; ++z) {
						class_2680 state = level.method_8320(mutableBlockPos.method_25504(pos, x, y, z));
						if (!state.method_26215() && !state.method_26164(class_3481.field_15503)) {
							return false;
						}
					}
				}
			}
			return true;
		}
		return false;
	}

	public record Configuration(class_6017 height, class_4651 capProvider, class_4651 stemProvider) implements class_3037 {
		public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance ->
				instance.group(class_6017.field_29946.fieldOf("height").forGetter(Configuration::height),
								class_4651.field_24937.fieldOf("cap_provider").forGetter(Configuration::capProvider),
								class_4651.field_24937.fieldOf("stem_provider").forGetter(Configuration::stemProvider))
						.apply(instance, Configuration::new));
	}
}
