package net.invictusslayer.slayersbeasts.world.level.gen.feature.mushroom;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2381;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3481;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6017;

public class BranchingMushroomFeature extends class_3031<BranchingMushroomFeature.Configuration> {
	private final boolean[] branchChecks = new boolean[5];

	public BranchingMushroomFeature(Codec<Configuration> codec) {
		super(codec);
	}

	public boolean method_13151(class_5821<Configuration> context) {
		class_5281 level = context.method_33652();
		class_2338 origin = context.method_33655();
		class_5819 random = context.method_33654();
		Configuration config = context.method_33656();

		int height = config.height.method_35008(random);
		class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
		if (!isValidPosition(level, origin, height, mutableBlockPos, config)) return false;

		List<CapAttachment> attachments = placeStem(level, random, origin, config, height, mutableBlockPos);
		attachments.forEach(attachment -> placeCap(level, random, attachment.origin, config, mutableBlockPos, attachment.variant));
		return true;
	}

	private void placeCap(class_1936 level, class_5819 random, class_2338 pos, Configuration config, class_2338.class_2339 mutableBlockPos, int variant) {
		class_2680 state = config.capProvider.method_23455(random, pos).method_11657(class_2381.field_11169, variant < 2);

		method_13153(level, pos, state);
		if (variant < 2) method_13153(level, pos.method_10084(), state);

		class_2350.class_2353.field_11062.forEach(direction -> {
			if (variant == 1) method_13153(level, pos.method_10093(direction).method_10074(), state);
			if (variant == 3) method_13153(level, pos.method_10093(direction).method_10093(direction.method_10170()), state);
			if (variant < 4) method_13153(level, pos.method_10093(direction), state);
		});
	}

	private List<CapAttachment> placeStem(class_1936 level, class_5819 random, class_2338 pos, Configuration config, int maxHeight, class_2338.class_2339 mutableBlockPos) {
		class_2680 state = config.stemProvider.method_23455(random, pos);
		List<CapAttachment> attachments = new ArrayList<>();
		Arrays.fill(branchChecks, true);
		int height = 3 + random.method_43048(3);
		int max = 0;

		List<class_2350> directions = new ArrayList<>(List.of(class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039));
		for (int i = 0; i < random.method_43048(3); i++) {
			class_2350 direction = directions.remove(0);
			directions.add(direction);
		}
		for (int i = 0; i < 2 + random.method_43048(3); i++) {
			class_2350 direction = directions.get(i);
			int h = height - random.method_43048(3);
			attachments.add(placeBranch(level, random, pos.method_10086(h), state, config, maxHeight - h, mutableBlockPos, direction, i));
			max = Math.max(max, h);
		}

		method_13153(level, mutableBlockPos.method_10101(pos), state);
		for (int i = 0; i < max; ++i) method_13153(level, mutableBlockPos.method_10098(class_2350.field_11036), state);

		return attachments;
	}

	private CapAttachment placeBranch(class_1936 level, class_5819 random, class_2338 pos, class_2680 state, Configuration config, int maxHeight, class_2338.class_2339 mutableBlockPos, class_2350 direction, int j) {
		boolean flag = false;
		int height = random.method_43048(maxHeight);

		mutableBlockPos.method_10101(pos);
		method_13153(level, mutableBlockPos.method_10098(direction), state);

		if (branchChecks[0] && random.method_43048(6 - j) == 0) flag = true;
		else method_13153(level, mutableBlockPos.method_10098(direction), state);

		if (random.method_43048(5 - j) == 0) {
			if (random.method_43056()) {
				if (branchChecks[check(j, true)]) {
					branchChecks[check(j, true)] = false;
					method_13153(level, mutableBlockPos.method_10098(direction.method_10170()), state);
					if (flag) {
						if (random.method_43056()) branchChecks[0] = false;
						else method_13153(level, mutableBlockPos.method_10098(direction.method_10170()), state);
					}
				}
			} else if (branchChecks[check(j, false)]) {
				branchChecks[check(j, false)] = false;
				method_13153(level, mutableBlockPos.method_10098(direction.method_10160()), state);
				if (flag) {
					if (random.method_43056()) branchChecks[0] = false;
					else method_13153(level, mutableBlockPos.method_10098(direction.method_10160()), state);
				}
			}
		} else if (flag) branchChecks[0] = false;
		flag = true;

		for (int i = 0; i < height; i++) {
			method_13153(level, mutableBlockPos.method_10098(class_2350.field_11036), state);
			if (flag && random.method_43057() > 0.75F && i > 1 && i < height - 2) {
				flag = false;
				class_2350 dir = List.of(direction, direction.method_10170(), direction.method_10160()).get(random.method_43048(3));
				method_13153(level, mutableBlockPos.method_10098(dir), state);
			}
		}

		return new CapAttachment(mutableBlockPos.method_10084(), height < 2 ? 4 : random.method_43048(4));
	}

	private int check(int i, boolean clockwise) {
		return clockwise ? i + 1 : i == 0 ? 4 : i;
	}

	private boolean isValidPosition(class_1936 level, class_2338 origin, int maxHeight, class_2338.class_2339 mutableBlockPos, Configuration config) {
		if (origin.method_10264() <= level.method_31607() || origin.method_10264() + maxHeight > level.method_31600()) return false;

		class_2680 state = level.method_8320(origin.method_10074());
		if (!method_23396(state) && !state.method_26164(class_3481.field_25739)) return false;

		for (int y = 0; y <= maxHeight; y++) {
			for (int x = -3; x <= 3; x++) {
				for (int z = -3; z <= 3; z++) {
					class_2680 blockState = level.method_8320(mutableBlockPos.method_25504(origin, x, y, z));
					if (!blockState.method_26215() && !blockState.method_26164(class_3481.field_15503)) return false;
				}
			}
		}
		return true;
	}

	public record CapAttachment(class_2338 origin, int variant) {}

	public record Configuration(class_6017 height, class_4651 capProvider, class_4651 stemProvider) implements class_3037 {
		public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance ->
				instance.group(class_6017.field_29946.fieldOf("height").forGetter(Configuration::height),
								class_4651.field_24937.fieldOf("cap_provider").forGetter(Configuration::capProvider),
								class_4651.field_24937.fieldOf("stem_provider").forGetter(Configuration::stemProvider))
						.apply(instance, Configuration::new));
	}
}
