package net.invictusslayer.slayersbeasts.world.level.gen.feature.tree.decorator;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.invictusslayer.slayersbeasts.registries.SBTreeDecorators;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2944;
import net.minecraft.class_4651;
import net.minecraft.class_4662;
import net.minecraft.class_4663;
import net.minecraft.class_5819;
import java.util.ArrayList;
import java.util.List;

public class ButtressRootDecorator extends class_4662 {
	public static final MapCodec<ButtressRootDecorator> CODEC = RecordCodecBuilder.mapCodec(instance ->
			instance.group(class_4651.field_24937.fieldOf("log_provider").forGetter(decorator -> decorator.logProvider),
							class_4651.field_24937.fieldOf("dirt_provider").forGetter(decorator -> decorator.dirtProvider))
					.apply(instance, ButtressRootDecorator::new));
	private final class_4651 logProvider;
	private final class_4651 dirtProvider;

	public ButtressRootDecorator(class_4651 logProvider, class_4651 dirtProvider) {
		this.logProvider = logProvider;
		this.dirtProvider = dirtProvider;
	}

	protected class_4663<?> method_28893() {
		return SBTreeDecorators.BUTTRESS_ROOT.get();
	}

	public void method_23469(class_7402 pContext) {
		List<class_2338> list = pContext.method_43321();
		class_2338 basePos = list.get(0);

		for (class_2338 pPos : list.stream().toList()) {
			if (basePos.method_10263() > pPos.method_10263()) {
				basePos = new class_2338(pPos.method_10263(), basePos.method_10264(), basePos.method_10260());
			}
			if (basePos.method_10264() > pPos.method_10264()) {
				basePos = new class_2338(basePos.method_10263(), pPos.method_10264(), basePos.method_10260());
			}
			if (basePos.method_10260() > pPos.method_10260()) {
				basePos = new class_2338(basePos.method_10263(), basePos.method_10264(), pPos.method_10260());
			}
		}

		class_2338.class_2339 mutablePos = new class_2338.class_2339();

		placeRoot(pContext, pContext.method_43320(), mutablePos, basePos, class_2350.field_11043);
		placeRoot(pContext, pContext.method_43320(), mutablePos, basePos, class_2350.field_11035);
		placeRoot(pContext, pContext.method_43320(), mutablePos, basePos, class_2350.field_11039);
		placeRoot(pContext, pContext.method_43320(), mutablePos, basePos, class_2350.field_11034);
	}

	private void placeRoot(class_7402 pContext, class_5819 pRandom, class_2338.class_2339 pMutablePos, class_2338 pBasePos, class_2350 pDirection) {
		List<class_2338> posList = new ArrayList<>();
		posList.add(new class_2338(-1, 0, -1));
		posList.add(new class_2338(-1, 1, -1));
		posList.add(new class_2338(-2, 0, -2));

		int x = pRandom.method_43056() ? 0 : 1;
		for (int z = -1; z >= -5; z--) {
			int h;
			if (z == -1) {
				h = 4;
			} else if (z > -4) {
				h = z + 4;
				if (pRandom.method_43056()) {
					posList.add(new class_2338(pRandom.method_43056() ? x + 1 : x - 1, 0, z));
				}
			} else {
				h = 0;
			}

			for (int y = 0; y <= h; y++) {
				posList.add(new class_2338(x, y, z));
			}

			x = pRandom.method_43056() ? x : pRandom.method_43056() ? x + 1 : x - 1;
		}

		if (pDirection == class_2350.field_11043) {
			for (class_2338 pos : posList) {
				placeLog(pContext, pMutablePos.method_35831(pBasePos, pos));
				placeDirt(pContext, pMutablePos.method_25504(pBasePos, pos.method_10263(), -1, pos.method_10260()));
			}
		} else if (pDirection == class_2350.field_11035) {
			for (class_2338 pos : posList) {
				placeLog(pContext, pMutablePos.method_25504(pBasePos, -pos.method_10263() + 1, pos.method_10264(), -pos.method_10260() + 1));
				placeDirt(pContext, pMutablePos.method_25504(pBasePos, -pos.method_10263() + 1, -1, -pos.method_10260() + 1));
			}
		} else if (pDirection == class_2350.field_11039) {
			for (class_2338 pos : posList) {
				placeLog(pContext, pMutablePos.method_25504(pBasePos, pos.method_10260(), pos.method_10264(), -pos.method_10263() + 1));
				placeDirt(pContext, pMutablePos.method_25504(pBasePos, pos.method_10260(), -1, -pos.method_10263() + 1));
			}
		} else if (pDirection == class_2350.field_11034) {
			for (class_2338 pos : posList) {
				placeLog(pContext, pMutablePos.method_25504(pBasePos, -pos.method_10260() + 1, pos.method_10264(), pos.method_10263()));
				placeDirt(pContext, pMutablePos.method_25504(pBasePos, -pos.method_10260() + 1, -1, pos.method_10263()));
			}
		}
	}

	private void placeLog(class_7402 pContext, class_2338 pPos) {
		if (class_2944.method_27371(pContext.method_43316(), pPos)) {
			pContext.method_43318(pPos, logProvider.method_23455(pContext.method_43320(), pPos));
		}
	}

	private void placeDirt(class_7402 pContext, class_2338 pPos) {
		if (class_2944.method_27371(pContext.method_43316(), pPos)) {
			pContext.method_43318(pPos, dirtProvider.method_23455(pContext.method_43320(), pPos));
		}
	}
}
