package net.invictusslayer.slayersbeasts.world.level.gen.feature.tree.decorator;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.invictusslayer.slayersbeasts.registries.SBTreeDecorators;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_4651;
import net.minecraft.class_4662;
import net.minecraft.class_4663;

public class HangingBranchDecorator extends class_4662 {
	public static final MapCodec<HangingBranchDecorator> CODEC = RecordCodecBuilder.mapCodec(instance ->
			instance.group(Codec.floatRange(0.0F, 1.0F).fieldOf("probability").forGetter(decorator -> decorator.probability),
							class_4651.field_24937.fieldOf("head_provider").forGetter(decorator -> decorator.headProvider),
							class_4651.field_24937.fieldOf("body_provider").forGetter(decorator -> decorator.bodyProvider))
					.apply(instance, HangingBranchDecorator::new));
	private final float probability;
	private final class_4651 headProvider;
	private final class_4651 bodyProvider;

	public HangingBranchDecorator(float probability, class_4651 headProvider, class_4651 bodyProvider) {
		this.probability = probability;
		this.headProvider = headProvider;
		this.bodyProvider = bodyProvider;
	}

	protected class_4663<?> method_28893() {
		return SBTreeDecorators.HANGING_BRANCH.get();
	}

	public void method_23469(class_7402 pContext) {
		for (class_2338 leafPos : class_156.method_43027(pContext.method_43322(), pContext.method_43320())) {
			class_2338 branchPos = leafPos.method_10093(class_2350.field_11033);
			int height = pContext.method_43320().method_43051(1, 6);
			if (pContext.method_43317(branchPos) && pContext.method_43320().method_43057() < this.probability) {
				placeBranchColumn(pContext, branchPos, height);
			}
		}
	}

	private void placeBranchColumn(class_7402 pContext, class_2338 pPos, int pHeight) {
		for (int i = 0; i < pHeight; ++i) {
			class_2338 blockPos = pPos.method_10079(class_2350.field_11033, i);
			if (!pContext.method_43317(blockPos.method_10074())) {
				pContext.method_43318(blockPos, headProvider.method_23455(pContext.method_43320(), blockPos));
				break;
			}
			pContext.method_43318(blockPos, bodyProvider.method_23455(pContext.method_43320(), blockPos));
		}
	}
}
