package net.invictusslayer.slayersbeasts.world.level.gen.feature.tree.foliage;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.invictusslayer.slayersbeasts.registries.SBFoliagePlacers;
import net.minecraft.class_2338;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4648;
import net.minecraft.class_5819;
import net.minecraft.class_6017;

public class PointedFoliagePlacer extends class_4647 {
	public static final MapCodec<PointedFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> method_30411(instance).and(
			Codec.BOOL.fieldOf("tall").forGetter(placer -> placer.tall))
			.apply(instance, PointedFoliagePlacer::new));
	private final boolean tall;

	public PointedFoliagePlacer(class_6017 radius, class_6017 offset, boolean tall) {
		super(radius, offset);
		this.tall = tall;
	}

	protected class_4648<?> method_28843() {
		return SBFoliagePlacers.POINTED_FOLIAGE_PLACER.get();
	}

	protected void method_23448(class_3746 level, class_8179 blockSetter, class_5819 random, class_4643 config, int maxFreeTreeHeight, class_5208 attachment, int foliageHeight, int foliageRadius, int offset) {
		class_2338 pos = attachment.method_27388();

		if (tall) {
			method_23449(level, blockSetter, random, config, pos, 0, 3, false);
			method_23449(level, blockSetter, random, config, pos, 0, 2, false);
			method_23449(level, blockSetter, random, config, pos, 0, 1, false);
			method_23449(level, blockSetter, random, config, pos, 1, 0, false);
			method_23449(level, blockSetter, random, config, pos, 1, -1, false);
			method_23449(level, blockSetter, random, config, pos, 1, -2, false);
			method_23449(level, blockSetter, random, config, pos, 1, -3, false);
			method_23449(level, blockSetter, random, config, pos, 2, -4, false);
			method_23449(level, blockSetter, random, config, pos, 2, -5, false);
			method_23449(level, blockSetter, random, config, pos, 2, -6, false);
			method_23449(level, blockSetter, random, config, pos, 2, -7, false);
			method_23449(level, blockSetter, random, config, pos, 1, -8, false);
			method_23449(level, blockSetter, random, config, pos, 1, -9, false);
			method_23449(level, blockSetter, random, config, pos, 1, -10, false);
		} else {
			if (random.method_43056()) method_23449(level, blockSetter, random, config, pos, 0, 2, false);
			method_23449(level, blockSetter, random, config, pos, 0, 1, false);
			method_23449(level, blockSetter, random, config, pos, 1, 0, false);
			method_23449(level, blockSetter, random, config, pos, 1, -1, false);
			method_23449(level, blockSetter, random, config, pos, 2, -2, false);
			method_23449(level, blockSetter, random, config, pos, 2, -3, false);
			method_23449(level, blockSetter, random, config, pos, 2, -4, false);
			method_23449(level, blockSetter, random, config, pos, 1, -5, false);
		}
	}

	public int method_26989(class_5819 random, int height, class_4643 config) {
		return tall ? 4 : 2;
	}

	protected boolean method_23451(class_5819 random, int x, int y, int z, int range, boolean large) {
		if (tall && (y == -3 || y == -8)) return false;
		return x * x + z * z > range * range;
	}
}
