package net.invictusslayer.slayersbeasts.world.level.gen.structure.pieces;

import com.google.common.collect.Lists;
import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5468;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7924;
import net.minecraft.class_8891;
import net.minecraft.class_8917;
import net.minecraft.class_9822;
import net.minecraft.core.*;
import org.apache.commons.lang3.mutable.MutableObject;

import java.util.List;
import java.util.Optional;

public class CryptPieces {
	public static Optional<class_3195.class_7150> addPieces(class_3195.class_7149 context, class_6880<class_3785> start, class_2338 pos, int maxDistanceFromCenter, class_8891 lookup, class_9822 liquidSettings) {
		class_5455 access = context.comp_561();
		class_2794 chunkGen = context.comp_562();
		class_3485 manager = context.comp_565();
		class_5539 heightAccessor = context.comp_569();
		class_2919 random = context.comp_566();
		class_2378<class_3785> registry = access.method_30530(class_7924.field_41249);
		class_3785 pool = start.comp_349();
		class_3784 element = pool.method_16631(random);

		class_2382 vec3i = pos.method_10059(pos);
		class_2338 blockPos = pos.method_10059(vec3i);
		class_3790 piece = new class_3790(manager, element, blockPos, element.method_19308(), class_2470.field_11467, element.method_16628(manager, blockPos, class_2470.field_11467), class_9822.field_52237);
		class_3341 box = piece.method_14935();
		int x = (box.method_35418() + box.method_35415()) / 2;
		int z = (box.method_35420() + box.method_35417()) / 2;
		int y = vec3i.method_10264();

		return Optional.of(new class_3195.class_7150(new class_2338(x, y, z), builder -> {
			List<class_3790> list = Lists.newArrayList();
			list.add(piece);
			class_238 aabb = new class_238(x - maxDistanceFromCenter, y - maxDistanceFromCenter, z - maxDistanceFromCenter, x + maxDistanceFromCenter + 1, y + maxDistanceFromCenter + 1, z + maxDistanceFromCenter + 1);
			class_265 shape = class_259.method_1072(class_259.method_1078(aabb), class_259.method_1078(class_238.method_19316(box)), class_247.field_16886);
			addPieces(context.comp_564(), 7, false, chunkGen, manager, heightAccessor, random, registry, piece, list, shape, lookup, liquidSettings);
			list.forEach(builder::method_35462);
		}));

	}

	private static void addPieces(class_7138 randomState, int maxDepth, boolean useExpansionHack, class_2794 chunkGenerator, class_3485 structureTemplateManager, class_5539 level, class_5819 random, class_2378<class_3785> pools, class_3790 startPiece, List<class_3790> pieces, class_265 free, class_8891 aliasLookup, class_9822 liquidSettings) {
		Placer placer = new Placer(pools, maxDepth, chunkGenerator, structureTemplateManager, pieces, random);
		placer.tryPlacingChildren(startPiece, new MutableObject<>(free), 0, useExpansionHack, level, randomState, aliasLookup, liquidSettings);

		while (placer.placing.hasNext()) {
			PieceState pieceState = placer.placing.next();
			placer.tryPlacingChildren(pieceState.piece, pieceState.free, pieceState.depth, useExpansionHack, level, randomState, aliasLookup, liquidSettings);
		}

	}

	record PieceState(class_3790 piece, MutableObject<class_265> free, int depth) {}

	private static final class Placer {
		private final class_2378<class_3785> pools;
		private final int maxDepth;
		private final class_2794 chunkGen;
		private final class_3485 manager;
		private final List<? super class_3790> pieces;
		private final class_5819 random;
		final class_8917<CryptPieces.PieceState> placing = new class_8917<>();

		Placer(class_2378<class_3785> pools, int maxDepth, class_2794 chunkGen, class_3485 manager, List<? super class_3790> pieces, class_5819 random) {
			this.pools = pools;
			this.maxDepth = maxDepth;
			this.chunkGen = chunkGen;
			this.manager = manager;
			this.pieces = pieces;
			this.random = random;
		}

		void tryPlacingChildren(class_3790 piece, MutableObject<class_265> free, int depth, boolean useExpansionHack, class_5539 level, class_7138 random, class_8891 lookup, class_9822 liquidSettings) {
			class_3784 element = piece.method_16644();
			class_2338 pos = piece.method_16648();
			class_2470 rotation = piece.method_16888();
			class_3785.class_3786 projection = element.method_16624();
			boolean flag = projection == class_3785.class_3786.field_16687;
			MutableObject<class_265> mutableObject = new MutableObject<>();
			class_3341 box = piece.method_14935();
			int y = box.method_35416();

			loop:
			for (class_3499.class_10326 jigsawBlockInfo : element.method_16627(this.manager, pos, rotation, this.random)) {
				class_3499.class_3501 info = jigsawBlockInfo.comp_3278();
				class_2350 direction = class_3748.method_26378(info.comp_1342());
				class_2338 blockPos = info.comp_1341();
				class_2338 blockPos1 = blockPos.method_10093(direction);
				int j = blockPos.method_10264() - y;
				int k = Integer.MIN_VALUE;
				class_5321<class_3785> resourceKey = readPoolName(jigsawBlockInfo, lookup);
				Optional<? extends class_6880<class_3785>> optional = this.pools.method_46746(resourceKey);
				if (optional.isEmpty()) {
					SlayersBeasts.LOGGER.warn("Empty or non-existent pool: {}", resourceKey.method_29177());
				} else {
					class_6880<class_3785> holder = optional.get();
					if (holder.comp_349().method_16632() == 0 && !holder.method_40225(class_5468.field_26254)) {
						SlayersBeasts.LOGGER.warn("Empty or non-existent pool: {}", resourceKey.method_29177());
					} else {
						class_6880<class_3785> holder2 = holder.comp_349().method_46736();
						if (holder2.comp_349().method_16632() == 0 && !holder2.method_40225(class_5468.field_26254)) {
							SlayersBeasts.LOGGER.warn("Empty or non-existent fallback pool: {}", holder2.method_40230().map(resourceKeyx -> resourceKeyx.method_29177().toString()).orElse("<unregistered>"));
						} else {
							boolean bl2 = box.method_14662(blockPos1);
							MutableObject<class_265> mutableObject2;
							if (bl2) {
								mutableObject2 = mutableObject;
								if (mutableObject.getValue() == null) {
									mutableObject.setValue(class_259.method_1078(class_238.method_19316(box)));
								}
							} else {
								mutableObject2 = free;
							}

							List<class_3784> list = Lists.newArrayList();
							if (depth != this.maxDepth) {
								list.addAll(holder.comp_349().method_16633(this.random));
							}

							list.addAll(holder2.comp_349().method_16633(this.random));
							int l = jigsawBlockInfo.comp_3283();

							for (class_3784 poolElement : list) {
								if (poolElement == class_3777.field_16663) {
									break;
								}

								for (class_2470 rotation2 : class_2470.method_16547(this.random)) {
									List<class_3499.class_10326> list2 = poolElement.method_16627(this.manager, class_2338.field_10980, rotation2, this.random);
									class_3341 boundingBox2 = poolElement.method_16628(this.manager, class_2338.field_10980, rotation2);
									int m;
									if (useExpansionHack && boundingBox2.method_14660() <= 16) {
										m = list2.stream().mapToInt(jigsawBlockInfox -> {
											class_3499.class_3501 structureBlockInfox = jigsawBlockInfox.comp_3278();
											if (!boundingBox2.method_14662(structureBlockInfox.comp_1341().method_10093(class_3748.method_26378(structureBlockInfox.comp_1342())))) {
												return 0;
											} else {
												class_5321<class_3785> resourceKeyx = readPoolName(jigsawBlockInfox, lookup);
												Optional<? extends class_6880<class_3785>> optionalx = this.pools.method_46746(resourceKeyx);
												Optional<class_6880<class_3785>> optional2 = optionalx.map(holderx -> holderx.comp_349().method_46736());
												int ix = optionalx.map(holderx -> holderx.comp_349().method_19309(this.manager)).orElse(0);
												int jx = optional2.map(holderx -> holderx.comp_349().method_19309(this.manager)).orElse(0);
												return Math.max(ix, jx);
											}
										}).max().orElse(0);
									} else {
										m = 0;
									}

									for (class_3499.class_10326 jigsawBlockInfo2 : list2) {
										if (class_3748.method_16546(jigsawBlockInfo, jigsawBlockInfo2)) {
											class_2338 blockPos4 = jigsawBlockInfo2.comp_3278().comp_1341();
											class_2338 blockPos5 = blockPos1.method_10059(blockPos4);
											class_3341 boundingBox3 = poolElement.method_16628(this.manager, blockPos5, rotation2);
											int n = boundingBox3.method_35416();
											class_3785.class_3786 projection2 = poolElement.method_16624();
											boolean bl3 = projection2 == class_3785.class_3786.field_16687;
											int o = blockPos4.method_10264();
											int p = j - o + class_3748.method_26378(info.comp_1342()).method_10164();
											int q;
											if (flag && bl3) {
												q = y + p;
											} else {
												if (k == Integer.MIN_VALUE) {
													k = this.chunkGen.method_20402(blockPos.method_10263(), blockPos.method_10260(), class_2902.class_2903.field_13194, level, random);
												}

												q = k - o;
											}

											int r = q - n;
											class_3341 boundingBox4 = boundingBox3.method_19311(0, r, 0);
											class_2338 blockPos6 = blockPos5.method_10069(0, r, 0);
											if (m > 0) {
												int s = Math.max(m + 1, boundingBox4.method_35419() - boundingBox4.method_35416());
												boundingBox4.method_34389(new class_2338(boundingBox4.method_35415(), boundingBox4.method_35416() + s, boundingBox4.method_35417()));
											}

											if (!class_259.method_1074(mutableObject2.getValue(), class_259.method_1078(class_238.method_19316(boundingBox4).method_1011(0.25)), class_247.field_16893)) {
												mutableObject2.setValue(class_259.method_1082(mutableObject2.getValue(), class_259.method_1078(class_238.method_19316(boundingBox4)), class_247.field_16886));
												int s = piece.method_16646();
												int t;
												if (bl3) {
													t = s - p;
												} else {
													t = poolElement.method_19308();
												}

												class_3790 poolElementStructurePiece = new class_3790(
														this.manager, poolElement, blockPos6, t, rotation2, boundingBox4, liquidSettings
												);
												int u;
												if (flag) {
													u = y + j;
												} else if (bl3) {
													u = q + o;
												} else {
													if (k == Integer.MIN_VALUE) {
														k = this.chunkGen.method_20402(blockPos.method_10263(), blockPos.method_10260(), class_2902.class_2903.field_13194, level, random);
													}

													u = k + p / 2;
												}

												piece.method_16647(new class_3780(blockPos1.method_10263(), u - j + s, blockPos1.method_10260(), p, projection2));
												poolElementStructurePiece.method_16647(new class_3780(blockPos.method_10263(), u - o + t, blockPos.method_10260(), -p, projection));
												this.pieces.add(poolElementStructurePiece);
												if (depth + 1 <= this.maxDepth) {
													PieceState pieceState = new PieceState(poolElementStructurePiece, mutableObject2, depth + 1);
													this.placing.method_54726(pieceState, l);
												}
												continue loop;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}

		private static class_5321<class_3785> readPoolName(class_3499.class_10326 info, class_8891 lookup) {
			return lookup.lookup(class_5468.method_64955(info.comp_3281()));
		}
	}
}
