package net.invictusslayer.slayersbeasts.world.level.gen.structure.pools;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.SBProcessorLists;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5321;
import net.minecraft.class_5468;
import net.minecraft.class_5497;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import java.util.function.Function;

public class RedwoodLodgePools extends SBPools {
	public static final class_5321<class_3785> START = createKey("cabin");
	private static final class_5321<class_3785> PATHS = createKey("paths");
	private static final class_5321<class_3785> CAMP = createKey("camp");
	private static final class_5321<class_3785> DECOR = createKey("decor");

	public static void bootstrap(class_7891<class_3785> context) {
		class_7871<class_3785> pools = context.method_46799(class_7924.field_41249);
		class_7871<class_5497> processors = context.method_46799(class_7924.field_41247);

		register(context, START, pools.method_46747(class_5468.field_26254), class_3785.class_3786.field_16687, ImmutableList.of(element("cabin", 1)));
		register(context, PATHS, pools.method_46747(DECOR), class_3785.class_3786.field_16686, ImmutableList.of(element("path_straight", 3, processors.method_46747(SBProcessorLists.REDWOOD_PATH)), element("path_corner", 2, processors.method_46747(SBProcessorLists.REDWOOD_PATH)), element("path_cross", 1, processors.method_46747(SBProcessorLists.REDWOOD_PATH))));
		register(context, CAMP, pools.method_46747(class_5468.field_26254), class_3785.class_3786.field_16687, ImmutableList.of(element("campfire", 3), element("shed_1", 1), element("shed_2", 1), element("storage", 4)));
		register(context, DECOR, pools.method_46747(class_5468.field_26254), class_3785.class_3786.field_16687, ImmutableList.of(element("logs_1", 1), element("logs_2", 1), element("well", 1)));
	}

	private static Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer> element(String name, int weight) {
		return parentElement("lodge/redwood", name, weight);
	}

	private static Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer> element(String name, int weight, class_6880<class_5497> processor) {
		return parentElement("lodge/redwood", name, weight, processor);
	}

	private static class_5321<class_3785> createKey(String name) {
		return createParentKey("lodge/redwood", name);
	}
}
