package net.invictusslayer.slayersbeasts.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.invictusslayer.slayersbeasts.world.level.block.SBWoodFamily;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;

@Environment(EnvType.CLIENT)
public class SBFabricClient implements ClientModInitializer {
	public void onInitializeClient() {
		SlayersBeasts.clientSetup();
		SBClient.registerModelLayers((location, definition) -> EntityModelLayerRegistry.registerModelLayer(location, definition::get));
		SBClient.registerRenderers(EntityRendererRegistry::register);

		renderWoodFamilies();
		BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23581(),
				SBBlocks.ALGAE.get(), SBBlocks.TALL_DEAD_BUSH.get(),
				SBBlocks.TALL_BROWN_MUSHROOM.get(), SBBlocks.TALL_RED_MUSHROOM.get(),
				SBBlocks.BLACK_MUSHROOM.get(), SBBlocks.POTTED_BLACK_MUSHROOM.get(), SBBlocks.TALL_BLACK_MUSHROOM.get(),
				SBBlocks.WHITE_MUSHROOM.get(), SBBlocks.POTTED_WHITE_MUSHROOM.get(), SBBlocks.TALL_WHITE_MUSHROOM.get(),
				SBBlocks.WILLOW_BRANCH.get(), SBBlocks.WILLOW_BRANCH_PLANT.get(),
				SBBlocks.ICICLE.get(), SBBlocks.OBSIDIAN_SPIKE.get());
	}

	private void renderWoodFamilies() {
		SBWoodFamily.getAllFamilies().forEach(family -> family.getVariants().forEach((variant, supplier) -> {
			if (variant.isCutout()) BlockRenderLayerMap.INSTANCE.putBlock((class_2248) supplier.get(), class_1921.method_23581());
		}));
	}
}
