package net.invictusslayer.slayersbeasts.client.renderer.layer;

import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.invictusslayer.slayersbeasts.client.model.AntCargoModel;
import net.invictusslayer.slayersbeasts.client.model.AntWorkerModel;
import net.invictusslayer.slayersbeasts.world.entity.AntWorker;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_922;

public class AntCargoLayer<T extends AntWorker> extends class_3887<T, AntWorkerModel<T>> {
	private static final class_2960 LEAF = class_2960.method_60655(SlayersBeasts.MOD_ID, "textures/entity/ant/cargo/leaf.png");
	private static final class_2960 BARK = class_2960.method_60655(SlayersBeasts.MOD_ID, "textures/entity/ant/cargo/bark.png");
	private final AntCargoModel<T> model;

	public AntCargoLayer(class_3883<T, AntWorkerModel<T>> parent, class_5599 set) {
		super(parent);
		model = new AntCargoModel<>(set.method_32072(AntCargoModel.LAYER_LOCATION));
	}

	public void render(class_4587 poseStack, class_4597 bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
		if (entity.getCargoType() == 99) return;

        if (entity.method_5767() && class_310.method_1551().method_27022(entity)) {
            method_17165().method_17081(model);
            model.method_2816(entity, limbSwing, limbSwingAmount, partialTick);
            model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            class_4588 consumer = bufferSource.getBuffer(class_1921.method_23287(LEAF));
            model.method_60879(poseStack, consumer, packedLight, class_922.method_23622(entity, 0.0F));
			return;
        }

        if (entity.getCargoType() == 1) {
            method_23199(model, LEAF, poseStack, bufferSource, packedLight, entity, -1);
        } else if (entity.getCargoType() == 2) {
            method_23199(model, BARK, poseStack, bufferSource, packedLight, entity, -1);
        }
	}
}
