package net.invictusslayer.slayersbeasts.mixin.common;

import net.invictusslayer.slayersbeasts.world.entity.vehicle.SBBoatType;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.invictusslayer.slayersbeasts.registries.SBItems;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1690.class)
public abstract class BoatMixin {
	@Shadow
	public abstract Object getVariant();

	@Inject(method = "getDropItem", at = @At("HEAD"), cancellable = true)
	private void onGetDropItem(CallbackInfoReturnable<class_1792> cir) {
		if (getVariant() == SBBoatType.ASPEN) cir.setReturnValue(SBItems.ASPEN_BOAT.get());
		if (getVariant() == SBBoatType.BLOODWOOD) cir.setReturnValue(SBItems.BLOODWOOD_BOAT.get());
		if (getVariant() == SBBoatType.CYPRESS) cir.setReturnValue(SBItems.CYPRESS_BOAT.get());
		if (getVariant() == SBBoatType.DESERT_OAK) cir.setReturnValue(SBItems.DESERT_OAK_BOAT.get());
		if (getVariant() == SBBoatType.EUCALYPTUS) cir.setReturnValue(SBItems.EUCALYPTUS_BOAT.get());
		if (getVariant() == SBBoatType.KAPOK) cir.setReturnValue(SBItems.KAPOK_BOAT.get());
		if (getVariant() == SBBoatType.REDWOOD) cir.setReturnValue(SBItems.REDWOOD_BOAT.get());
		if (getVariant() == SBBoatType.WILLOW) cir.setReturnValue(SBItems.WILLOW_BOAT.get());
	}
}
