package net.invictusslayer.slayersbeasts.mixin.common;

import net.invictusslayer.slayersbeasts.world.entity.vehicle.SBBoatType;
import net.minecraft.class_1690;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.Arrays;

@Mixin(class_1690.class_1692.class)
public abstract class BoatTypeMixin {
	@Shadow @Final @Mutable
	private static class_1690.class_1692[] $VALUES;
	@Shadow @Final
	private String name;

	@Invoker("<init>")
	private static class_1690.class_1692 newBoatType(String name, int id, class_2248 block, String type) {
		throw new AssertionError();
	}

	@Inject(method = "<clinit>", at = @At(value = "FIELD", opcode = Opcodes.PUTSTATIC, target = "Lnet/minecraft/world/entity/vehicle/Boat$Type;$VALUES:[Lnet/minecraft/world/entity/vehicle/Boat$Type;", shift = At.Shift.AFTER))
	private static void onClinit(CallbackInfo ci) {
		ArrayList<class_1690.class_1692> types = new ArrayList<>(Arrays.asList($VALUES));
		SBBoatType.ASPEN = newBoatType("ASPEN", types.size(), class_2246.field_10161, "aspen");
		SBBoatType.BLOODWOOD = newBoatType("BLOODWOOD", types.size() + 1, class_2246.field_10161, "bloodwood");
		SBBoatType.CYPRESS = newBoatType("CYPRESS", types.size() + 2, class_2246.field_10161, "cypress");
		SBBoatType.DESERT_OAK = newBoatType("DESERT_OAK", types.size() + 3, class_2246.field_10161, "desert_oak");
		SBBoatType.EUCALYPTUS = newBoatType("EUCALYPTUS", types.size() + 4, class_2246.field_10161, "eucalyptus");
		SBBoatType.KAPOK = newBoatType("KAPOK", types.size() + 5, class_2246.field_10161, "kapok");
		SBBoatType.REDWOOD = newBoatType("REDWOOD", types.size() + 6, class_2246.field_10161, "redwood");
		SBBoatType.WILLOW = newBoatType("WILLOW", types.size() + 7, class_2246.field_10161, "willow");
		types.addAll(SBBoatType.values());
		$VALUES = types.toArray(new class_1690.class_1692[0]);
	}

	@Shadow
	public static class_1690.class_1692 byName(String name) {
		return null;
	}

	@Inject(method = "getPlanks", at = @At("HEAD"), cancellable = true)
	private void onGetPlanks(CallbackInfoReturnable<class_2248> cir) {
		if (byName(name).equals(SBBoatType.ASPEN)) cir.setReturnValue(SBBlocks.ASPEN_PLANKS.get());
		if (byName(name).equals(SBBoatType.BLOODWOOD)) cir.setReturnValue(SBBlocks.BLOODWOOD_PLANKS.get());
		if (byName(name).equals(SBBoatType.CYPRESS)) cir.setReturnValue(SBBlocks.CYPRESS_PLANKS.get());
		if (byName(name).equals(SBBoatType.DESERT_OAK)) cir.setReturnValue(SBBlocks.DESERT_OAK_PLANKS.get());
		if (byName(name).equals(SBBoatType.EUCALYPTUS)) cir.setReturnValue(SBBlocks.EUCALYPTUS_PLANKS.get());
		if (byName(name).equals(SBBoatType.KAPOK)) cir.setReturnValue(SBBlocks.KAPOK_PLANKS.get());
		if (byName(name).equals(SBBoatType.REDWOOD)) cir.setReturnValue(SBBlocks.REDWOOD_PLANKS.get());
		if (byName(name).equals(SBBoatType.WILLOW)) cir.setReturnValue(SBBlocks.WILLOW_PLANKS.get());
	}
}
