package net.invictusslayer.slayersbeasts.mixin.common;

import net.invictusslayer.slayersbeasts.world.level.block.IExtendedMushroomBlock;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2420;
import net.minecraft.class_2680;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;

@SuppressWarnings("AddedMixinMembersNamePattern")
@Mixin(class_2420.class)
public class MushroomBlockMixin implements IExtendedMushroomBlock {
	@Unique
	private class_5321<class_2975<?, ?>> mightyMushroom;

	@Inject(method = "growMushroom", at = @At("HEAD"), cancellable = true)
	private void onGrowMushroom(class_3218 level, class_2338 pos, class_2680 state, class_5819 random, CallbackInfoReturnable<Boolean> cir) {
		Optional<? extends class_6880<class_2975<?, ?>>> feature = level.method_30349().method_30530(class_7924.field_41239).method_40264(mightyMushroom);
		if (feature.isEmpty()) cir.setReturnValue(false);

		for (int x = 0; x >= -1; --x) {
			for (int z = 0; z >= -1; --z) {
				if (isTwoByTwoMushroom(state, level, pos, x, z)) {
					level.method_8650(pos.method_10069(x, 0, z), false);
					level.method_8650(pos.method_10069(x + 1, 0, z), false);
					level.method_8650(pos.method_10069(x, 0, z + 1), false);
					level.method_8650(pos.method_10069(x + 1, 0, z + 1), false);
					if (feature.get().comp_349().method_12862(level, level.method_14178().method_12129(), random, pos.method_10069(x, 0, z))) cir.setReturnValue(true);
					else {
						level.method_8652(pos.method_10069(x, 0, z), state, 3);
						level.method_8652(pos.method_10069(x + 1, 0, z), state, 3);
						level.method_8652(pos.method_10069(x, 0, z + 1), state, 3);
						level.method_8652(pos.method_10069(x + 1, 0, z + 1), state, 3);
						cir.setReturnValue(false);
					}
				}
			}
		}
	}

	@Unique
	private boolean isTwoByTwoMushroom(class_2680 state, class_1922 level, class_2338 pos, int x, int z) {
		class_2248 block = state.method_26204();
		return level.method_8320(pos.method_10069(x, 0, z)).method_27852(block) &&
				level.method_8320(pos.method_10069(x + 1, 0, z)).method_27852(block) &&
				level.method_8320(pos.method_10069(x, 0, z + 1)).method_27852(block) &&
				level.method_8320(pos.method_10069(x + 1, 0, z + 1)).method_27852(block);
	}

	@Override
	public void setMightyMushroom(class_5321<class_2975<?, ?>> mightyMushroom) {
		this.mightyMushroom = mightyMushroom;
	}
}
