package net.invictusslayer.slayersbeasts.mixin.common;

import net.invictusslayer.slayersbeasts.world.feature.tree.IExtendedTreeGrower;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8813;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@SuppressWarnings("AddedMixinMembersNamePattern")
@Mixin(class_8813.class)
public class TreeGrowerMixin implements IExtendedTreeGrower {
	@Shadow @Final
	private float secondaryChance;

	@Unique
	private class_5321<class_2975<?, ?>> gigaTree = null;
	@Unique
	private class_5321<class_2975<?, ?>> secondaryGigaTree = null;

	@Inject(method = "growTree", at = @At("HEAD"), cancellable = true)
	private void onGrowTree(class_3218 level, class_2794 chunkGen, class_2338 pos, class_2680 state, class_5819 random, CallbackInfoReturnable<Boolean> cir) {
		class_5321<class_2975<?, ?>> feature = getConfiguredGigaFeature(random);
		if (feature != null) {
			class_6880<class_2975<?, ?>> holder = level.method_30349().method_30530(class_7924.field_41239).method_40264(feature).orElse(null);
			if (holder != null) {
				for (int x = 0; x >= -2; --x) {
					for (int z = 0; z >= -2; --z) {
						if (isThreeByThreeSapling(state, level, pos, x, z)) {
							class_2975<?, ?> tree = holder.comp_349();
							class_2680 air = class_2246.field_10124.method_9564();
							level.method_8652(pos.method_10069(x, 0, z), air, 4);
							level.method_8652(pos.method_10069(x + 1, 0, z), air, 4);
							level.method_8652(pos.method_10069(x + 2, 0, z), air, 4);
							level.method_8652(pos.method_10069(x, 0, z + 1), air, 4);
							level.method_8652(pos.method_10069(x + 1, 0, z + 1), air, 4);
							level.method_8652(pos.method_10069(x + 2, 0, z + 1), air, 4);
							level.method_8652(pos.method_10069(x, 0, z + 2), air, 4);
							level.method_8652(pos.method_10069(x + 1, 0, z + 2), air, 4);
							level.method_8652(pos.method_10069(x + 2, 0, z + 2), air, 4);
							if (tree.method_12862(level, chunkGen, random, pos.method_10069(x, 0, z))) cir.setReturnValue(true);
							else {
								level.method_8652(pos.method_10069(x, 0, z), state, 4);
								level.method_8652(pos.method_10069(x + 1, 0, z), state, 4);
								level.method_8652(pos.method_10069(x + 2, 0, z), state, 4);
								level.method_8652(pos.method_10069(x, 0, z + 1), state, 4);
								level.method_8652(pos.method_10069(x + 1, 0, z + 1), state, 4);
								level.method_8652(pos.method_10069(x + 2, 0, z + 1), state, 4);
								level.method_8652(pos.method_10069(x, 0, z + 2), state, 4);
								level.method_8652(pos.method_10069(x + 1, 0, z + 2), state, 4);
								level.method_8652(pos.method_10069(x + 2, 0, z + 2), state, 4);
								cir.setReturnValue(false);
							}
						}
					}
				}
			}
		}
	}

	@Unique
	private class_5321<class_2975<?, ?>> getConfiguredGigaFeature(class_5819 random) {
		return secondaryGigaTree != null && random.method_43057() < secondaryChance ? secondaryGigaTree : gigaTree;
	}

	@Unique
	private boolean isThreeByThreeSapling(class_2680 state, class_1922 level, class_2338 pos, int x, int z) {
		class_2248 block = state.method_26204();
		return level.method_8320(pos.method_10069(x, 0, z)).method_27852(block) &&
				level.method_8320(pos.method_10069(x + 1, 0, z)).method_27852(block) &&
				level.method_8320(pos.method_10069(x + 2, 0, z)).method_27852(block) &&
				level.method_8320(pos.method_10069(x, 0, z + 1)).method_27852(block) &&
				level.method_8320(pos.method_10069(x + 1, 0, z + 1)).method_27852(block) &&
				level.method_8320(pos.method_10069(x + 2, 0, z + 1)).method_27852(block) &&
				level.method_8320(pos.method_10069(x, 0, z + 2)).method_27852(block) &&
				level.method_8320(pos.method_10069(x + 1, 0, z + 2)).method_27852(block) &&
				level.method_8320(pos.method_10069(x + 2, 0, z + 2)).method_27852(block);
	}

	@Override
	public void setGigaTree(class_5321<class_2975<?, ?>> gigaTree) {
		this.gigaTree = gigaTree;
	}

	@Override
	public void setSecondaryGigaTree(class_5321<class_2975<?, ?>> secondaryGigaTree) {
		this.secondaryGigaTree = secondaryGigaTree;
	}
}
