package net.invictusslayer.slayersbeasts.registries;

import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.invictusslayer.slayersbeasts.world.level.gen.feature.tree.decorator.ButtressRootDecorator;
import net.invictusslayer.slayersbeasts.world.level.gen.feature.tree.decorator.HangingBranchDecorator;
import net.invictusslayer.slayersbeasts.world.level.gen.feature.tree.decorator.OothecaDecorator;
import net.minecraft.class_4663;
import net.minecraft.class_7923;
import java.util.function.Supplier;

public class SBTreeDecorators {
	public static final Supplier<class_4663<?>> BUTTRESS_ROOT = register("buttress_root", () -> new class_4663<>(ButtressRootDecorator.CODEC));
	public static final Supplier<class_4663<?>> OOTHECA = register("ootheca", () -> new class_4663<>(OothecaDecorator.CODEC));
	public static final Supplier<class_4663<?>> HANGING_BRANCH = register("hanging_branch", () -> new class_4663<>(HangingBranchDecorator.CODEC));

	private static <T extends class_4663<?>> Supplier<T> register(String name, Supplier<T> supplier) {
		return SlayersBeasts.PLATFORM.register(class_7923.field_41153, SlayersBeasts.MOD_ID, name, supplier);
	}

	public static void register() {
		SlayersBeasts.LOGGER.info("Registering SBTreeDecorators...");
	}
}
