package net.invictusslayer.slayersbeasts.world.entity;

import net.invictusslayer.slayersbeasts.registries.SBEntities;
import net.invictusslayer.slayersbeasts.registries.SBSounds;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1359;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1369;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import net.minecraft.world.entity.*;
import net.minecraft.world.entity.ai.goal.*;
import java.util.Objects;

public class Mantis extends class_1314 {
	private static final class_2940<Boolean> DATA_IS_STRIKING = class_2945.method_12791(Mantis.class, class_2943.field_13323);
	private static final class_2940<Boolean> DATA_IS_SCUTTLING = class_2945.method_12791(Mantis.class, class_2943.field_13323);
	private static final class_2940<Boolean> DATA_IS_LEAPING = class_2945.method_12791(Mantis.class, class_2943.field_13323);
	private static final class_4048 SCUTTLING_DIMENSIONS = class_4048.method_18384(SBEntities.MANTIS.get().method_17685(), SBEntities.MANTIS.get().method_17686() - 0.8F);
	public final class_7094 flapAnimationState = new class_7094();
	public final class_7094 strikeAnimationState = new class_7094();

	public Mantis(class_1299<Mantis> type, class_1937 level) {
		super(type, level);
	}

	protected void method_5959() {
		field_6201.method_6277(0, new class_1347(this));
		field_6201.method_6277(1, new MantisScuttleGoal(this, 1.5D, 32.0F, 8.0F));
		field_6201.method_6277(2, new MantisLeapGoal(this, 0.6F));
		field_6201.method_6277(3, new class_1366(this, 1.0D, true));
		field_6201.method_6277(4, new class_1394(this, 0.8D));
		field_6201.method_6277(5, new class_1361(this, class_1657.class, 8.0F));
		field_6201.method_6277(6, new class_1376(this));
		field_6201.method_6277(7, new MantisPreenGoal(this));
		field_6185.method_6277(2, new class_1400<>(this, class_1657.class, true));
	}

	public static class_5132.class_5133 createAttributes() {
		return class_1308.method_26828()
				.method_26868(class_5134.field_23719, 0.25F)
				.method_26868(class_5134.field_23717, 24.0D)
				.method_26868(class_5134.field_23716, 15.0D)
				.method_26868(class_5134.field_23721, 2.0D)
				.method_26868(class_5134.field_23723, 2.0D)
				.method_26868(class_5134.field_23722, 1.0D);
	}

	public boolean method_6121(class_1297 entity) {
		if (!super.method_6121(entity)) {
			return false;
		}
		if (entity instanceof class_1309 livingEntity && field_5974.method_43056()) {
			livingEntity.method_37222(new class_1293(class_1294.field_5899, 30), this);
		}
		return true;
	}

	protected class_3414 method_5994() {
		return SBSounds.MANTIS_AMBIENT.get();
	}

	protected class_3414 method_6002() {
		return SBSounds.MANTIS_DEATH.get();
	}

	protected class_3414 method_6011(class_1282 damageSource) {
		return SBSounds.MANTIS_HURT.get();
	}

	public static boolean canSpawn(class_1299<Mantis> entity, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
		return class_1314.method_20636(entity, level, spawnType, pos, random) && level instanceof class_1937 level1 && level1.method_8407() != class_1267.field_5801;
	}

	protected void method_5693(class_2945.class_9222 builder) {
		super.method_5693(builder);
		builder.method_56912(DATA_IS_STRIKING, false);
		builder.method_56912(DATA_IS_SCUTTLING, false);
		builder.method_56912(DATA_IS_LEAPING, false);
	}

	public void method_5773() {
		super.method_5773();

		if (method_5968() != null) setStriking(method_5968().method_5858(this) < 8.0F);
		else setStriking(false);

		if (method_37908().method_8608()) {
			setupAnimationStates();
		}
	}

	private void setupAnimationStates() {
		flapAnimationState.method_45317(isLeaping(), field_6012);
		strikeAnimationState.method_45317(isStriking(), field_6012);
	}

	public boolean isStriking() {
		return field_6011.method_12789(DATA_IS_STRIKING);
	}

	public void setStriking(boolean striking) {
		field_6011.method_12778(DATA_IS_STRIKING, striking);
	}

	public boolean isScuttling() {
		return field_6011.method_12789(DATA_IS_SCUTTLING);
	}

	public void setScuttling(Boolean scuttling) {
		field_6011.method_12778(DATA_IS_SCUTTLING, scuttling);
	}

	public boolean isLeaping() {
		return field_6011.method_12789(DATA_IS_LEAPING);
	}

	public void setLeaping(Boolean leaping) {
		field_6011.method_12778(DATA_IS_LEAPING, leaping);
	}

	public class_4048 method_55694(class_4050 pose) {
		return isScuttling() ? SCUTTLING_DIMENSIONS.method_18383(method_55693()) : super.method_55694(pose);
	}

	static class MantisScuttleGoal extends class_1369 {
		private final Mantis mantis;
		private final float outside;

		public MantisScuttleGoal(Mantis mantis, double speedModifier, float within, float outside) {
			super(mantis, speedModifier, within);
			this.mantis = mantis;
			this.outside = outside;
		}

		public boolean method_6264() {
			return super.method_6264() && Objects.requireNonNull(mantis.method_5968()).method_5858(mantis) > outside * outside;
		}

		public void method_6269() {
			mantis.setScuttling(true);
			super.method_6269();
		}

		public void method_6270() {
			mantis.setScuttling(false);
			super.method_6270();
		}
	}

	static class MantisLeapGoal extends class_1359 {
		private final Mantis mantis;

		public MantisLeapGoal(Mantis mantis, float yd) {
			super(mantis, yd);
			this.mantis = mantis;
		}

		public void method_6269() {
			mantis.setLeaping(true);
			super.method_6269();
		}

		public void method_6270() {
			mantis.setLeaping(false);
		}
	}

	static class MantisPreenGoal extends class_1352 {
		private final Mantis mantis;
		private int preenTime;

		public MantisPreenGoal(Mantis mantis) {
			this.mantis = mantis;
		}

		public boolean method_6264() {
			return mantis.method_24828() && mantis.method_59922().method_43057() < 0.02F;
		}

		public boolean method_6266() {
			return preenTime >= 0;
		}

		public void method_6269() {
			preenTime = 15 + mantis.method_59922().method_43048(15);
		}

		public boolean method_38846() {
			return true;
		}

		public void method_6268() {
			--preenTime;
		}
	}
}
