package net.invictusslayer.slayersbeasts.world.level.biome;

import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.minecraft.class_1959;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import java.util.ArrayList;
import java.util.List;

public class SBBiomes {
	public static List<class_5321<class_1959>> BIOMES = new ArrayList<>();

	//Overground
	public static final class_5321<class_1959> ANCIENT_GROVE = createKey("ancient_grove");
	public static final class_5321<class_1959> ASPEN_FOREST = createKey("aspen_forest");
	public static final class_5321<class_1959> BAYOU = createKey("bayou");
	public static final class_5321<class_1959> BLACK_DUNES = createKey("black_dunes");
	public static final class_5321<class_1959> BRUSHLAND = createKey("brushland");
	public static final class_5321<class_1959> ROCKY_BRUSHLAND = createKey("rocky_brushland");
	public static final class_5321<class_1959> WOODED_BRUSHLAND = createKey("wooded_brushland");
	public static final class_5321<class_1959> CHAPARRAL = createKey("chaparral");
	public static final class_5321<class_1959> DEAD_SANDS = createKey("dead_sands");
	public static final class_5321<class_1959> EUCALYPT_WOODLAND = createKey("eucalypt_woodland");
	public static final class_5321<class_1959> FROZEN_THICKET = createKey("frozen_thicket");
	public static final class_5321<class_1959> GLACIATE_SWAMP = createKey("glaciate_swamp");
	public static final class_5321<class_1959> INKY_MOOR = createKey("inky_moor");
	public static final class_5321<class_1959> MURKY_OCEAN = createKey("murky_ocean");
	public static final class_5321<class_1959> DEEP_MURKY_OCEAN = createKey("deep_murky_ocean");
	public static final class_5321<class_1959> MUSHROOM_FOREST = createKey("mushroom_forest");
	public static final class_5321<class_1959> OUTBACK = createKey("outback");
	public static final class_5321<class_1959> PETRIFIED_WOODS = createKey("petrified_woods");
	public static final class_5321<class_1959> RAINFOREST = createKey("rainforest");
	public static final class_5321<class_1959> REDWOOD_GROVE = createKey("redwood_grove");
	public static final class_5321<class_1959> OLD_GROWTH_REDWOOD_GROVE = createKey("old_growth_redwood_grove");
	public static final class_5321<class_1959> VOLCANIC_PEAKS = createKey("volcanic_peaks");

	//Underground
	public static final class_5321<class_1959> DUSTY_CAVERNS = createKey("dusty_caverns");
	public static final class_5321<class_1959> FUNGAL_DEPTHS = createKey("fungal_depths");
	public static final class_5321<class_1959> ICE_CAVES = createKey("ice_caves");
	public static final class_5321<class_1959> SLIME_CAVERNS = createKey("slime_caverns");

	//Nether
	public static final class_5321<class_1959> TOXIC_JUNGLE = createKey("toxic_jungle");

	//End
	public static final class_5321<class_1959> END_SPIKES = createKey("end_spikes");

	//Crypt
	public static final class_5321<class_1959> THE_CRYPT = createKey("the_crypt");

	public static void bootstrap(class_7891<class_1959> context) {
		class_7871<class_6796> placed = context.method_46799(class_7924.field_41245);
		class_7871<class_2922<?>> carver = context.method_46799(class_7924.field_41238);

		register(context, ANCIENT_GROVE, SBOverworldBiomes.ancientGrove(placed, carver));
		register(context, ASPEN_FOREST, SBOverworldBiomes.aspenForest(placed, carver));
		register(context, BAYOU, SBOverworldBiomes.bayou(placed, carver));
		register(context, BLACK_DUNES, SBOverworldBiomes.desert(placed, carver));
		register(context, BRUSHLAND, SBOverworldBiomes.brushland(placed, carver, false, false));
		register(context, ROCKY_BRUSHLAND, SBOverworldBiomes.brushland(placed, carver, false, true));
		register(context, WOODED_BRUSHLAND, SBOverworldBiomes.brushland(placed, carver, true, false));
		register(context, CHAPARRAL, SBOverworldBiomes.chaparral(placed, carver));
		register(context, DEAD_SANDS, SBOverworldBiomes.desert(placed, carver));
		register(context, EUCALYPT_WOODLAND, SBOverworldBiomes.eucalyptWoodland(placed, carver));
		register(context, FROZEN_THICKET, SBOverworldBiomes.frozenThicket(placed, carver));
		register(context, GLACIATE_SWAMP, SBOverworldBiomes.bayou(placed, carver));
		register(context, INKY_MOOR, SBOverworldBiomes.inkyMoor(placed, carver));
		register(context, MURKY_OCEAN, SBOverworldBiomes.murkyOcean(placed, carver, false));
		register(context, DEEP_MURKY_OCEAN, SBOverworldBiomes.murkyOcean(placed, carver, true));
		register(context, MUSHROOM_FOREST, SBOverworldBiomes.mushroomForest(placed, carver));
		register(context, OUTBACK, SBOverworldBiomes.outback(placed, carver));
		register(context, PETRIFIED_WOODS, SBOverworldBiomes.petrifiedWoods(placed, carver));
		register(context, RAINFOREST, SBOverworldBiomes.rainforest(placed, carver));
		register(context, REDWOOD_GROVE, SBOverworldBiomes.redwoodGrove(placed, carver, false));
		register(context, OLD_GROWTH_REDWOOD_GROVE, SBOverworldBiomes.redwoodGrove(placed, carver, true));
		register(context, VOLCANIC_PEAKS, SBOverworldBiomes.volcanicPeaks(placed, carver));

		register(context, DUSTY_CAVERNS, SBOverworldBiomes.dustyCaverns(placed, carver));
		register(context, FUNGAL_DEPTHS, SBOverworldBiomes.fungalDepths(placed, carver));
		register(context, ICE_CAVES, SBOverworldBiomes.iceCaves(placed, carver));
		register(context, SLIME_CAVERNS, SBOverworldBiomes.slimeCaverns(placed, carver));
		register(context, THE_CRYPT, SBOverworldBiomes.theCrypt(placed, carver));

		register(context, TOXIC_JUNGLE, SBNetherBiomes.toxicJungle(placed, carver));

		register(context, END_SPIKES, SBEndBiomes.endSpikes(placed, carver));
	}

	private static class_5321<class_1959> createKey(String name) {
		return class_5321.method_29179(class_7924.field_41236, class_2960.method_60655(SlayersBeasts.MOD_ID, name));
	}

	private static void register(class_7891<class_1959> context, class_5321<class_1959> key, class_1959 biome) {
		context.method_46838(key, biome);
		BIOMES.add(key);
	}
}
