package net.invictusslayer.slayersbeasts.world.level.biome;

import net.invictusslayer.slayersbeasts.registries.SBEntities;
import net.invictusslayer.slayersbeasts.world.level.gen.feature.SBPlacedFeatures;
import net.minecraft.class_1143;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3864;
import net.minecraft.class_4763;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_5463;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6796;
import net.minecraft.class_6811;
import net.minecraft.class_6814;
import net.minecraft.class_6819;
import net.minecraft.class_7871;
import net.minecraft.world.level.biome.*;

public class SBOverworldBiomes {
	private static final int DEFAULT_WATER = 4159204;
	private static final int DEFAULT_WATER_FOG = 329011;
	private static final int DEFAULT_FOG = 12638463;
	private static final class_1959.class_5484 FROZEN = class_1959.class_5484.field_26408;
	private static final class_1959.class_5484 NONE = class_1959.class_5484.field_26407;
	private static final class_5195 MUSIC_DESERT = class_1143.method_27283(class_3417.field_44695);
	private static final class_5195 MUSIC_FOREST = class_1143.method_27283(class_3417.field_44693);
	private static final class_5195 MUSIC_FROZEN = class_1143.method_27283(class_3417.field_35349);
	private static final class_5195 MUSIC_OUTBACK = class_1143.method_27283(class_3417.field_44696);
	private static final class_5195 MUSIC_RAINFOREST = class_1143.method_27283(class_3417.field_44697);
	private static final class_5195 MUSIC_REDWOOD = class_1143.method_27283(class_3417.field_38927);
	private static final class_5195 MUSIC_SWAMP = class_1143.method_27283(class_3417.field_38925);
	private static final class_5195 MUSIC_VOLCANIC = class_1143.method_27283(class_3417.field_23793);
	private static final class_5195 MUSIC_DRIPSTONE = class_1143.method_27283(class_3417.field_35344);
	private static final class_5195 MUSIC_LUSH = class_1143.method_27283(class_3417.field_35347);

	public static class_1959 ancientGrove(class_7871<class_6796> features, class_7871<class_2922<?>> carvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);
		mobSettings.method_31011(class_1311.field_6302, new class_5483.class_1964(SBEntities.MANTIS.get(), 6, 1, 3));

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_38568(biomeSettings);
		class_3864.method_17010(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36166);
		class_3864.method_16982(biomeSettings);
		class_3864.method_16984(biomeSettings);

		addModUndergroundVariety(biomeSettings);
		addModMushrooms(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.TREES_RAINFOREST);
		return biome(true, 0.6F, 0.6F, mobSettings, biomeSettings, MUSIC_RAINFOREST);
	}

	public static class_1959 aspenForest(class_7871<class_6796> features, class_7871<class_2922<?>> carvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_38568(biomeSettings);
		class_3864.method_17010(biomeSettings);
		class_3864.method_16977(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36166);
		class_3864.method_16982(biomeSettings);
		class_3864.method_16984(biomeSettings);

		addModUndergroundVariety(biomeSettings);
		addModMushrooms(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.TREES_ASPEN);
		return biome(true, 0.6F, 0.6F, mobSettings, biomeSettings, MUSIC_FOREST);
	}

	public static class_1959 bayou(class_7871<class_6796> features, class_7871<class_2922<?>> carvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);
		mobSettings.method_31011(class_1311.field_6302, new class_5483.class_1964(class_1299.field_6069, 1, 1, 1));
		mobSettings.method_31011(class_1311.field_6294, new class_5483.class_1964(class_1299.field_37419, 10, 2, 5));
		mobSettings.method_31011(class_1311.field_6303, new class_5483.class_1964(SBEntities.DAMSELFLY.get(), 4, 1, 1));

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_38568(biomeSettings);
		class_3864.method_43231(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36169);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36175);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36180);
		class_3864.method_16982(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36114);

		addModUndergroundVariety(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.PATCH_ALGAE_COMMON);
		addModMushrooms(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.TREES_BAYOU);
		return biome(true, 0.9F, 0.8F, NONE, 2642743, 2192174, null, 6975545, class_4763.class_5486.field_26428, mobSettings, biomeSettings, MUSIC_SWAMP);
	}

	public static class_1959 brushland(class_7871<class_6796> features, class_7871<class_2922<?>> carvers, boolean wooded, boolean rocky) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		globalOverworldGeneration(biomeSettings);
		if (rocky) biomeSettings.method_30992(class_2893.class_2895.field_13171, class_6814.field_36003);
		class_3864.method_38568(biomeSettings);
		class_3864.method_17010(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36182);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36174);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36168);
		class_3864.method_16982(biomeSettings);
		class_3864.method_16984(biomeSettings);

		addMudPits(biomeSettings);
		addModUndergroundVariety(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.PATCH_TALL_DEAD_BUSH_BRUSH);
		addModMushrooms(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, wooded ? SBPlacedFeatures.TREES_WOODED_BRUSH : SBPlacedFeatures.TREES_BRUSH);
		return biome(false, 2F, 0F, mobSettings, biomeSettings, MUSIC_OUTBACK);
	}

	public static class_1959 chaparral(class_7871<class_6796> features, class_7871<class_2922<?>> carvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);
		mobSettings.method_31011(class_1311.field_6294, new class_5483.class_1964(class_1299.field_6140, 4, 2, 3));
		mobSettings.method_31011(class_1311.field_6294, new class_5483.class_1964(class_1299.field_17943, 8, 2, 4));

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_38568(biomeSettings);
		class_3864.method_17010(biomeSettings);
		class_3864.method_16977(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36175);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36168);
		class_3864.method_16982(biomeSettings);
		class_3864.method_16984(biomeSettings);

		addModUndergroundVariety(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.PATCH_TALL_DEAD_BUSH);
		addModMushrooms(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.TREES_CHAPARRAL);
		return biome(true, 0.8F, 0.4F, mobSettings, biomeSettings, MUSIC_OUTBACK);
	}

	public static class_1959 desert(class_7871<class_6796> features, class_7871<class_2922<?>> carvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);
		mobSettings.method_31011(class_1311.field_6302, new class_5483.class_1964(class_1299.field_6071, 80, 4, 4));

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_38568(biomeSettings);
		class_3864.method_17010(biomeSettings);
		class_3864.method_16977(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36175);
		class_3864.method_16982(biomeSettings);

		addMudPits(biomeSettings);
		addModUndergroundVariety(biomeSettings);
		addModMushrooms(biomeSettings);
		return biome(false, 2F, 0F, mobSettings, biomeSettings, MUSIC_DESERT);
	}

	public static class_1959 eucalyptWoodland(class_7871<class_6796> features, class_7871<class_2922<?>> carvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_38568(biomeSettings);
		class_3864.method_17010(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36183);
		class_3864.method_16977(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36170);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36124);
		class_3864.method_16982(biomeSettings);
		class_3864.method_16984(biomeSettings);

		addModUndergroundVariety(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.PATCH_TALL_DEAD_BUSH);
		addModMushrooms(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.TREES_EUCALYPT);
		return biome(true, 2F, 0F, mobSettings, biomeSettings, MUSIC_FOREST);
	}

	public static class_1959 frozenThicket(class_7871<class_6796> features, class_7871<class_2922<?>> carvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_38568(biomeSettings);
		class_3864.method_17010(biomeSettings);
		class_3864.method_16982(biomeSettings);
		class_3864.method_16984(biomeSettings);

		addModUndergroundVariety(biomeSettings);
		addModMushrooms(biomeSettings);
		return biome(true, 0F, 0.2F, FROZEN, DEFAULT_WATER, DEFAULT_WATER_FOG, null, null, null, mobSettings, biomeSettings, MUSIC_FROZEN);
	}

	public static class_1959 inkyMoor(class_7871<class_6796> features, class_7871<class_2922<?>> carvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);
		mobSettings.method_31011(class_1311.field_6302, new class_5483.class_1964(class_1299.field_6069, 1, 1, 1));
		mobSettings.method_31011(class_1311.field_6294, new class_5483.class_1964(class_1299.field_37419, 10, 2, 5));
		mobSettings.method_31011(class_1311.field_6303, new class_5483.class_1964(SBEntities.DAMSELFLY.get(), 4, 1, 1));

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_38568(biomeSettings);
		class_3864.method_43231(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36169);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36175);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36180);
		class_3864.method_16982(biomeSettings);
		class_3864.method_16984(biomeSettings);

		addModUndergroundVariety(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.PATCH_ALGAE_NORMAL);
		addModMushrooms(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.TREES_INKY);
		return biome(true, 0.9F, 0.8F, NONE, 2642743, 2192174, null, 6975545, class_4763.class_5486.field_26428, mobSettings, biomeSettings, MUSIC_SWAMP);
	}

	public static class_1959 murkyOcean(class_7871<class_6796> features, class_7871<class_2922<?>> carvers, boolean isDeep) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30679(mobSettings, 10, 4, 5);

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_38568(biomeSettings);
		class_3864.method_17010(biomeSettings);
		class_3864.method_17019(biomeSettings);
		class_3864.method_16977(biomeSettings);
		class_3864.method_16979(biomeSettings);
		class_3864.method_16982(biomeSettings);
		class_3864.method_16984(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, isDeep ? class_6811.field_35972 : class_6811.field_35973);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6811.field_35975);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6811.field_35977);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6811.field_35978);

		addModUndergroundVariety(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.PATCH_ALGAE_COMMON);
		addModMushrooms(biomeSettings);
		return biome(true, 0.9F, 0.8F, NONE, 2642743, 2192174, null, 6975545, class_4763.class_5486.field_26428, mobSettings, biomeSettings, MUSIC_SWAMP);
	}

	public static class_1959 mushroomForest(class_7871<class_6796> features, class_7871<class_2922<?>> carvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30585(mobSettings);

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_38568(biomeSettings);
		class_3864.method_17010(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.TREES_MUSHROOM);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36122);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36123);
		class_3864.method_16984(biomeSettings);

		addModUndergroundVariety(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.BLACK_MUSHROOM_COMMON);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.WHITE_MUSHROOM_COMMON);
		return biome(false, 2F, 0F, mobSettings, biomeSettings, null);
	}

	public static class_1959 outback(class_7871<class_6796> features, class_7871<class_2922<?>> carvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_38568(biomeSettings);
		class_3864.method_17010(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36169);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36175);
		class_3864.method_16982(biomeSettings);
		class_3864.method_16984(biomeSettings);

		addMudPits(biomeSettings);
		addModUndergroundVariety(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.PATCH_TALL_DEAD_BUSH);
		addModMushrooms(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.TREES_OUTBACK);
		return biome(false, 2F, 0F, mobSettings, biomeSettings, MUSIC_OUTBACK); // grass-9470285 foliage-10387789
	}

	public static class_1959 petrifiedWoods(class_7871<class_6796> features, class_7871<class_2922<?>> carvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_17010(biomeSettings);
		class_3864.method_16984(biomeSettings);

		addModUndergroundVariety(biomeSettings);
		return biome(false, 0F, 0F, class_1959.class_5484.field_26408, DEFAULT_WATER, DEFAULT_WATER_FOG, null, null, null, mobSettings, biomeSettings, MUSIC_FROZEN);
	}

	public static class_1959 rainforest(class_7871<class_6796> features, class_7871<class_2922<?>> carvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);
		mobSettings.method_31011(class_1311.field_6302, new class_5483.class_1964(SBEntities.MANTIS.get(), 6, 1, 3));
		mobSettings.method_31011(class_1311.field_6303, new class_5483.class_1964(SBEntities.DAMSELFLY.get(), 4, 1, 1));

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_38568(biomeSettings);
		class_3864.method_17010(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36172);
		class_3864.method_16982(biomeSettings);
		class_3864.method_16984(biomeSettings);

		addModUndergroundVariety(biomeSettings);
		addModMushrooms(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.TREES_RAINFOREST);
		return biome(true, 2F, 0F, mobSettings, biomeSettings, MUSIC_RAINFOREST);
	}

	public static class_1959 redwoodGrove(class_7871<class_6796> features, class_7871<class_2922<?>> carvers, boolean oldGrowth) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);
		mobSettings.method_31011(class_1311.field_6294, new class_5483.class_1964(class_1299.field_17943, 8, 2, 4));

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_38568(biomeSettings);
		class_3864.method_17010(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36183);
		class_3864.method_16977(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36171);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36175);
		class_3864.method_16982(biomeSettings);
		class_3864.method_16984(biomeSettings);

		addModUndergroundVariety(biomeSettings);
		addModMushrooms(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, oldGrowth ? SBPlacedFeatures.TREES_OLD_GROWTH_REDWOOD : SBPlacedFeatures.TREES_REDWOOD);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.WHITE_MUSHROOM_COMMON);
		return biome(true, 0.25F, 0.8F, mobSettings, biomeSettings, MUSIC_REDWOOD);
	}

	public static class_1959 volcanicPeaks(class_7871<class_6796> features, class_7871<class_2922<?>> carvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		class_3864.method_16983(biomeSettings);
		class_3864.method_32236(biomeSettings);
		class_3864.method_17004(biomeSettings);
		class_3864.method_16996(biomeSettings);
		class_3864.method_16999(biomeSettings);
		class_3864.method_16977(biomeSettings);
		class_3864.method_16982(biomeSettings);
		class_3864.method_16984(biomeSettings);

		addModMushrooms(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_25186, SBPlacedFeatures.LAKE_LAVA_VOLCANIC);
		biomeSettings.method_30992(class_2893.class_2895.field_13176, SBPlacedFeatures.ORE_OBSIDIAN);
		biomeSettings.method_30992(class_2893.class_2895.field_13176, SBPlacedFeatures.ORE_BASALT_VOLCANIC);
		biomeSettings.method_30992(class_2893.class_2895.field_13176, SBPlacedFeatures.ORE_GRANITE_VOLCANIC);
		biomeSettings.method_30992(class_2893.class_2895.field_13176, SBPlacedFeatures.ORE_PEGMATITE_VOLCANIC);
		biomeSettings.method_30992(class_2893.class_2895.field_35182, SBPlacedFeatures.SPRING_LAVA_VOLCANIC);
		return biome(true, 2F, 0F, NONE, DEFAULT_WATER, DEFAULT_WATER_FOG, 8230780, null, null, mobSettings, biomeSettings, MUSIC_VOLCANIC);
	}

	public static class_1959 dustyCaverns(class_7871<class_6796> placedFeatures, class_7871<class_2922<?>> worldCarvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);
		mobSettings.method_31011(class_1311.field_6302, new class_5483.class_1964(class_1299.field_6071, 80, 4, 4));

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(placedFeatures, worldCarvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_38568(biomeSettings);
		class_3864.method_17010(biomeSettings);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, class_6819.field_36175);
		class_3864.method_16982(biomeSettings);
		class_3864.method_16984(biomeSettings);

		addModUndergroundVariety(biomeSettings);
		addModMushrooms(biomeSettings);
		return biome(false, 2F, 0F, mobSettings, biomeSettings, MUSIC_DRIPSTONE);
	}

	public static class_1959 fungalDepths(class_7871<class_6796> placedFeatures, class_7871<class_2922<?>> worldCarvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(placedFeatures, worldCarvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_38568(biomeSettings);
		class_3864.method_17010(biomeSettings);
		class_3864.method_16984(biomeSettings);

		biomeSettings.method_30992(class_2893.class_2895.field_13176, SBPlacedFeatures.ORE_EXOSKELETON_LUSH);
		biomeSettings.method_30992(class_2893.class_2895.field_13176, SBPlacedFeatures.ORE_PEGMATITE_UPPER);
		biomeSettings.method_30992(class_2893.class_2895.field_13176, SBPlacedFeatures.ORE_PEGMATITE_LOWER);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.STYPHIUM_PATCH);
		return biome(true, 1.2F, 0.4F, mobSettings, biomeSettings, MUSIC_LUSH);
	}

	public static class_1959 iceCaves(class_7871<class_6796> placedFeatures, class_7871<class_2922<?>> worldCarvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(placedFeatures, worldCarvers);
		biomeSettings.method_30991(class_2893.class_2894.field_13169, class_5463.field_33119);
		biomeSettings.method_30991(class_2893.class_2894.field_13169, class_5463.field_34968);
		biomeSettings.method_30991(class_2893.class_2894.field_13169, class_5463.field_33120);
		biomeSettings.method_30992(class_2893.class_2895.field_35182, class_6814.field_36017);
		class_3864.method_16999(biomeSettings);
		class_3864.method_16982(biomeSettings);
		class_3864.method_16984(biomeSettings);

		addModUndergroundVariety(biomeSettings);
		addIcicles(biomeSettings);
		addModMushrooms(biomeSettings);
		return biome(true, 0F, 0.2F, FROZEN, DEFAULT_WATER, DEFAULT_WATER_FOG, null, null, null, mobSettings, biomeSettings, MUSIC_DRIPSTONE);
	}

	public static class_1959 slimeCaverns(class_7871<class_6796> placedFeatures, class_7871<class_2922<?>> worldCarvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_3864.method_30581(mobSettings);
		mobSettings.method_31011(class_1311.field_6302, new class_5483.class_1964(class_1299.field_6069, 100, 4, 4));

		class_5485.class_5495 biomeSettings = new class_5485.class_5495(placedFeatures, worldCarvers);
		globalOverworldGeneration(biomeSettings);
		class_3864.method_38568(biomeSettings);
		class_3864.method_17010(biomeSettings);
		class_3864.method_16982(biomeSettings);
		class_3864.method_16984(biomeSettings);

		addModUndergroundVariety(biomeSettings);
		addModMushrooms(biomeSettings);
		return biome(true, 0.8F, 0.4F, mobSettings, biomeSettings, MUSIC_LUSH);
	}

	public static class_1959 theCrypt(class_7871<class_6796> features, class_7871<class_2922<?>> carvers) {
		class_5483.class_5496 mobSettings = new class_5483.class_5496();
		class_5485.class_5495 biomeSettings = new class_5485.class_5495(features, carvers);
		return biome(false, 0.5F, 0.5F, mobSettings, biomeSettings, null);
	}

	private static class_1959 biome(boolean precipitation, float temperature, float downfall, class_5483.class_5496 mobSettings, class_5485.class_5495 biomeSettings, class_5195 music) {
		return biome(precipitation, temperature, downfall, NONE, DEFAULT_WATER, DEFAULT_WATER_FOG, null, null, null, mobSettings, biomeSettings, music);
	}

	private static class_1959 biome(boolean precipitation, float temperature, float downfall, class_1959.class_5484 temperatureModifier, int waterColor, int waterFogColor, Integer grassOverride, Integer foliageOverride, class_4763.class_5486 grassModifier, class_5483.class_5496 mobSettings, class_5485.class_5495 biomeSettings, class_5195 music) {
		class_4763.class_4764 biomeEffects = new class_4763.class_4764().method_24395(waterColor).method_24397(waterFogColor).method_24392(DEFAULT_FOG).method_30820(calculateSkyColor(temperature)).method_24943(class_4968.field_23146).method_27346(music);
		if (grassOverride != null) biomeEffects.method_30822(grassOverride);
		if (foliageOverride != null) biomeEffects.method_30821(foliageOverride);
		if (grassModifier != null) biomeEffects.method_30818(grassModifier);
		return new class_1959.class_1960().method_48164(precipitation).method_8747(temperature).method_8727(downfall).method_30777(temperatureModifier).method_24379(biomeEffects.method_24391()).method_30974(mobSettings.method_31007()).method_30973(biomeSettings.method_46671()).method_30972();
	}

	private static void globalOverworldGeneration(class_5485.class_5495 biomeSettings) {
		class_3864.method_16983(biomeSettings);
		class_3864.method_32236(biomeSettings);
		class_3864.method_17004(biomeSettings);
		class_3864.method_17005(biomeSettings);
		class_3864.method_16996(biomeSettings);
		class_3864.method_16999(biomeSettings);
	}

	private static void addAntMounds(class_5485.class_5495 biomeSettings) {
		biomeSettings.method_30992(class_2893.class_2895.field_13171, SBPlacedFeatures.ANT_MOUND_MUD);
		biomeSettings.method_30992(class_2893.class_2895.field_13171, SBPlacedFeatures.ANT_MOUND_RUDOSOL);
	}

	private static void addIcicles(class_5485.class_5495 biomeSettings) {
		biomeSettings.method_30992(class_2893.class_2895.field_13177, SBPlacedFeatures.ICICLE_CLUSTER);
		biomeSettings.method_30992(class_2893.class_2895.field_13177, SBPlacedFeatures.ICICLE_LARGE);
		biomeSettings.method_30992(class_2893.class_2895.field_13177, SBPlacedFeatures.ICICLE_SMALL);
	}

	private static void addMudPits(class_5485.class_5495 biomeSettings) {
		biomeSettings.method_30992(class_2893.class_2895.field_13171, SBPlacedFeatures.MUD_PIT_SHALLOW);
		biomeSettings.method_30992(class_2893.class_2895.field_13171, SBPlacedFeatures.MUD_PIT_NORMAL);
		biomeSettings.method_30992(class_2893.class_2895.field_13171, SBPlacedFeatures.MUD_PIT_DEEP);
	}

	private static void addModUndergroundVariety(class_5485.class_5495 biomeSettings) {
		biomeSettings.method_30992(class_2893.class_2895.field_13176, SBPlacedFeatures.ORE_EXOSKELETON);
		biomeSettings.method_30992(class_2893.class_2895.field_13176, SBPlacedFeatures.ORE_PEGMATITE_UPPER);
		biomeSettings.method_30992(class_2893.class_2895.field_13176, SBPlacedFeatures.ORE_PEGMATITE_LOWER);
	}

	private static void addModMushrooms(class_5485.class_5495 biomeSettings) {
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.BLACK_MUSHROOM_RARE);
		biomeSettings.method_30992(class_2893.class_2895.field_13178, SBPlacedFeatures.WHITE_MUSHROOM_RARE);
	}

	static int calculateSkyColor(float temperature) {
		float f = temperature / 3.0F;
		f = class_3532.method_15363(f, -1.0F, 1.0F);
		return class_3532.method_15369(0.62F - f * 0.05F, 0.5F + f * 0.1F, 1.0F);
	}
}
