package net.invictusslayer.slayersbeasts.world.level.biome.region;

import com.mojang.datafixers.util.Pair;
import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.invictusslayer.slayersbeasts.world.level.biome.SBBiomes;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import terrablender.api.ParameterUtils.*;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.VanillaParameterOverlayBuilder;

import java.util.function.Consumer;

public class SBNetherRegion extends Region {
	public SBNetherRegion(int weight) {
		super(class_2960.method_60655(SlayersBeasts.MOD_ID, "nether"), RegionType.NETHER, weight);
	}

	public void addBiomes(class_2378<class_1959> registry, Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper) {
		VanillaParameterOverlayBuilder builder = new VanillaParameterOverlayBuilder();

		new ParameterPointListBuilder()
				.temperature(Temperature.WARM)
				.humidity(Humidity.HUMID)
				.continentalness(Continentalness.FULL_RANGE)
				.erosion(Erosion.FULL_RANGE)
				.weirdness(Weirdness.FULL_RANGE)
				.depth(Depth.FULL_RANGE)
				.build().forEach(point -> builder.add(point, SBBiomes.TOXIC_JUNGLE));

		builder.build().forEach(mapper);
	}
}
