package net.invictusslayer.slayersbeasts.world.level.block;

import com.mojang.serialization.MapCodec;
import net.invictusslayer.slayersbeasts.world.level.block.entity.AnthillBlockEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1528;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1687;
import net.minecraft.class_1701;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import net.minecraft.class_9275;
import net.minecraft.class_9334;
import net.invictusslayer.slayersbeasts.world.entity.AntSoldier;
import net.invictusslayer.slayersbeasts.registries.SBBlockEntities;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import java.util.List;

public class AnthillBlock extends class_2237 {
	public static final MapCodec<AnthillBlock> CODEC = method_54094(AnthillBlock::new);
	public static final class_2758 FUNGUS_LEVEL = class_2758.method_11867("fungus_level", 0, 5);
	public static final class_2758 SUPPLY_LEVEL = class_2758.method_11867("supply_level", 0, 10);

	public AnthillBlock(class_2251 properties) {
		super(properties);
		this.method_9590(this.field_10647.method_11664().method_11657(FUNGUS_LEVEL, 0).method_11657(SUPPLY_LEVEL, 0));
	}

	protected MapCodec<? extends class_2237> method_53969() {
		return field_46280;
	}

	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(FUNGUS_LEVEL, SUPPLY_LEVEL);
	}

	public class_2586 method_10123(class_2338 pos, class_2680 state) {
		return new AnthillBlockEntity(pos, state);
	}

	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		return method_31618(type, SBBlockEntities.ANTHILL.get(), AnthillBlockEntity::serverTick);
	}

	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11458;
	}

	public static void dropMushroom(class_1937 level, class_2338 pos) {
		method_9577(level, pos, new class_1799(SBBlocks.WHITE_MUSHROOM.get(), level.field_9229.method_43051(1, 4)));
	}

	public void angerNearbyAnts(class_1937 level, class_2338 pos) {
		List<AntSoldier> list = level.method_18467(AntSoldier.class, new class_238(pos).method_1009(8, 6, 8));
		if (!list.isEmpty()) {
			List<class_1657> players = level.method_18467(class_1657.class, new class_238(pos).method_1009(8, 6, 8));
			if (players.isEmpty()) return;
			int i = players.size();

			for (AntSoldier ant : list) {
				if (ant.method_5968() == null) {
					ant.method_5980(players.get(level.field_9229.method_43048(i)));
				}
			}
		}
	}

	public class_9062 method_55765(class_1799 handItem, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
		int i = state.method_11654(FUNGUS_LEVEL);
		boolean flag = false;
		if (i >= 5) {
			class_1792 item = handItem.method_7909();
//			if (handItem.canPerformAction(net.minecraftforge.common.ToolActions.SHEARS_HARVEST)) {
//				dropMushroom(level, pos);
//				handItem.hurtAndBreak(1, player, (onBroken) -> onBroken.broadcastBreakEvent(hand));
//				flag = true;
//				level.gameEvent(player, GameEvent.SHEAR, pos);
//			} else if (handItem.is(Items.DIRT)) {
//				handItem.shrink(1);
//				if (handItem.isEmpty()) {
//					player.setItemInHand(hand, new ItemStack(SBBlocks.ARIDISOL.get()));
//				} else if (!player.getInventory().add(new ItemStack(SBBlocks.ARIDISOL.get()))) {
//					player.drop(new ItemStack(SBBlocks.ARIDISOL.get()), false);
//				}
//
//				flag = true;
//				level.gameEvent(player, GameEvent.ENTITY_INTERACT, pos);
//			}

			if (!level.field_9236 && flag) {
				player.method_7259(class_3468.field_15372.method_14956(item));
			}
		}

		if (flag) {
			if (this.nestContainsAnts(level, pos)) {
				this.angerNearbyAnts(level, pos);
			}

			this.releaseAntsAndResetMushroomLevel(level, state, pos, player, AnthillBlockEntity.AntReleaseStatus.EMERGENCY);
			return class_9062.method_55644(level.field_9236);
		} else {
			return super.method_55765(handItem, state, level, pos, player, hand, result);
		}
	}

	private boolean nestContainsAnts(class_1937 level, class_2338 pos) {
		class_2586 blockEntity = level.method_8321(pos);
		if (blockEntity instanceof AnthillBlockEntity anthillBlockEntity) {
			return !anthillBlockEntity.isEmpty();
		} else {
			return false;
		}
	}

	public void releaseAntsAndResetMushroomLevel(class_1937 level, class_2680 state, class_2338 pos, class_1657 player, AnthillBlockEntity.AntReleaseStatus releaseStatus) {
		this.resetMushroomLevel(level, state, pos);
		class_2586 blockEntity = level.method_8321(pos);
		if (blockEntity instanceof AnthillBlockEntity anthillBlockEntity) {
			anthillBlockEntity.emptyAntsFromNest(player, state, releaseStatus);
		}
	}

	public void resetMushroomLevel(class_1937 level, class_2680 state, class_2338 pos) {
		level.method_8652(pos, state.method_11657(FUNGUS_LEVEL, 0), 3);
	}

	public void method_9556(class_1937 level, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity, class_1799 item) {
		super.method_9556(level, player, pos, state, blockEntity, item);
		if (!level.field_9236 && blockEntity instanceof AnthillBlockEntity anthillBlockEntity) {
			anthillBlockEntity.emptyAntsFromNest(player, state, AnthillBlockEntity.AntReleaseStatus.EMERGENCY);
			this.angerNearbyAnts(level, pos);
		}
	}

	public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
		if (!level.field_9236 && player.method_7337() && level.method_8450().method_8355(class_1928.field_19392)) {
			class_2586 blockEntity = level.method_8321(pos);
			if (blockEntity instanceof AnthillBlockEntity anthillBlockEntity) {
				int i = state.method_11654(FUNGUS_LEVEL);
				int j = state.method_11654(SUPPLY_LEVEL);
				boolean flag = !anthillBlockEntity.isEmpty();
				if (flag || i > 0 || j > 0) {
					class_1799 itemStack = new class_1799(this);
					itemStack.method_57365(anthillBlockEntity.method_57590());
					itemStack.method_57379(class_9334.field_49623, class_9275.field_49284.method_57420(FUNGUS_LEVEL, i).method_57420(SUPPLY_LEVEL, j));
					class_1542 itemEntity = new class_1542(level, pos.method_10263(), pos.method_10264(), pos.method_10260(), itemStack);
					itemEntity.method_6988();
					level.method_8649(itemEntity);
				}
			}
		}

		return super.method_9576(level, pos, state, player);
	}

	public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
		class_1297 entity = builder.method_51876(class_181.field_1226);
		if (entity instanceof class_1541 || entity instanceof class_1548 || entity instanceof class_1687 ||
				entity instanceof class_1528 || entity instanceof class_1701) {
			class_2586 blockEntity = builder.method_51876(class_181.field_1228);
			if (blockEntity instanceof AnthillBlockEntity anthillBlockEntity) {
				anthillBlockEntity.emptyAntsFromNest(null, state, AnthillBlockEntity.AntReleaseStatus.EMERGENCY);
			}
		}

		return super.method_9560(state, builder);
	}
}
