package net.invictusslayer.slayersbeasts.world.level.block;

import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.invictusslayer.slayersbeasts.registries.SBFeatures;
import net.invictusslayer.slayersbeasts.world.level.dimension.SBDimensions;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.SBStructures;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3449;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CryptPortalBlock extends class_2248 {
	private static final class_265 SHAPE = class_2248.method_9541(0.0D, 6.0D, 0.0D, 16.0D, 12.0D, 16.0D);

	public CryptPortalBlock(class_2251 properties) {
		super(properties);
	}

	public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
		return SHAPE;
	}

	public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
		List<class_2338> posList = List.of(currentPos.method_10095(), currentPos.method_10078(), currentPos.method_10072(), currentPos.method_10067());
		for (class_2338 pos : posList) {
			class_2248 block = level.method_8320(pos).method_26204();
			if (block != this && block != SBBlocks.INFUSED_CRYPTALITH.get() && block != SBBlocks.DEPLETED_CRYPTALITH.get()) {
				return class_2246.field_10124.method_9564();
			}
		}

		return super.method_9559(state, facing, facingState, level, currentPos, facingPos);
	}

	public class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state) {
		return class_1799.field_8037;
	}

	public boolean method_22358(class_2680 state, class_3611 fluid) {
		return false;
	}

	public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
		if (entity instanceof class_3222 player) {
			MinecraftServer server = level.method_8503();
			if (server == null) return;

			class_5321<class_1937> destination = player.method_37908().method_27983() == SBDimensions.CRYPT ? class_1937.field_25179 : SBDimensions.CRYPT;
			class_3218 serverLevel = server.method_3847(destination);
			if (serverLevel == null) return;
			if (!player.method_61113(level, serverLevel)) return;

			if (destination == SBDimensions.CRYPT) {
				if (serverLevel.method_18456().isEmpty()) resetCrypt(serverLevel);
				player.method_48105(serverLevel, 3.5, 61, 3, Set.of(), player.method_36454(), player.method_36455());
			} else {
				class_2338 spawn = player.method_26281() == destination ? player.method_26280() : level.method_43126();
				if (spawn == null) spawn = level.method_43126();
				player.method_48105(serverLevel, spawn.method_10263(), spawn.method_10264(), spawn.method_10260(), Set.of(), player.method_36454(), player.method_36455());
			}
		}
	}

	private void resetCrypt(class_3218 level) {
		class_2794 chunkGen = level.method_14178().method_12129();
		if (!SBFeatures.CRYPT_FOUNDATION.get().method_40163(new class_3111(), level, chunkGen, level.method_8409(), class_2338.field_10980)) return;

		class_3195 crypt = level.method_30349().method_30530(class_7924.field_41246).method_40264(SBStructures.CRYPT).orElseThrow().comp_349();
		class_3449 start = crypt.method_41614(level.method_30349(), chunkGen, chunkGen.method_12098(), level.method_14178().method_41248(), level.method_14183(), level.method_8409().method_43048(1000000000), new class_1923(0, 0), 0, level, biome -> true);
		if (!start.method_16657()) return;

		class_3341 boundingBox = start.method_14969();
		class_1923 chunkMin = new class_1923(class_4076.method_18675(boundingBox.method_35415()), class_4076.method_18675(boundingBox.method_35417()));
		class_1923 chunkMax = new class_1923(class_4076.method_18675(boundingBox.method_35418()), class_4076.method_18675(boundingBox.method_35420()));

		class_1923.method_19281(chunkMin, chunkMax).forEach(chunk -> start.method_14974(level, level.method_27056(), chunkGen, level.method_8409(), new class_3341(chunk.method_8326(), level.method_31607(), chunk.method_8328(), chunk.method_8327(), level.method_31600(), chunk.method_8329()), chunkMin));

		Collection<class_1297> entities = new ArrayList<>();
		level.method_27909().forEach(entity -> {
			if (entity instanceof class_1542) {
				entities.add(entity);
			}
		});
		for (class_1297 entity : entities) {
			entity.method_5768();
		}
	}

	public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
		double d0 = pos.method_10263() + random.method_43058();
		double d1 = pos.method_10264() + 0.8D;
		double d2 = pos.method_10260() + random.method_43058();
		level.method_8406(class_2398.field_23956, d0, d1, d2, 0.0D, 0.0D, 0.0D);
	}
}
