package net.invictusslayer.slayersbeasts.world.level.gen.feature;

import com.google.common.collect.ImmutableList;
import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_5321;
import net.minecraft.class_5450;
import net.minecraft.class_5843;
import net.minecraft.class_6019;
import net.minecraft.class_6343;
import net.minecraft.class_6728;
import net.minecraft.class_6732;
import net.minecraft.class_6792;
import net.minecraft.class_6793;
import net.minecraft.class_6795;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6799;
import net.minecraft.class_6806;
import net.minecraft.class_6817;
import net.minecraft.class_6819;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.minecraft.world.level.levelgen.placement.*;

import java.util.List;

public class SBPlacedFeatures {
	// Tree
	public static final class_5321<class_6796> ASPEN = createKey("aspen");
	public static final class_5321<class_6796> SUPER_ASPEN = createKey("super_aspen");
	public static final class_5321<class_6796> BLOODWOOD = createKey("bloodwood");
	public static final class_5321<class_6796> CAJOLE = createKey("cajole");
	public static final class_5321<class_6796> CYPRESS = createKey("cypress");
	public static final class_5321<class_6796> DESERT_OAK = createKey("desert_oak");
	public static final class_5321<class_6796> SUPER_DESERT_OAK = createKey("super_desert_oak");
	public static final class_5321<class_6796> EUCALYPTUS = createKey("eucalyptus");
	public static final class_5321<class_6796> GIANT_KAPOK = createKey("giant_kapok");
	public static final class_5321<class_6796> REDWOOD = createKey("redwood");
	public static final class_5321<class_6796> GIANT_REDWOOD = createKey("giant_redwood");
	public static final class_5321<class_6796> COLOSSAL_REDWOOD = createKey("colossal_redwood");
	public static final class_5321<class_6796> ALBINO_REDWOOD = createKey("albino_redwood");
	public static final class_5321<class_6796> GIANT_ALBINO_REDWOOD = createKey("giant_albino_redwood");
	public static final class_5321<class_6796> GIANT_WILLOW = createKey("giant_willow");

	// Vegetation
	public static final class_5321<class_6796> TREES_ASPEN = createKey("trees_aspen");
	public static final class_5321<class_6796> TREES_BAYOU = createKey("trees_bayou");
	public static final class_5321<class_6796> TREES_BRUSH = createKey("trees_brush");
	public static final class_5321<class_6796> TREES_WOODED_BRUSH = createKey("trees_wooded_brush");
	public static final class_5321<class_6796> TREES_CHAPARRAL = createKey("trees_chaparral");
	public static final class_5321<class_6796> TREES_EUCALYPT = createKey("trees_eucalypt");
	public static final class_5321<class_6796> TREES_INKY = createKey("trees_inky");
	public static final class_5321<class_6796> TREES_MUSHROOM = createKey("trees_mushroom");
	public static final class_5321<class_6796> TREES_OUTBACK = createKey("trees_outback");
	public static final class_5321<class_6796> TREES_RAINFOREST = createKey("trees_rainforest");
	public static final class_5321<class_6796> TREES_REDWOOD = createKey("trees_redwood");
	public static final class_5321<class_6796> TREES_OLD_GROWTH_REDWOOD = createKey("trees_old_growth_redwood");
	public static final class_5321<class_6796> TREES_RIVER = createKey("trees_river");
	public static final class_5321<class_6796> PATCH_ALGAE_COMMON = createKey("patch_algae_common");
	public static final class_5321<class_6796> PATCH_ALGAE_NORMAL = createKey("patch_algae_normal");
	public static final class_5321<class_6796> PATCH_TALL_DEAD_BUSH = createKey("patch_tall_dead_bush");
	public static final class_5321<class_6796> PATCH_TALL_DEAD_BUSH_BRUSH = createKey("patch_tall_dead_bush_brush");
	public static final class_5321<class_6796> BLACK_MUSHROOM_COMMON = createKey("black_mushroom_common");
	public static final class_5321<class_6796> BLACK_MUSHROOM_RARE = createKey("black_mushroom_rare");
	public static final class_5321<class_6796> WHITE_MUSHROOM_COMMON = createKey("white_mushroom_common");
	public static final class_5321<class_6796> WHITE_MUSHROOM_RARE = createKey("white_mushroom_rare");

	// Cave
	public static final class_5321<class_6796> ICICLE_CLUSTER = createKey("icicle_cluster");
	public static final class_5321<class_6796> ICICLE_LARGE = createKey("icicle_large");
	public static final class_5321<class_6796> ICICLE_SMALL = createKey("icicle_small");
	public static final class_5321<class_6796> STYPHIUM_PATCH = createKey("styphium_patch");

	// Ore
	public static final class_5321<class_6796> ORE_EXOSKELETON = createKey("ore_exoskeleton");
	public static final class_5321<class_6796> ORE_EXOSKELETON_LUSH = createKey("ore_exoskeleton_lush");
	public static final class_5321<class_6796> ORE_OBSIDIAN = createKey("ore_obsidian");
	public static final class_5321<class_6796> ORE_PEGMATITE_UPPER = createKey("ore_pegmatite_upper");
	public static final class_5321<class_6796> ORE_PEGMATITE_LOWER = createKey("ore_pegmatite_lower");
	public static final class_5321<class_6796> ORE_BASALT_VOLCANIC = createKey("ore_basalt_volcanic");
	public static final class_5321<class_6796> ORE_GRANITE_VOLCANIC = createKey("ore_granite_volcanic");
	public static final class_5321<class_6796> ORE_PEGMATITE_VOLCANIC = createKey("ore_pegmatite_volcanic");

	// Miscellaneous
	public static final class_5321<class_6796> ANT_MOUND_MUD = createKey("and_mound_mud");
	public static final class_5321<class_6796> ANT_MOUND_RUDOSOL = createKey("and_mound_rudosol");
	public static final class_5321<class_6796> MUD_PIT_SHALLOW = createKey("mud_pit_shallow");
	public static final class_5321<class_6796> MUD_PIT_NORMAL = createKey("mud_pit_normal");
	public static final class_5321<class_6796> MUD_PIT_DEEP = createKey("mud_pit_deep");
	public static final class_5321<class_6796> LAKE_LAVA_VOLCANIC = createKey("lake_lava_volcanic");
	public static final class_5321<class_6796> SPRING_LAVA_VOLCANIC = createKey("spring_lava_volcanic");

	public static void bootstrap(class_7891<class_6796> context) {
		class_7871<class_2975<?, ?>> configured = context.method_46799(class_7924.field_41239);

		register(context, ASPEN, configured.method_46747(SBConfiguredFeatures.ASPEN), class_6817.method_40365(SBBlocks.ASPEN_SAPLING.get()));
		register(context, SUPER_ASPEN, configured.method_46747(SBConfiguredFeatures.SUPER_ASPEN), class_6817.method_40365(SBBlocks.ASPEN_SAPLING.get()));
		register(context, BLOODWOOD, configured.method_46747(SBConfiguredFeatures.BLOODWOOD), class_6817.method_40365(SBBlocks.BLOODWOOD_SAPLING.get()));
		register(context, CAJOLE, configured.method_46747(SBConfiguredFeatures.CAJOLE), class_6817.method_40365(SBBlocks.CAJOLE_SAPLING.get()));
		register(context, CYPRESS, configured.method_46747(SBConfiguredFeatures.CYPRESS), class_6817.method_40365(SBBlocks.CYPRESS_SAPLING.get()));
		register(context, DESERT_OAK, configured.method_46747(SBConfiguredFeatures.DESERT_OAK), class_6817.method_40365(SBBlocks.DESERT_OAK_SAPLING.get()));
		register(context, SUPER_DESERT_OAK, configured.method_46747(SBConfiguredFeatures.SUPER_DESERT_OAK), class_6817.method_40365(SBBlocks.DESERT_OAK_SAPLING.get()));
		register(context, EUCALYPTUS, configured.method_46747(SBConfiguredFeatures.EUCALYPTUS), class_6817.method_40365(SBBlocks.EUCALYPTUS_SAPLING.get()));
		register(context, GIANT_KAPOK, configured.method_46747(SBConfiguredFeatures.GIANT_KAPOK), class_6817.method_40365(SBBlocks.KAPOK_SAPLING.get()));
		register(context, REDWOOD, configured.method_46747(SBConfiguredFeatures.REDWOOD), class_6817.method_40365(SBBlocks.REDWOOD_SAPLING.get()));
		register(context, GIANT_REDWOOD, configured.method_46747(SBConfiguredFeatures.GIANT_REDWOOD), class_6817.method_40365(SBBlocks.REDWOOD_SAPLING.get()));
		register(context, COLOSSAL_REDWOOD, configured.method_46747(SBConfiguredFeatures.COLOSSAL_REDWOOD), class_6817.method_40365(SBBlocks.REDWOOD_SAPLING.get()));
		register(context, ALBINO_REDWOOD, configured.method_46747(SBConfiguredFeatures.ALBINO_REDWOOD), class_6817.method_40365(SBBlocks.ALBINO_REDWOOD_SAPLING.get()));
		register(context, GIANT_ALBINO_REDWOOD, configured.method_46747(SBConfiguredFeatures.GIANT_ALBINO_REDWOOD), class_6817.method_40365(SBBlocks.ALBINO_REDWOOD_SAPLING.get()));
		register(context, GIANT_WILLOW, configured.method_46747(SBConfiguredFeatures.GIANT_WILLOW), class_6817.method_40365(SBBlocks.WILLOW_SAPLING.get()));

		register(context, TREES_ASPEN, configured.method_46747(SBConfiguredFeatures.TREES_ASPEN), class_6819.method_39741(class_6817.method_39736(10, 0.2F, 3), SBBlocks.ASPEN_SAPLING.get()));
		register(context, TREES_BAYOU, configured.method_46747(SBConfiguredFeatures.TREES_BAYOU), class_6819.method_39740(class_6817.method_39736(10, 0.2F, 2)));
		register(context, TREES_BRUSH, configured.method_46747(SBConfiguredFeatures.TREES_BRUSH), class_6819.method_39741(class_6817.method_39736(1, 0.1F, 1), SBBlocks.DESERT_OAK_SAPLING.get()));
		register(context, TREES_WOODED_BRUSH, configured.method_46747(SBConfiguredFeatures.TREES_BRUSH), class_6819.method_39741(class_6817.method_39736(10, 0.2F, 3), SBBlocks.DESERT_OAK_SAPLING.get()));
		register(context, TREES_CHAPARRAL, configured.method_46747(SBConfiguredFeatures.TREES_CHAPARRAL), class_6819.method_39741(class_6817.method_39736(1, 0.1F, 1), SBBlocks.DESERT_OAK_SAPLING.get()));
		register(context, TREES_EUCALYPT, configured.method_46747(SBConfiguredFeatures.TREES_EUCALYPT), class_6819.method_39741(class_6817.method_39736(6, 0.1F, 1), SBBlocks.EUCALYPTUS_SAPLING.get()));
		register(context, TREES_INKY, configured.method_46747(SBConfiguredFeatures.TREES_INKY), class_6819.method_39740(class_6817.method_39736(3, 0.1F, 1)));
		register(context, TREES_MUSHROOM, configured.method_46747(SBConfiguredFeatures.TREES_MUSHROOM), class_6793.method_39623(16), class_5450.method_39639(), class_6817.field_36078, class_6792.method_39614());
		register(context, TREES_OUTBACK, configured.method_46747(SBConfiguredFeatures.TREES_OUTBACK), class_6819.method_39741(class_6817.method_39736(1, 0.1F, 1), SBBlocks.EUCALYPTUS_SAPLING.get()));
		register(context, TREES_RAINFOREST, configured.method_46747(SBConfiguredFeatures.TREES_RAINFOREST), class_6819.method_39740(class_6817.method_39736(10, 0.1F, 1)));
		register(context, TREES_REDWOOD, configured.method_46747(SBConfiguredFeatures.TREES_REDWOOD), class_6819.method_39741(class_6817.method_39736(10, 0.1F, 1), SBBlocks.REDWOOD_SAPLING.get()));
		register(context, TREES_OLD_GROWTH_REDWOOD, configured.method_46747(SBConfiguredFeatures.TREES_OLD_GROWTH_REDWOOD), class_6819.method_39741(class_6817.method_39736(10, 0.1F, 1), SBBlocks.REDWOOD_SAPLING.get()));
		register(context, TREES_RIVER, configured.method_46747(SBConfiguredFeatures.TREES_RIVER), class_6819.method_39741(class_6817.method_39736(0, 0.05F, 1), SBBlocks.WILLOW_SAPLING.get()));
		register(context, PATCH_ALGAE_COMMON, configured.method_46747(SBConfiguredFeatures.PATCH_ALGAE), class_6819.method_39738(5));
		register(context, PATCH_ALGAE_NORMAL, configured.method_46747(SBConfiguredFeatures.PATCH_ALGAE), class_6819.method_39738(1));
		register(context, PATCH_TALL_DEAD_BUSH, configured.method_46747(SBConfiguredFeatures.PATCH_TALL_DEAD_BUSH), class_5450.method_39639(), class_6817.field_36080, class_6792.method_39614());
		register(context, PATCH_TALL_DEAD_BUSH_BRUSH, configured.method_46747(SBConfiguredFeatures.PATCH_TALL_DEAD_BUSH), class_6819.method_39738(20));
		register(context, BLACK_MUSHROOM_COMMON, configured.method_46747(SBConfiguredFeatures.PATCH_BLACK_MUSHROOM), mushroomPlacement(9, class_6793.method_39623(3)));
		register(context, BLACK_MUSHROOM_RARE, configured.method_46747(SBConfiguredFeatures.PATCH_BLACK_MUSHROOM), mushroomPlacement(256, null));
		register(context, WHITE_MUSHROOM_COMMON, configured.method_46747(SBConfiguredFeatures.PATCH_WHITE_MUSHROOM), mushroomPlacement(9, class_6793.method_39623(3)));
		register(context, WHITE_MUSHROOM_RARE, configured.method_46747(SBConfiguredFeatures.PATCH_WHITE_MUSHROOM), mushroomPlacement(256, null));

		register(context, ICICLE_CLUSTER, configured.method_46747(SBConfiguredFeatures.ICICLE_CLUSTER), class_6793.method_39624(class_6019.method_35017(48, 96)), class_5450.method_39639(), class_6817.field_36086, class_6792.method_39614());
		register(context, ICICLE_LARGE, configured.method_46747(SBConfiguredFeatures.ICICLE_LARGE), class_6793.method_39624(class_6019.method_35017(10, 48)), class_5450.method_39639(), class_6817.field_36086, class_6792.method_39614());
		register(context, ICICLE_SMALL, configured.method_46747(SBConfiguredFeatures.ICICLE_SMALL), class_6793.method_39624(class_6019.method_35017(192, 256)), class_5450.method_39639(), class_6817.field_36086, class_6793.method_39624(class_6019.method_35017(1, 5)), class_6732.method_39657(class_6728.method_39156(0.0F, 3.0F, -10, 10), class_6728.method_39156(0.0F, 0.6F, -2, 2)), class_6792.method_39614());
		register(context, STYPHIUM_PATCH, configured.method_46747(SBConfiguredFeatures.STYPHIUM_PATCH), class_6793.method_39623(256), class_5450.method_39639(), class_6817.field_36086, class_6792.method_39614());

		register(context, ORE_EXOSKELETON, configured.method_46747(SBConfiguredFeatures.ORE_EXOSKELETON), rareOrePlacement(1, class_6795.method_39637(class_5843.method_33846(-80), class_5843.method_33846(80))));
		register(context, ORE_EXOSKELETON_LUSH, configured.method_46747(SBConfiguredFeatures.ORE_EXOSKELETON), commonOrePlacement(10, class_6795.method_39634(class_5843.method_33840(), class_5843.method_33841(64))));
		register(context, ORE_OBSIDIAN, configured.method_46747(SBConfiguredFeatures.ORE_OBSIDIAN), commonOrePlacement(10, class_6795.method_39634(class_5843.method_33841(0), class_5843.method_33841(160))));
		register(context, ORE_PEGMATITE_UPPER, configured.method_46747(SBConfiguredFeatures.ORE_PEGMATITE), rareOrePlacement(12, class_6795.method_39634(class_5843.method_33841(64), class_5843.method_33841(128))));
		register(context, ORE_PEGMATITE_LOWER, configured.method_46747(SBConfiguredFeatures.ORE_PEGMATITE), commonOrePlacement(1, class_6795.method_39634(class_5843.method_33841(0), class_5843.method_33841(60))));
		register(context, ORE_BASALT_VOLCANIC, configured.method_46747(SBConfiguredFeatures.ORE_BASALT), commonOrePlacement(4, class_6795.method_39634(class_5843.method_33841(0), class_5843.method_33841(160))));
		register(context, ORE_GRANITE_VOLCANIC, configured.method_46747(class_6806.field_35876), commonOrePlacement(4, class_6795.method_39634(class_5843.method_33841(0), class_5843.method_33841(160))));
		register(context, ORE_PEGMATITE_VOLCANIC, configured.method_46747(SBConfiguredFeatures.ORE_PEGMATITE), commonOrePlacement(4, class_6795.method_39634(class_5843.method_33841(0), class_5843.method_33841(160))));

		register(context, ANT_MOUND_MUD, configured.method_46747(SBConfiguredFeatures.ANT_MOUND_MUD), class_6799.method_39659(6), class_5450.method_39639(), class_6817.field_36080, class_6792.method_39614());
		register(context, ANT_MOUND_RUDOSOL, configured.method_46747(SBConfiguredFeatures.ANT_MOUND_RUDOSOL), class_6799.method_39659(6), class_5450.method_39639(), class_6817.field_36080, class_6792.method_39614());
		register(context, MUD_PIT_SHALLOW, configured.method_46747(SBConfiguredFeatures.MUD_PIT_SHALLOW), class_6799.method_39659(4), class_5450.method_39639(), class_6817.field_36080, class_6792.method_39614());
		register(context, MUD_PIT_NORMAL, configured.method_46747(SBConfiguredFeatures.MUD_PIT_NORMAL), class_6799.method_39659(6), class_5450.method_39639(), class_6817.field_36080, class_6792.method_39614());
		register(context, MUD_PIT_DEEP, configured.method_46747(SBConfiguredFeatures.MUD_PIT_DEEP), class_6799.method_39659(9), class_5450.method_39639(), class_6817.field_36080, class_6792.method_39614());
		register(context, LAKE_LAVA_VOLCANIC, configured.method_46747(SBConfiguredFeatures.LAKE_LAVA_VOLCANIC), class_6799.method_39659(2), class_5450.method_39639(), class_6817.field_36080, class_6792.method_39614());
		register(context, SPRING_LAVA_VOLCANIC, configured.method_46747(SBConfiguredFeatures.SPRING_LAVA_VOLCANIC), class_6793.method_39623(20), class_5450.method_39639(), class_6795.method_39635(class_6343.method_36313(class_5843.method_33840(), class_5843.method_33849(8), 8)), class_6792.method_39614());
	}

	private static List<class_6797> mushroomPlacement(int rarity, class_6797 modifier) {
		ImmutableList.Builder<class_6797> builder = ImmutableList.builder();
		if (modifier != null) builder.add(modifier);
		if (rarity != 0) builder.add(class_6799.method_39659(rarity));

		builder.add(class_5450.method_39639(), class_6817.field_36078, class_6792.method_39614());
		return builder.build();
	}

	private static List<class_6797> orePlacement(class_6797 rarity, class_6797 modifier) {
		return List.of(rarity, class_5450.method_39639(), modifier, class_6792.method_39614());
	}

	private static List<class_6797> commonOrePlacement(int veinsPerChunk, class_6797 modifier) {
		return orePlacement(class_6793.method_39623(veinsPerChunk), modifier);
	}

	private static List<class_6797> rareOrePlacement(int chunksPerVein, class_6797 modifier) {
		return orePlacement(class_6799.method_39659(chunksPerVein), modifier);
	}

	private static class_5321<class_6796> createKey(String name) {
		return class_5321.method_29179(class_7924.field_41245, class_2960.method_60655(SlayersBeasts.MOD_ID, name));
	}

	private static void register(class_7891<class_6796> context, class_5321<class_6796> key, class_6880<class_2975<?, ?>> config, class_6797... modifiers) {
		register(context, key, config, List.of(modifiers));
	}

	private static void register(class_7891<class_6796> context, class_5321<class_6796> key, class_6880<class_2975<?, ?>> config, List<class_6797> modifiers) {
		context.method_46838(key, new class_6796(config, modifiers));
	}
}
