package net.invictusslayer.slayersbeasts.world.level.gen.feature.misc;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6017;

public class AntMoundFeature extends class_3031<AntMoundFeature.Configuration> {
	public AntMoundFeature(Codec<Configuration> codec) {
		super(codec);
	}

	public boolean method_13151(class_5821<Configuration> context) {
		class_5281 level = context.method_33652();
		class_2338 origin = context.method_33655();
		class_5819 random = context.method_33654();
		Configuration config = context.method_33656();

		class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
		class_2680 mound = config.mound.method_23455(random, origin);
		class_2680 anthill = config.anthill.method_23455(random, origin);
		int radius = config.radius.method_35008(random);
		int height = config.height.method_35008(random);
		int r2 = radius * radius;
		int h2 = height * height;

		for (int y = -height; y <= height; y++) {
			int y2 = y * y;
			for (int x = -radius; x <= radius; x++) {
				int x2 = x * x;
				for (int z = -radius; z <= radius; z++) {
					int z2 = z * z;
					if (x2 + z2 + (y2 * r2 / h2) > r2) continue;
					mutableBlockPos.method_25504(origin, x, y, z);

					if (level.method_8320(mutableBlockPos).method_26215()) {
						level.method_8652(mutableBlockPos, mound, 4);
					}
				}
			}
		}

		return false;
	}

	public record Configuration(class_4651 mound, class_4651 anthill, class_6017 radius, class_6017 height) implements class_3037 {
		public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group(
				class_4651.field_24937.fieldOf("mound").forGetter(Configuration::mound),
				class_4651.field_24937.fieldOf("anthill").forGetter(Configuration::anthill),
				class_6017.field_29946.fieldOf("radius").forGetter(Configuration::radius),
				class_6017.field_29946.fieldOf("height").forGetter(Configuration::height)
		).apply(instance, Configuration::new));
	}
}
