package net.invictusslayer.slayersbeasts.world.level.gen.feature.misc;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.invictusslayer.slayersbeasts.registries.SBBlocks;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3481;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6017;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class StyphiumPatchFeature extends class_3031<StyphiumPatchFeature.Configuration> {
	public StyphiumPatchFeature(Codec<Configuration> pCodec) {
		super(pCodec);
	}

	public boolean method_13151(class_5821<Configuration> context) {
		class_5281 level = context.method_33652();
		Configuration config = context.method_33656();
		class_5819 random = context.method_33654();
		class_2338 origin = context.method_33655();

		Predicate<class_2680> stateCheck = state -> state.method_26164(SBTags.Blocks.STYPHIUM_REPLACEABLE);

		Set<class_2338> set = placeGround(level, config, random, origin, stateCheck);
		placeVegetation(context, level, config, random, set);
		return !set.isEmpty();
	}

	private Set<class_2338> placeGround(class_5281 level, Configuration config, class_5819 random, class_2338 pos, Predicate<class_2680> stoneTest) {
		class_2338.class_2339 mutableBlockPos = pos.method_25503();
		Set<class_2338> set = new HashSet<>();
		int xRad = config.xzRadius.method_35008(random) + 1;
		int zRad = config.xzRadius.method_35008(random) + 1;

		for (int x = -xRad; x <= xRad; ++x) {
			boolean xEdge = x == -xRad || x == xRad;

			for (int z = -zRad; z <= zRad; ++z) {
				boolean zEdge = z == -zRad || z == zRad;

				if (!(xEdge && zEdge) && (!(xEdge || zEdge) || config.edgeColumnChance != 0.0F && random.method_43057() < config.edgeColumnChance)) {
					mutableBlockPos.method_25504(pos, x, 0, z);

					for (int y = 0; y < config.verticalRange; ++y) {
						if (level.method_16358(mutableBlockPos, class_4970.class_4971::method_26215)) {
							mutableBlockPos.method_10098(class_2350.field_11033);
						} else if (level.method_16358(mutableBlockPos, stoneTest)) {
							mutableBlockPos.method_10098(class_2350.field_11036);
							break;
						}
					}

					class_2338.class_2339 mutableBlockPos1 = mutableBlockPos.method_34592(0, -1, 0).method_25503();
					if (level.method_22347(mutableBlockPos) && level.method_8320(mutableBlockPos1).method_26206(level, mutableBlockPos1, class_2350.field_11036)) {
						if (placeStyphium(level, config, mutableBlockPos1)) {
							set.add(mutableBlockPos1.method_10062());
						}
					}
				}
			}
		}

		return set;
	}

	private boolean placeStyphium(class_5281 level, Configuration config, class_2338.class_2339 mutableBlockPos) {
		class_2680 state = level.method_8320(mutableBlockPos);

		if (state.method_27852(class_2246.field_10340)) {
			level.method_8652(mutableBlockPos, SBBlocks.STYPHIUM.get().method_9564(), 2);
		} else if (state.method_27852(class_2246.field_28888)) {
			level.method_8652(mutableBlockPos, SBBlocks.DEEPSLATE_STYPHIUM.get().method_9564(), 2);
		} else if (state.method_26164(SBTags.Blocks.STYPHIUM_REPLACEABLE) && config.isNatural) {
			level.method_8652(mutableBlockPos, state.method_26164(class_3481.field_25806) ? SBBlocks.STYPHIUM.get().method_9564() : class_2246.field_10402.method_9564(), 2);
		} else {
			return false;
		}

		return true;
	}

	private void placeVegetation(class_5821<Configuration> context, class_5281 level, Configuration config, class_5819 random, Set<class_2338> posList) {
		for (class_2338 pos : posList) {
			if (config.vegetationChance > 0.0F && random.method_43057() < config.vegetationChance) {
				placeVegetation(level, config, context.method_33653(), random, pos);
			}
		}
	}

	private void placeVegetation(class_5281 level, Configuration config, class_2794 chunkGen, class_5819 random, class_2338 pos) {
		config.vegetation.comp_349().method_39644(level, chunkGen, random, pos.method_10084());
	}

	public record Configuration(class_6880<class_6796> vegetation, float vegetationChance, int verticalRange, class_6017 xzRadius, float edgeColumnChance, boolean isNatural) implements class_3037 {
		public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance ->
				instance.group(class_6796.field_35730.fieldOf("vegetation").forGetter(Configuration::vegetation),
						Codec.floatRange(0.0F, 1.0F).fieldOf("vegetation_chance").forGetter(Configuration::vegetationChance),
						Codec.intRange(1, 256).fieldOf("vertical_range").forGetter(Configuration::verticalRange),
						class_6017.field_29946.fieldOf("xz_radius").forGetter(Configuration::xzRadius),
						Codec.floatRange(0.0F, 1.0F).fieldOf("edge_column_chance").forGetter(Configuration::edgeColumnChance),
						Codec.BOOL.fieldOf("isNatural").forGetter(Configuration::isNatural)
				).apply(instance, Configuration::new));
	}
}
