package net.invictusslayer.slayersbeasts.world.level.gen.feature.mushroom;

import com.mojang.serialization.Codec;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2381;
import net.minecraft.class_2680;
import net.minecraft.class_4625;
import net.minecraft.class_4635;
import net.minecraft.class_5819;

public class HugeBlackMushroomFeature extends class_4625 {
	public HugeBlackMushroomFeature(Codec<class_4635> codec) {
		super(codec);
	}

	protected void method_23375(class_1936 level, class_5819 random, class_2338 pos, int height, class_2338.class_2339 mutableBlockPos, class_4635 config) {
		for (int y = height - 6; y <= height; ++y) {
			int stage = height - y;
			int radius = stage < 2 ? 1 : 3;

			for (int x = -radius; x <= radius; ++x) {
				for (int z = -radius; z <= radius; ++z) {
					if (isBlock(x, z, stage, random)) {
						mutableBlockPos.method_25504(pos, x, y, z);
						if (!level.method_8320(mutableBlockPos).method_26216(level, mutableBlockPos)) {
							boolean north = z <= 0;
							boolean south = z >= 0;
							boolean east = x >= 0;
							boolean west = x <= 0;

							class_2680 state = config.field_21230.method_23455(random, pos).method_11657(class_2381.field_11169, false).method_11657(class_2381.field_11167, west).method_11657(class_2381.field_11172, east).method_11657(class_2381.field_11171, north).method_11657(class_2381.field_11170, south);
							method_13153(level, mutableBlockPos, state);
						}
					}
				}
			}
		}
	}

	private static boolean isBlock(int x, int z, int stage, class_5819 random) {
		int xRad = Math.abs(x);
		int zRad = Math.abs(z);
		int sum = xRad + zRad;

		if (stage == 0) return sum < 2;
		if (stage == 1 || stage == 2) return xRad < 2 && zRad < 2;
		if (stage == 3 || (stage == 4 && random.method_43048(4) == 0)) return (xRad == 2) != (zRad == 2) && sum < 4;

		return false;
	}

	protected int method_23377(class_5819 random) {
		int i = random.method_43048(3) + 6;
		if (random.method_43048(12) == 0) i += 6;

		return i;
	}

	protected int method_23372(int i, int height, int radius, int y) {
		if (y <= height && y >= height - 5) return radius;
		return 0;
	}
}
