package net.invictusslayer.slayersbeasts.world.level.gen.feature.mushroom;

import com.mojang.serialization.Codec;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2381;
import net.minecraft.class_2680;
import net.minecraft.class_4625;
import net.minecraft.class_4635;
import net.minecraft.class_5819;

public class HugeWhiteMushroomFeature extends class_4625 {
	public HugeWhiteMushroomFeature(Codec<class_4635> codec) {
		super(codec);
	}

	protected void method_23376(class_1936 level, class_5819 random, class_2338 pos, class_4635 config, int maxHeight, class_2338.class_2339 mutableBlockPos) {
		for (int i = 0; i < maxHeight - 1; ++i) {
			mutableBlockPos.method_10101(pos).method_10104(class_2350.field_11036, i);
			if (!level.method_8320(mutableBlockPos).method_26216(level, mutableBlockPos)) {
				method_13153(level, mutableBlockPos, config.field_21231.method_23455(random, pos).method_11657(class_2381.field_11166, false).method_11657(class_2381.field_11169, false));
			}
		}
	}

	protected void method_23375(class_1936 level, class_5819 random, class_2338 origin, int height, class_2338.class_2339 mutableBlockPos, class_4635 config) {
		class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);

		for (int y = height - 5; y <= height; ++y) {
			int stage = height - y;
			int radius = stage == 5 ? 2 : 1;

			for (int x = -radius; x <= radius; ++x) {
				for (int z = -radius; z <= radius; ++z) {
					if (isBlock(x, z, stage)) {
						mutableBlockPos.method_25504(origin, x, y, z);
						if (!level.method_8320(mutableBlockPos).method_26216(level, mutableBlockPos)) {
							boolean north = z <= 0;
							boolean south = z >= 0;
							boolean east = x >= 0;
							boolean west = x <= 0;

							class_2680 state = config.field_21230.method_23455(random, origin).method_11657(class_2381.field_11169, false).method_11657(class_2381.field_11167, west).method_11657(class_2381.field_11172, east).method_11657(class_2381.field_11171, north).method_11657(class_2381.field_11170, south);
							method_13153(level, mutableBlockPos, state);
						}
					}
				}
			}

			if (stage == 0) {
				mutableBlockPos.method_25504(origin, 0, y, 0).method_10098(direction);
				if (!level.method_8320(mutableBlockPos).method_26216(level, mutableBlockPos)) {
					class_2680 state = config.field_21230.method_23455(random, origin);
					method_13153(level, mutableBlockPos, state);
				}
			}
		}
	}

	private static boolean isBlock(int x, int z, int stage) {
		int xRad = Math.abs(x);
		int zRad = Math.abs(z);
		int sum = xRad + zRad;

		if (stage == 1) return sum == 0;
		if (stage == 2 || stage == 3) return sum < 2;
		if (stage == 4) return xRad < 2 && zRad < 2;
		if (stage == 5) return  (xRad == 2) != (zRad == 2) && sum < 4;

		return false;
	}

	protected int method_23377(class_5819 random) {
		int i = random.method_43048(3) + 7;
		if (random.method_43048(12) == 0) i += 6;

		return i;
	}

	protected int method_23372(int j, int height, int radius, int y) {
		if (y <= height && y >= height - 5) return radius;
		return 0;
	}
}
