package net.invictusslayer.slayersbeasts.world.level.gen.feature.mushroom;

import com.mojang.serialization.Codec;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2381;
import net.minecraft.class_2680;
import net.minecraft.class_4635;
import net.minecraft.class_5819;

public class MightyBrownMushroomFeature extends AbstractMightyMushroomFeature {
	public MightyBrownMushroomFeature(Codec<class_4635> codec) {
		super(codec);
	}

	protected void placeCap(class_1936 level, class_5819 random, class_2338 pos, class_4635 config, int height, class_2338.class_2339 mutableBlockPos) {
		for (int y = height - 2; y <= height; ++y) {
			int stage = height - y;
			int radius = stage == 1 ? 4 : 3;

			for (int x = -radius; x <= radius + 1; ++x) {
				for (int z = -radius; z <= radius + 1; ++z) {
					if (isBlock(x, z, stage)) {
						mutableBlockPos.method_25504(pos, x, y, z);
						if (!level.method_8320(mutableBlockPos).method_26216(level, mutableBlockPos)) {
							boolean flag = stage < 2;
							boolean north = flag && z <= 0;
							boolean south = flag && z >= 0;
							boolean east = flag && x >= 0;
							boolean west = flag && x <= 0;

							class_2680 state = config.field_21230.method_23455(random, pos).method_11657(class_2381.field_11169, false).method_11657(class_2381.field_11167, west).method_11657(class_2381.field_11172, east).method_11657(class_2381.field_11171, north).method_11657(class_2381.field_11170, south);
							method_13153(level, mutableBlockPos, state);
						}
					}
				}
			}
		}
	}

	private static boolean isBlock(int x, int z, int stage) {
		int xRad = Math.min(Math.abs(x), Math.abs(x - 1));
		int zRad = Math.min(Math.abs(z), Math.abs(z - 1));
		int sum = xRad + zRad;

		if (stage == 0) return sum < 4 || (xRad == 2 && zRad == 2);
		if (stage == 1) return sum < 5 || xRad * zRad == 6;
		if (stage == 2) return sum < 3;

		return false;
	}

	protected int getTreeRadiusForHeight(int radius, int height) {
		return height < 3 ? radius : 0;
	}
}
