package net.invictusslayer.slayersbeasts.world.level.gen.feature.mushroom;

import com.mojang.serialization.Codec;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2381;
import net.minecraft.class_2680;
import net.minecraft.class_4635;
import net.minecraft.class_5819;

public class MightyRedMushroomFeature extends AbstractMightyMushroomFeature {
	public MightyRedMushroomFeature(Codec<class_4635> codec) {
		super(codec);
	}

	protected void placeCap(class_1936 level, class_5819 random, class_2338 origin, class_4635 config, int height, class_2338.class_2339 mutableBlockPos) {
		for (int y = height - 6; y <= height; ++y) {
			int stage = height - y;
			int radius = stage < 2 ? 2 : 3;

			for (int x = -radius; x <= radius + 1; ++x) {
				for (int z = -radius; z <= radius + 1; ++z) {
					if (isBlock(x, z, stage)) {
						mutableBlockPos.method_25504(origin, x, y, z);
						if (!level.method_8320(mutableBlockPos).method_26216(level, mutableBlockPos)) {
							boolean north = z <= 0;
							boolean south = z >= 0;
							boolean east = x >= 0;
							boolean west = x <= 0;

							class_2680 state = config.field_21230.method_23455(random, origin).method_11657(class_2381.field_11169, stage > 4).method_11657(class_2381.field_11167, west).method_11657(class_2381.field_11172, east).method_11657(class_2381.field_11171, north).method_11657(class_2381.field_11170, south);
							method_13153(level, mutableBlockPos, state);
						}
					}
				}
			}
		}
	}

	private static boolean isBlock(int x, int z, int stage) {
		int xRad = Math.min(Math.abs(x), Math.abs(x - 1));
		int zRad = Math.min(Math.abs(z), Math.abs(z - 1));
		int sum = xRad + zRad;

		if (stage == 0) return sum < 3;
		if (stage == 1) return sum < 4;
		if (stage == 2) return sum == 3;
		if (stage == 3) return sum == 3 || (xRad == 2 && zRad == 2);
		if (stage == 4 || stage == 5) return sum == 4 || (sum == 3 && xRad * zRad == 0);
		if (stage == 6) return sum == 3 && xRad * zRad == 0;

		return false;
	}

	protected int getTreeRadiusForHeight(int radius, int height) {
		return height < 7 ? radius : 0;
	}
}
