package net.invictusslayer.slayersbeasts.world.level.gen.feature.mushroom;

import com.mojang.serialization.Codec;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2381;
import net.minecraft.class_2680;
import net.minecraft.class_4635;
import net.minecraft.class_5819;

public class MightyWhiteMushroomFeature extends AbstractMightyMushroomFeature {
	public MightyWhiteMushroomFeature(Codec<class_4635> codec) {
		super(codec);
	}

	protected void placeCap(class_1936 level, class_5819 random, class_2338 origin, class_4635 config, int height, class_2338.class_2339 mutableBlockPos) {
		int i = random.method_43048(4);
		int x1 = i < 2 ? 0 : 1;
		int x2 = i < 2 ? -1 : 2;
		int z1 = i % 2 == 0 ? 0 : 1;
		int z2 = i % 2 == 0 ? -1 : 2;

		for (int y = height - 8; y <= height; ++y) {
			int stage = height - y;
			int radius = stage < 6 ? 1 : 3;

			for (int x = -radius; x <= radius + 1; ++x) {
				for (int z = -radius; z <= radius + 1; ++z) {
					if (isBlock(x, z, stage)) {
						mutableBlockPos.method_25504(origin, x, y, z);
						if (!level.method_8320(mutableBlockPos).method_26216(level, mutableBlockPos)) {
							boolean north = z <= 0;
							boolean south = z >= 0;
							boolean east = x >= 0;
							boolean west = x <= 0;

							class_2680 state = config.field_21230.method_23455(random, origin).method_11657(class_2381.field_11169, false).method_11657(class_2381.field_11167, west).method_11657(class_2381.field_11172, east).method_11657(class_2381.field_11171, north).method_11657(class_2381.field_11170, south);
							method_13153(level, mutableBlockPos, state);
						}
					}
				}
			}

			if (stage == 0) {
				class_2680 state = config.field_21230.method_23455(random, origin);
				setBlockIfEmpty(level, mutableBlockPos.method_25504(origin, x2, y, z2), state);
			}
			if (stage == 1) {
				class_2680 state = config.field_21230.method_23455(random, origin);
				setBlockIfEmpty(level, mutableBlockPos.method_25504(origin, x1, y, z1), state);
				setBlockIfEmpty(level, mutableBlockPos.method_25504(origin, x1, y, z2), state);
				setBlockIfEmpty(level, mutableBlockPos.method_25504(origin, x2, y, z1), state);
			}
		}
	}

	private void setBlockIfEmpty(class_1936 level, class_2338.class_2339 mutableBlockPos, class_2680 state) {
		if (!level.method_8320(mutableBlockPos).method_26216(level, mutableBlockPos)) {
			method_13153(level, mutableBlockPos, state);
		}
	}

	private static boolean isBlock(int x, int z, int stage) {
		int xRad = Math.min(Math.abs(x), Math.abs(x - 1));
		int zRad = Math.min(Math.abs(z), Math.abs(z - 1));
		int sum = xRad + zRad;

		if (stage == 2 || stage == 3) return sum < 1;
		if (stage == 4 || stage == 5) return sum < 2;
		if (stage == 6) return sum == 2;
		if (stage == 7) return sum == 3 || (xRad == 2 && zRad == 2);

		return false;
	}

	protected int getTreeRadiusForHeight(int radius, int height) {
		return height < 8 ? radius : 0;
	}
}
