package net.invictusslayer.slayersbeasts.world.level.gen.feature.tree.foliage;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.invictusslayer.slayersbeasts.registries.SBFoliagePlacers;
import net.minecraft.class_2338;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4648;
import net.minecraft.class_5819;
import net.minecraft.class_6017;

public class RedwoodFoliagePlacer extends class_4647 {
	public static final MapCodec<RedwoodFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> method_30411(instance).and(
			instance.group(class_6017.method_35004(0, 15).fieldOf("mid_segments").forGetter(placer -> placer.midSegments),
					Codec.intRange(1, 3).fieldOf("trunk_width").forGetter(placer -> placer.trunkWidth)))
			.apply(instance, RedwoodFoliagePlacer::new));
	private final class_6017 midSegments;
	private final int trunkWidth;

	public RedwoodFoliagePlacer(class_6017 radius, class_6017 offset, class_6017 midStages, int trunkWidth) {
		super(radius, offset);
		this.midSegments = midStages;
		this.trunkWidth = trunkWidth;
	}

	protected class_4648<?> method_28843() {
		return SBFoliagePlacers.REDWOOD_FOLIAGE_PLACER.get();
	}

	protected void method_23448(class_3746 level, class_8179 blockSetter, class_5819 random, class_4643 config, int maxFreeTreeHeight, class_5208 attachment, int foliageHeight, int foliageRadius, int offset) {
		class_2338 pos = attachment.method_27388();

		if (trunkWidth == 1) createNormal(level, blockSetter, random, config, pos);
		if (trunkWidth == 2) createMega(level, blockSetter, random, config, pos);
		if (trunkWidth == 3) createUltra(level, blockSetter, random, config, pos);
	}

	private void createNormal(class_3746 level, class_8179 blockSetter, class_5819 random, class_4643 config, class_2338 pos) {
		int y = -4;

		method_23449(level, blockSetter, random, config, pos, 0, 1, false);
		method_23449(level, blockSetter, random, config, pos, 0, 0, false);
		method_23449(level, blockSetter, random, config, pos, 1, -1, false);
		method_23449(level, blockSetter, random, config, pos, 1, -2, false);

		for (int s = 1; s <= midSegments.method_35008(random); s++) {
			method_23449(level, blockSetter, random, config, pos, 1, y, false);
			method_23449(level, blockSetter, random, config, pos, 2, y - 1, false);
			y -= 3;
		}

		method_23449(level, blockSetter, random, config, pos, 1, y, false);
	}

	private void createMega(class_3746 level, class_8179 blockSetter, class_5819 random, class_4643 config, class_2338 pos) {
		int y = -6;

		method_23449(level, blockSetter, random, config, pos, 0, 1, true);
		method_23449(level, blockSetter, random, config, pos, 0, 0, true);
		method_23449(level, blockSetter, random, config, pos, 1, -1, true);
		method_23449(level, blockSetter, random, config, pos, 1, -2, true);
		method_23449(level, blockSetter, random, config, pos, 2, -3, true);
		method_23449(level, blockSetter, random, config, pos, 1, -4, true);

		for (int s = 1; s <= midSegments.method_35008(random); s++) {
			method_23449(level, blockSetter, random, config, pos, 2, y, true);
			method_23449(level, blockSetter, random, config, pos, 3, y - 1, true);
			method_23449(level, blockSetter, random, config, pos, 1, y - 2, true);
			y -= 4;
		}

		method_23449(level, blockSetter, random, config, pos, 1, y, true);
		method_23449(level, blockSetter, random, config, pos, 2, y - 1, true);
	}

	private void createUltra(class_3746 level, class_8179 blockSetter, class_5819 random, class_4643 config, class_2338 pos) {
		boolean variant = random.method_43056();
		int y = -10;

		method_23449(level, blockSetter, random, config, pos, 0, 2, false);
		method_23449(level, blockSetter, random, config, pos, 0, 1, false);
		method_23449(level, blockSetter, random, config, pos, 1, 0, false);
		method_23449(level, blockSetter, random, config, pos, 1, -1, false);
		method_23449(level, blockSetter, random, config, pos, 1, -2, false);
		method_23449(level, blockSetter, random, config, pos, 2, -3, false);
		method_23449(level, blockSetter, random, config, pos, 2, -4, false);
		method_23449(level, blockSetter, random, config, pos, variant ? 2 : 3, -5, false);
		method_23449(level, blockSetter, random, config, pos, variant ? 3 : 2, -6, false);
		method_23449(level, blockSetter, random, config, pos, variant ? 3 : 2, -7, false);
		method_23449(level, blockSetter, random, config, pos, variant ? 2 : 3, -8, false);

		for (int s = 1; s <= midSegments.method_35008(random); s++) {
			int i = random.method_43048(2);
			method_23449(level, blockSetter, random, config, pos, i + 1, y, false);
			method_23449(level, blockSetter, random, config, pos, i + 3, y - 1, false);
			method_23449(level, blockSetter, random, config, pos, i + 4, y - 2, false);
			method_23449(level, blockSetter, random, config, pos, i + 2 + random.method_43048(2), y - 3, false);
			y -= 5;
		}

		method_23449(level, blockSetter, random, config, pos, 3, y, false);
		method_23449(level, blockSetter, random, config, pos, 4, y - 1, false);
		method_23449(level, blockSetter, random, config, pos, 2, y - 2, false);

		method_23449(level, blockSetter, random, config, pos, 2, y - 4, false);
		method_23449(level, blockSetter, random, config, pos, 3, y - 5, false);
	}

	public int method_26989(class_5819 random, int height, class_4643 config) {
		return 2;
	}

	protected boolean method_23451(class_5819 random, int x, int y, int z, int range, boolean large) {
		return x * x + z * z > range * range;
	}
}
