package net.invictusslayer.slayersbeasts.world.level.gen.feature.tree.foliage;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.invictusslayer.slayersbeasts.registries.SBFoliagePlacers;
import net.minecraft.class_2338;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4648;
import net.minecraft.class_5819;
import net.minecraft.class_6017;

public class StackedFoliagePlacer extends class_4647 {
	public static final MapCodec<StackedFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> method_30411(instance).and(
					Codec.intRange(1, 5).fieldOf("stacks").forGetter(placer -> placer.stacks))
			.apply(instance, StackedFoliagePlacer::new));
	private final int stacks;

	public StackedFoliagePlacer(class_6017 radius, class_6017 offset, int stacks) {
		super(radius, offset);
		this.stacks = stacks;
	}

	protected class_4648<?> method_28843() {
		return SBFoliagePlacers.STACKED_FOLIAGE_PLACER.get();
	}

	protected void method_23448(class_3746 level, class_8179 blockSetter, class_5819 random, class_4643 config, int maxFreeTreeHeight, class_5208 attachment, int foliageHeight, int foliageRadius, int offset) {
		boolean flag = attachment.method_27390();
		class_2338 blockPos = attachment.method_27388().method_10086(offset);
		int r = foliageRadius + attachment.method_27389();
		int h = -stacks * 4;
		method_23449(level, blockSetter, random, config, blockPos, r - 2, h - 1, flag);
		method_23449(level, blockSetter, random, config, blockPos, r - 1, h, flag);

		for (int i = 0; i < stacks; i++) {
			int j = -4 * i;
			method_23449(level, blockSetter, random, config, blockPos, r, j - 3, flag);
			method_23449(level, blockSetter, random, config, blockPos, r, j - 2, flag);
			method_23449(level, blockSetter, random, config, blockPos, r, j - 1, flag);
			method_23449(level, blockSetter, random, config, blockPos, r - 1, j, flag);
		}

		method_23449(level, blockSetter, random, config, blockPos, r - 2, 1, flag);
	}

	public int method_26989(class_5819 random, int height, class_4643 config) {
		return 0;
	}

	protected boolean method_23451(class_5819 random, int x, int y, int z, int range, boolean large) {
		return x + z > range || x > 2 || z > 2;
	}
}
