package net.invictusslayer.slayersbeasts.world.level.gen.feature.tree.trunk;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.invictusslayer.slayersbeasts.registries.SBTrunkPlacers;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import java.util.List;
import java.util.function.BiConsumer;

public class ColossalTrunkPlacer extends class_5141 {
	public static final MapCodec<ColossalTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance ->
			instance.group(Codec.intRange(0, 60).fieldOf("base_height").forGetter(placer -> placer.baseHeight),
							Codec.intRange(0, 24).fieldOf("height_rand_a").forGetter(placer -> placer.heightRandA),
							Codec.intRange(0, 24).fieldOf("height_rand_b").forGetter(placer -> placer.heightRandB))
					.apply(instance, ColossalTrunkPlacer::new));
	protected final int baseHeight;
	protected final int heightRandA;
	protected final int heightRandB;

	public ColossalTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
		super(baseHeight, heightRandA, heightRandB);
		this.field_23760 = baseHeight;
		this.field_23761 = heightRandA;
		this.field_23762 = heightRandB;
	}

	protected class_5142<?> method_28903() {
		return SBTrunkPlacers.COLOSSAL_TRUNK_PLACER.get();
	}

	public List<class_4647.class_5208> method_26991(class_3746 level, BiConsumer<class_2338, class_2680> blockSetter, class_5819 random, int freeTreeHeight, class_2338 pos, class_4643 config) {
		for (int i = 1; i <= 2; i++) {
			class_2338 dirtPos = pos.method_10079(class_2350.field_11033, i);
			method_27400(level, blockSetter, random, dirtPos, config);
			method_27400(level, blockSetter, random, dirtPos.method_10078(), config);
			method_27400(level, blockSetter, random, dirtPos.method_10078().method_10078(), config);
			method_27400(level, blockSetter, random, dirtPos.method_10072(), config);
			method_27400(level, blockSetter, random, dirtPos.method_10072().method_10078(), config);
			method_27400(level, blockSetter, random, dirtPos.method_10072().method_10078().method_10078(), config);
			method_27400(level, blockSetter, random, dirtPos.method_10072().method_10072(), config);
			method_27400(level, blockSetter, random, dirtPos.method_10072().method_10072().method_10078(), config);
			method_27400(level, blockSetter, random, dirtPos.method_10072().method_10072().method_10078().method_10078(), config);
			method_27400(level, blockSetter, random, dirtPos.method_10072().method_10067(), config);
			method_27400(level, blockSetter, random, dirtPos.method_10095().method_10078(), config);
			method_27400(level, blockSetter, random, dirtPos.method_10072().method_10072().method_10072().method_10078(), config);
			method_27400(level, blockSetter, random, dirtPos.method_10072().method_10078().method_10078().method_10078(), config);
		}
		class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();

		int root = 3 + random.method_43048(5);
		int base = root + 4 + random.method_43048(5);
		int top = 3 + random.method_43048(3);
		for (int i = 0; i < freeTreeHeight; ++i) {
			if (i < root) {
				placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, -1);
				placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, -1, i, 1);
				placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 3);
				placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 3, i, 1);
			}
			if (i < base) {
				placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, 0);
				placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 2, i, 0);
				placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, 2);
				placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 2, i, 2);
			}
			if (i < freeTreeHeight - top) {
				placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 0);
				placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, 1);
				placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 2, i, 1);
				placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 2);
			}
			placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 1);
		}

		return ImmutableList.of(new class_4647.class_5208(pos.method_10086(freeTreeHeight).method_10072().method_10078(), 0, false));
	}

	private void placeLogIfFreeWithOffset(class_3746 level, BiConsumer<class_2338, class_2680> blockSetter, class_5819 random, class_2338.class_2339 pos, class_4643 config, class_2338 origin, int x, int y, int z) {
		pos.method_25504(origin, x, y, z);
		this.method_27401(level, blockSetter, random, pos, config);
	}
}