package net.invictusslayer.slayersbeasts.world.level.gen.structure;

import net.invictusslayer.slayersbeasts.SlayersBeasts;
import net.invictusslayer.slayersbeasts.data.tags.SBTags;
import net.invictusslayer.slayersbeasts.world.level.biome.SBBiomes;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.structures.CryptPortalStructure;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.structures.CryptStructure;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3785;
import net.minecraft.class_5321;
import net.minecraft.class_5434;
import net.minecraft.class_5843;
import net.minecraft.class_5847;
import net.minecraft.class_6121;
import net.minecraft.class_6885;
import net.minecraft.class_7061;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.pools.CryptPools;
import net.invictusslayer.slayersbeasts.world.level.gen.structure.pools.RedwoodLodgePools;
import java.util.Map;

public class SBStructures {
	public static final class_5321<class_3195> CRYPT = createKey("crypt");
	public static final class_5321<class_3195> CRYPT_PORTAL = createKey("crypt_portal");
	public static final class_5321<class_3195> REDWOOD_LODGE = createKey("redwood_lodge");

	public static void bootstrap(class_7891<class_3195> context) {
		class_7871<class_3785> pools = context.method_46799(class_7924.field_41249);
		class_7871<class_1959> biomes = context.method_46799(class_7924.field_41236);

		context.method_46838(CRYPT, new CryptStructure(structure(class_6885.method_40246(biomes.method_46747(SBBiomes.THE_CRYPT)), Map.of(), class_2893.class_2895.field_13172, class_5847.field_28922), pools.method_46747(CryptPools.START), class_6121.method_35383(class_5843.method_33841(60))));
		context.method_46838(CRYPT_PORTAL, new CryptPortalStructure(structure(biomes.method_46735(SBTags.Biomes.HAS_CRYPT_PORTAL), class_5847.field_38431)));
		context.method_46838(REDWOOD_LODGE, new class_5434(structure(biomes.method_46735(SBTags.Biomes.HAS_REDWOOD_LODGE), class_5847.field_38431), pools.method_46747(RedwoodLodgePools.START), 3, class_6121.method_35383(class_5843.method_33841(0)), false, class_2902.class_2903.field_13194));
	}

	private static class_3195.class_7302 structure(class_6885<class_1959> biomes, Map<class_1311, class_7061> spawns, class_2893.class_2895 step, class_5847 terrain) {
		return new class_3195.class_7302(biomes, spawns, step, terrain);
	}

	private static class_3195.class_7302 structure(class_6885<class_1959> biomes, class_5847 terrain) {
		return structure(biomes, Map.of(), class_2893.class_2895.field_13173, terrain);
	}

	private static class_5321<class_3195> createKey(String name) {
		return class_5321.method_29179(class_7924.field_41246, class_2960.method_60655(SlayersBeasts.MOD_ID, name));
	}
}
